/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class TransBillChangePayAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject dbTransBill = QueryServiceHelper.queryOne((String)data.getString("sourcebilltype"), (String)"id, billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("sourcebillid"))});
            Object billStatus = dbTransBill.get("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillChgpaySubmitValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            boolean existsChangePay = QueryServiceHelper.exists((String)"fca_transchgbill", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", dbTransBill.get("id")), new QFilter("id", "<>", data.getPkValue()), new QFilter("billstatus", "<>", (Object)BillStatusEnum.AUDIT.getValue())});
            if (!existsChangePay) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\uff0c\u65e0\u6cd5\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillChgpaySubmitValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }
}

