/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransBillChangePayBeforeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("ischangepaych");
        selector.add("entrys.paystatus");
        selector.add("entrys.state");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillChangePayBeforeValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (data.getBoolean("ischangepaych")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillChangePayBeforeValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            boolean hasChgpayFlag = false;
            for (DynamicObject entry : entries) {
                String payStatus = entry.getString("paystatus");
                String state = entry.getString("state");
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransDetailStatusEnum.DELETE.getValue().equals(state) || !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus) && !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus)) continue;
                hasChgpayFlag = true;
            }
            Optional<DynamicObject> isAllHas = entries.stream().filter(e -> (FcaTransDetailStatusEnum.NORMAL.getValue().equals(e.getString("state")) || FcaTransDetailStatusEnum.BACK.getValue().equals(e.getString("state"))) && !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(e.getString("paystatus")) && !FcaTransPayStatusEnum.INIT.getValue().equals(e.getString("paystatus"))).findFirst();
            if (isAllHas.isPresent()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u4ed8\u6b3e\u72b6\u6001\u5fc5\u987b\u5168\u4e3a\u51c6\u5907\u63d0\u4ea4\u548c\u4ea4\u6613\u5931\u8d25\u3002", (String)"TransBillChangePayBeforeValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            if (hasChgpayFlag) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u660e\u7ec6\u6570\u636e\uff0c\u65e0\u6cd5\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillChangePayBeforeValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }
}

