/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.helper.SystemParameterHelper;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;

public class TransBillPayPushCasInnerValidator
extends AbsTransBillValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity transBill : dataEntity) {
            DynamicObject info = transBill.getDataEntity();
            String name = info.getDataEntityType().getName();
            if (!"fca_transupbill".equals(name) && !"fca_transdownbill".equals(name)) continue;
            if (!BillStatusEnum.PAYED.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(transBill, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u975e\u5df2\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"TransBillPayPushCasValidator_10", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entries = info.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                DynamicObject subOrg = entry.getDynamicObject("subacct_company");
                if (!SystemParameterHelper.isShowInternalAccount((long)subOrg.getLong("id"))) {
                    this.addErrorMessage(transBill, ResManager.loadKDString((String)"\u542f\u7528\u5c55\u793a\u5185\u90e8\u91d1\u878d\u673a\u6784\u5f00\u7acb\u7684\u5185\u90e8\u8d26\u6237\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"TransBillPayPushCasValidator_12", (String)"tmc-fca-business", (Object[])new Object[0]));
                }
                if (!entry.getBoolean("isinneracccashbill")) continue;
                this.addErrorMessage(transBill, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5df2\u751f\u6210\u5185\u90e8\u6237\u56de\u5355\u3002", (String)"TransBillPayPushCasValidator_105", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            if (TransBillHelper.isInnerAcctTrans((DynamicObject)info)) continue;
            this.addErrorMessage(transBill, ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5185\u90e8\u8d26\u53f7\u4e3a\u7a7a\u6216\u8005\u662f\u5426\u4e0b\u63a8\u5185\u90e8\u91d1\u878d\u4e3a\u5426\u3002", (String)"TransBillPayPushCasValidator_11", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }
}

