/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.compare.BPlusTree;
import kd.tmc.fca.common.compare.CompareData;
import kd.tmc.fca.common.compare.CompareResult;
import kd.tmc.fca.common.compare.CompareServiceImpl;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.enums.SymbolEnum;
import kd.tmc.fca.common.util.SysParameterHelp;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TransBillSaveValidator
extends AbsTransBillValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("byAutoTrans", "false")) || this.getOption().getVariables().get("discardFlag") != null) {
            return;
        }
        BillEntityType billEntityType = (BillEntityType)dataEntity[0].getDataEntity().getDataEntityType();
        String entityName = billEntityType.getName();
        Map<ExtendedDataEntity, Pair<Boolean, String>> validateEntryRule = this.validateEntryRule(dataEntity);
        List<Long> eSourceBillEntryIdList = Arrays.stream(dataEntity).filter(d -> FcaTransSourceTypeEnum.GENERATE.getValue().equals(d.getDataEntity().getString("sourcetype")) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(d.getDataEntity().getString("sourcetype"))).map(d -> d.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("e_sourcebillentryid"))).map(d -> d.getLong("e_sourcebillentryid"))).collect(Collectors.toList());
        List<Long> idList = Arrays.stream(dataEntity).filter(d -> FcaTransSourceTypeEnum.GENERATE.getValue().equals(d.getDataEntity().getString("sourcetype")) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(d.getDataEntity().getString("sourcetype"))).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        List<Long> existsEntryIdList = this.repeatCheck(idList, eSourceBillEntryIdList, entityName);
        BPlusTree<Long, CompareData> sourceTree = this.buildSourceTree(entityName, eSourceBillEntryIdList);
        BPlusTree<Long, CompareData> targetTree = this.buildTargetTree(dataEntity);
        CompareServiceImpl compareService = new CompareServiceImpl(sourceTree, targetTree);
        BPlusTree resultTree = compareService.invoke();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Pair<Boolean, String> pairPush;
            Pair<Boolean, String> pair;
            DynamicObject bill = extendedDataEntity.getDataEntity();
            if (validateEntryRule != null && (pair = validateEntryRule.get(extendedDataEntity)) != null && !((Boolean)pair.getLeft()).booleanValue()) {
                this.addErrorMessage(extendedDataEntity, (String)pair.getRight());
                continue;
            }
            String sourceType = extendedDataEntity.getDataEntity().getString("sourcetype");
            if ((FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(sourceType)) && !((Boolean)(pairPush = this.checkPush(bill)).getLeft()).booleanValue()) {
                this.addErrorMessage(extendedDataEntity, (String)pairPush.getRight());
            }
            if (FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(sourceType)) {
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
                Long sourceBillId = bill.getLong("sourcebillid");
                for (CompareResult compareResult : resultTree.search((Comparable)sourceBillId)) {
                    String message;
                    String fieldName;
                    if (!Objects.equals(bill.getPkValue(), compareResult.getId())) continue;
                    if (compareResult.isCheckSource()) {
                        fieldName = ((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.getSourceEntityName(entityName)).getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                        message = String.format(ResManager.loadKDString((String)"\u6e90\u5355%1$s\u5fc5\u987b%2$s%3$s\u3002", (String)"CompareValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]), fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                        this.addErrorMessage(extendedDataEntity, message);
                        continue;
                    }
                    fieldName = ((IDataEntityProperty)billEntityType.getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                    message = String.format(ResManager.loadKDString((String)"%1$s\u5fc5\u987b%2$s%3$s\u3002", (String)"CompareValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]), fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                    this.addErrorMessage(extendedDataEntity, message);
                }
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    Long sourceBillEntryId = entry.getLong("e_sourcebillentryid");
                    if (existsEntryIdList.contains(sourceBillEntryId)) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%1$d\u6761\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CompareValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    for (CompareResult compareResult : resultTree.search((Comparable)sourceBillEntryId)) {
                        if (!Objects.equals(entry.getPkValue(), compareResult.getId())) continue;
                        String fieldName = ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                        String message = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%1$d\u6761%2$s\u5fc5\u987b%3$s%4$s\u3002", (String)"CompareValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1, fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                        this.addErrorMessage(extendedDataEntity, message);
                    }
                }
            }
            this.validateDownIntelSourceType(bill, extendedDataEntity);
            this.validateUpIntelSourceType(bill, extendedDataEntity);
        }
    }

    private Pair<Boolean, String> checkPush(DynamicObject dynamicObject) {
        String check;
        Long endSon;
        DynamicObjectCollection collection;
        String returnDataByOpHand;
        HashMap map = new HashMap(6);
        Long sonAccId = null;
        DynamicObject payFlag = dynamicObject.getDynamicObject("payflag");
        if (payFlag == null || "0".equals(payFlag.getString("type"))) {
            return Pair.of((Object)true, (Object)"");
        }
        if (this.getOption().containsVariable("returnDataByOpHand") && (map = (HashMap)SerializationUtils.fromJsonString((String)(returnDataByOpHand = this.getOption().getVariableValue("returnDataByOpHand")), Map.class)).containsKey("sonacct")) {
            sonAccId = (Long)map.get("sonacct");
        }
        if ((collection = dynamicObject.getDynamicObjectCollection("entrys")).isEmpty()) {
            return Pair.of((Object)false, (Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5212\u62e8\u660e\u7ec6\u4fe1\u606f\u3002", (String)"AbsTransBillValidator_5", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        DynamicObject sonAcc = ((DynamicObject)collection.get(0)).getDynamicObject("subacct");
        if (sonAccId != null) {
            endSon = sonAccId;
        } else {
            Long l = endSon = sonAcc == null ? null : Long.valueOf(sonAcc.getLong("id"));
        }
        if (endSon == null) {
            return Pair.of((Object)false, (Object)ResManager.loadKDString((String)"\u5212\u62e8\u660e\u7ec6\u5b50\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsTransBillValidator_19", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        Long acct = dynamicObject.getDynamicObject("accountbank").getLong("id");
        Long company = dynamicObject.getDynamicObject("company").getLong("id");
        Long group = null;
        if (map.containsKey("group")) {
            group = (Long)map.get("group");
        }
        if (StringUtils.isNotBlank((CharSequence)(check = this.checkAcc(endSon, acct, company, group)))) {
            return Pair.of((Object)false, (Object)check);
        }
        return Pair.of((Object)true, (Object)"");
    }

    private String checkAcc(Long endSon, Long acct, Long company, Long group) {
        boolean exists;
        Long pOrg;
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acct)});
        if (account != null && (pOrg = Long.valueOf(account.getLong("company"))).compareTo(company) != 0) {
            return ResManager.loadKDString((String)"\u5165\u8d26\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u8d44\u91d1\u7ec4\u7ec7\u548c\u6bcd\u8d26\u6237\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u5339\u914d\u3002", (String)"AbsTransBillValidator_22", (String)"tmc-fca-business", (Object[])new Object[0]);
        }
        boolean isFlag = SysParameterHelp.getFcaParameterBoolean((long)company, (String)"isunacctgroup");
        if (!isFlag && !(exists = group == null ? QueryServiceHelper.exists((String)"fca_acctgroup", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)endSon), new QFilter("accountbank", "=", (Object)acct), new QFilter("enable", "=", (Object)true)}) : QueryServiceHelper.exists((String)"fca_acctgroup", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)group), new QFilter("accountbank", "=", (Object)acct), new QFilter("enable", "=", (Object)true)}))) {
            return ResManager.loadKDString((String)"\u5165\u8d26\u5931\u8d25\uff0c\u5165\u8d26\u8d26\u53f7\u4e0d\u662f\u6bcd\u8d26\u6237\uff1b\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u8d44\u91d1\u5212\u62e8\u4e1a\u52a1\uff0c\u5982\u660e\u786e\u662f\u5212\u62e8\u4e1a\u52a1\uff0c\u8bf7\u7ef4\u62a4\u6bcd\u5b50\u8d26\u6237\u7ec4\u4fe1\u606f\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6253\u5f00\u8d44\u91d1\u8c03\u5ea6\u5e94\u7528\u3010\u5141\u8bb8\u975e\u6bcd\u5b50\u8d26\u6237\u7ec4\u8fdb\u884c\u4e0a\u5212\u4e0b\u62e8\u3011\u53c2\u6570\u3002", (String)"AbsTransBillValidator_21", (String)"tmc-fca-business", (Object[])new Object[0]);
        }
        return null;
    }

    private String getSourceEntityName(String entityName) {
        if ("fca_transupbill".equals(entityName)) {
            return "fca_applytransupbill";
        }
        return "fca_applytransdownbill";
    }

    private void validateDownIntelSourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String meteName = info.getDynamicObjectType().getName();
        String sourceBillType = info.getString("sourcetype");
        DynamicObject paymentEntity = info.getDynamicObject("payflag");
        if (!"fca_transdownbill".equals(meteName) || !"paypassive".equals(sourceBillType) || paymentEntity == null) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u88ab\u52a8\u4ed8\u6b3e\u5165\u8d26\u4e0b\u63a8\u751f\u6210\u7684\u4e0b\u62e8\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u4e0b\u62e8\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8", (String)"AbsTransBillValidator_27", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }

    private void validateUpIntelSourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String meteName = info.getDynamicObjectType().getName();
        String sourceBillType = info.getString("sourcetype");
        DynamicObject paymentEntity = info.getDynamicObject("payflag");
        if (!"fca_transupbill".equals(meteName) || !"recinitiative".equals(sourceBillType) || paymentEntity == null) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3\u4e0b\u63a8\u751f\u6210\u7684\u4e0a\u5212\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u4e0a\u5212\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8", (String)"AbsTransBillValidator_28", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }

    private List<Long> repeatCheck(List<Long> idList, List<Long> entryIdList, String entityName) {
        QFilter filter = new QFilter("id", "not in", idList);
        filter.and(new QFilter("entrys.e_sourcebillentryid", "in", entryIdList));
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)entityName, (String)"entrys.e_sourcebillentryid", (QFilter[])filter.toArray());
        return applyBills.stream().map(b -> b.getLong("entrys.e_sourcebillentryid")).collect(Collectors.toList());
    }

    private BPlusTree<Long, CompareData> buildSourceTree(String entityName, List<Long> eSourceBillEntryIdList) {
        BPlusTree sourceTree = new BPlusTree();
        if (!eSourceBillEntryIdList.isEmpty()) {
            DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)this.getSourceEntityName(entityName), (String)"id, currency, currency.amtprecision, billstatus, currency.name, entrys.id, entrys.transamt", (QFilter[])new QFilter[]{new QFilter("entrys.id", "in", eSourceBillEntryIdList)});
            for (DynamicObject sourceBill : sourceBills) {
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("id")), (Object)new CompareData("billstatus", (Object)sourceBill.getString("billstatus")));
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("id")), (Object)new CompareData("currency", (Object)sourceBill.getLong("currency"), (Object)sourceBill.getString("currency.name")));
                BigDecimal sourceAmount = sourceBill.getBigDecimal("entrys.transamt").setScale(sourceBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP);
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("entrys.id")), (Object)new CompareData("transamt", (Object)sourceBill.getBigDecimal("entrys.transamt"), (Object)sourceAmount));
            }
        }
        return sourceTree;
    }

    private BPlusTree<Long, CompareData> buildTargetTree(ExtendedDataEntity[] dataEntity) {
        BPlusTree targetTree = new BPlusTree();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObject currency = bill.getDynamicObject("currency");
            Object currencyId = currency == null ? null : currency.getPkValue();
            String sourceType = bill.getString("sourcetype");
            if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType) && !FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(sourceType)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Long)bill.getLong("sourcebillid"))) {
                targetTree.insert((Comparable)Long.valueOf(bill.getLong("sourcebillid")), (Object)new CompareData(bill.getPkValue(), "billstatus", (Object)BillStatusEnum.AUDIT.getValue(), (Object)BillStatusEnum.AUDIT.getName(), true));
                targetTree.insert((Comparable)Long.valueOf(bill.getLong("sourcebillid")), (Object)new CompareData(bill.getPkValue(), "currency", currencyId, SymbolEnum.EQUALS));
            }
            if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType)) continue;
            for (DynamicObject entry : entries) {
                if (!EmptyUtil.isNoEmpty((Long)entry.getLong("e_sourcebillentryid"))) continue;
                targetTree.insert((Comparable)Long.valueOf(entry.getLong("e_sourcebillentryid")), (Object)new CompareData(entry.getPkValue(), "transamt", (Object)entry.getBigDecimal("transamt"), SymbolEnum.LESS_EQUALS));
            }
        }
        return targetTree;
    }
}

