/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class TxLockValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List businessIdList = Arrays.stream(extendedDataEntities).map(d -> String.valueOf(d.getDataEntity().getPkValue())).filter(d -> !"0".equals(d)).distinct().collect(Collectors.toList());
        if (businessIdList.isEmpty()) {
            return;
        }
        String isLock = "false";
        if (this.getOption().containsVariable("isLock")) {
            isLock = this.getOption().getVariableValue("isLock");
        }
        if ("true".equals(isLock)) {
            return;
        }
        List lockBusinessIds = TxCheckUtil.loadUnfinishedTx(businessIdList);
        if (!lockBusinessIds.isEmpty()) {
            for (ExtendedDataEntity dataEntity : extendedDataEntities) {
                DynamicObject info = dataEntity.getDataEntity();
                if (!lockBusinessIds.contains(String.valueOf(info.getPkValue()))) continue;
                String message = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"TxLockValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
        }
    }
}

