/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.report.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.StatisCycleEnum;

public class TransBillSumReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String UP_BANK_SELECT = "company.name as parentorg, company.id as parentorgid, bank.name as bank, bank.id as bankid, currency, entrys.transamt as upamount, 0 as downamount";
    private static final String UP_SON_ORG_SELECT = "company.name as parentorg, company.id as parentorgid, entrys.subacct_company.name as sonorg, entrys.subacct_company.id as sonorgid, currency, entrys.transamt as upamount, 0 as downamount";
    private static final String DOWN_BANK_SELECT = "company.name as parentorg, company.id as parentorgid, bank.name as bank, bank.id as bankid, currency, 0 as upamount, entrys.transamt as downamount";
    private static final String DOWN_SON_ORG_SELECT = "company.name as parentorg, company.id as parentorgid, entrys.subacct_company.name as sonorg, entrys.subacct_company.id as sonorgid, currency, 0 as upamount, entrys.transamt as downamount";
    private static final String BANK_SELECT = "parentorg, parentorgid, bank, bankid, upamount_report as upamount, downamount_report as downamount";
    private static final String SON_ORG_SELECT = "parentorg, parentorgid, sonorg, sonorgid, upamount_report as upamount, downamount_report as downamount";
    private static final String[] BANK_GROUP_SELECT = new String[]{"parentorg", "parentorgid", "bank", "bankid"};
    private static final String[] SON_ORG_GROUP_SELECT = new String[]{"parentorg", "parentorgid", "sonorg", "sonorgid"};
    private List<String> sumAmountFieldList;
    private String sumNameField;
    private boolean isCompute = true;

    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        String[] groupSelect;
        String select;
        String downSelect;
        String upSelect;
        Map paramMap = this.transQueryParam(reportQueryParam);
        QFilter filter = this.initFilter(paramMap);
        if ("bank".equals(paramMap.get("filter_dimension"))) {
            upSelect = UP_BANK_SELECT;
            downSelect = DOWN_BANK_SELECT;
            select = BANK_SELECT;
            groupSelect = BANK_GROUP_SELECT;
            this.setSumNameField("bank");
        } else {
            upSelect = UP_SON_ORG_SELECT;
            downSelect = DOWN_SON_ORG_SELECT;
            select = SON_ORG_SELECT;
            groupSelect = SON_ORG_GROUP_SELECT;
            this.setSumNameField("sonorg");
        }
        DataSet upDataSet = QueryServiceHelper.queryDataSet((String)"fca_transupbill", (String)"fca_transupbill", (String)upSelect, (QFilter[])filter.toArray(), (String)"company");
        DataSet downDataSet = QueryServiceHelper.queryDataSet((String)"fca_transdownbill", (String)"fca_transdownbill", (String)downSelect, (QFilter[])filter.toArray(), (String)"company");
        DataSet dataSet = upDataSet.union(downDataSet);
        dataSet = this.addExchangeRateAndCurrencyUnit(dataSet, paramMap);
        dataSet = dataSet.select(select);
        this.isCompute = false;
        GroupbyDataSet group = dataSet.groupBy(groupSelect);
        dataSet = group.sum("upamount").sum("downamount").finish();
        ArrayList<String> sumAmountFieldList = new ArrayList<String>(2);
        sumAmountFieldList.add("upamount");
        sumAmountFieldList.add("downamount");
        sumAmountFieldList.add("differenceamount");
        this.setSumAmountFieldList(sumAmountFieldList);
        dataSet = dataSet.addField("upamount - downamount", "differenceamount");
        Object statCurrency = ((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        dataSet = dataSet.addField(String.valueOf(statCurrency), "currency");
        return dataSet;
    }

    public List<String> groupFields() {
        ArrayList<String> groupFieldList = new ArrayList<String>(2);
        groupFieldList.add("parentorg");
        groupFieldList.add("parentorgid");
        return groupFieldList;
    }

    public List<String> sumAmountFields() {
        if (this.sumAmountFieldList == null) {
            ArrayList<String> sumAmountFieldList = new ArrayList<String>(2);
            sumAmountFieldList.add("upamount");
            sumAmountFieldList.add("downamount");
            this.sumAmountFieldList = sumAmountFieldList;
        }
        return this.sumAmountFieldList;
    }

    public void setSumAmountFieldList(List<String> sumAmountFieldList) {
        this.sumAmountFieldList = sumAmountFieldList;
    }

    public String sumNameField() {
        return this.sumNameField;
    }

    public void setSumNameField(String sumNameField) {
        this.sumNameField = sumNameField;
    }

    public List<String> orinalAmountField() {
        return this.sumAmountFields();
    }

    private QFilter initFilter(Map<String, Object> paramMap) {
        Date endDate;
        Date startDate;
        QFilter filter = new QFilter("entrys.state", "=", (Object)FcaTransDetailStatusEnum.NORMAL.getValue());
        filter.and(new QFilter("entrys.paystatus", "=", (Object)FcaTransPayStatusEnum.PAYSUCCESS.getValue()));
        if (paramMap.get("filter_bank") != null) {
            DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
            List bankIdList = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            filter.and("bank", "in", bankIdList);
        }
        if (paramMap.get("filter_org") != null) {
            filter.and("company", "in", paramMap.get("filter_org"));
        }
        if (paramMap.get("filter_sonorg") != null) {
            filter.and("entrys.subacct_company", "in", paramMap.get("filter_sonorg"));
        }
        if (paramMap.get("filter_accountgroup") != null) {
            filter.and("acctgrpid", "in", paramMap.get("filter_accountgroup"));
        }
        if (paramMap.get("filter_currency") != null) {
            DynamicObjectCollection currencies = (DynamicObjectCollection)paramMap.get("filter_currency");
            List currencyIdList = currencies.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            filter.and("currency", "in", currencyIdList);
        }
        String filterPeriod = (String)paramMap.get("filter_period");
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstDayOfCurMonth();
            endDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            endDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstDayOfCurYear();
            endDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            endDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterPeriod)) {
            startDate = currDate;
            endDate = DateUtils.getNextDay((Date)currDate, (int)1);
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterPeriod)) {
            startDate = (Date)paramMap.get("filter_startdate");
            endDate = (Date)paramMap.get("filter_enddate");
            endDate = DateUtils.getNextDay((Date)endDate, (int)1);
        } else {
            startDate = DateUtils.getFirstDayOfCurMonth();
            endDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        }
        filter.and("entrys.paydate", ">=", (Object)startDate);
        filter.and("entrys.paydate", "<", (Object)endDate);
        if (paramMap.get("orgIdList") != null) {
            filter.and("company", "in", paramMap.get("orgIdList"));
        }
        return filter;
    }

    protected boolean isNeedCurrencyUnit() {
        return this.isCompute;
    }

    protected boolean isNeedDimCurrency() {
        return this.isCompute;
    }
}

