/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.report.form;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.StatisCycleEnum;

public class TransBillDetailReportFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String SYSTEM_TYPE = "tmc-fca-report";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit accountGroup = (BasedataEdit)this.getControl("filter_accountgroup");
        accountGroup.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection parentOrg = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (parentOrg != null && !parentOrg.isEmpty()) {
                List orgIdList = parentOrg.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
                evt.getCustomQFilters().add(new QFilter("company", "in", orgIdList));
            }
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        BasedataEdit org = (BasedataEdit)this.getControl("filter_org");
        org.setQFilter(new QFilter("id", "in", this.getAuthParentOrgList(authOrgList)));
        BasedataEdit sonOrg = (BasedataEdit)this.getControl("filter_sonorg");
        sonOrg.setQFilter(new QFilter("id", "in", this.getAuthSonOrgList(authOrgList)));
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        BasedataEdit currency = (BasedataEdit)this.getControl("filter_currency");
        currency.setQFilter(new QFilter("id", "in", this.getCurrencyIdList()));
        BasedataEdit bank = (BasedataEdit)this.getControl("filter_bank");
        bank.setQFilter(new QFilter("id", "in", this.getBankIdList(authOrgList)));
        BasedataEdit accountGroup = (BasedataEdit)this.getControl("filter_accountgroup");
        accountGroup.setQFilter(new QFilter("id", "in", this.getAccountGroupIdList(authOrgList)));
        if ("transbill_report".equals(formShowParameter.getParentFormId())) {
            Map customParams = formShowParameter.getCustomParams();
            if (customParams.get("filter_org") != null) {
                JSONArray parentOrgIds = (JSONArray)customParams.get("filter_org");
                this.getModel().setValue("filter_org", (Object)parentOrgIds.toArray());
            }
            if (customParams.get("filter_bank") != null) {
                JSONArray bankIds = (JSONArray)customParams.get("filter_bank");
                this.getModel().setValue("filter_bank", (Object)bankIds.toArray());
            }
            if (customParams.get("filter_sonorg") != null) {
                JSONArray sonOrgIds = (JSONArray)customParams.get("filter_sonorg");
                this.getModel().setValue("filter_sonorg", (Object)sonOrgIds.toArray());
            }
            if (customParams.get("filter_currency") != null) {
                JSONArray currencyIds = (JSONArray)customParams.get("filter_currency");
                this.getModel().setValue("filter_currency", (Object)currencyIds.toArray());
            }
            if (customParams.get("filter_accountgroup") != null) {
                JSONArray accountGroupIds = (JSONArray)customParams.get("filter_accountgroup");
                this.getModel().setValue("filter_accountgroup", (Object)accountGroupIds.toArray());
            }
            if (customParams.get("filter_biztype") != null) {
                this.getModel().setValue("filter_biztype", customParams.get("filter_biztype"));
            }
            this.getModel().setValue("filter_period", customParams.get("filter_period"));
            this.getModel().setValue("filter_startdate", customParams.get("filter_startdate"));
            this.getModel().setValue("filter_enddate", customParams.get("filter_enddate"));
            this.getModel().setValue("filter_statcurrency", customParams.get("filter_statcurrency"));
            this.getModel().setValue("filter_currencyunit", customParams.get("filter_currencyunit"));
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        } else {
            this.setDefaultOrg();
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection accountGroup;
        super.beforeQuery(queryParam);
        String queryAuth = (String)this.getModel().getValue("filter_queryauth");
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if ("parentorg".equals(queryAuth)) {
            queryParam.getFilter().addFilterItem("orgIdList", this.getAuthParentOrgList(authOrgList));
        } else {
            queryParam.getFilter().addFilterItem("orgIdList", this.getAuthSonOrgList(authOrgList));
        }
        DynamicObjectCollection sonOrg = (DynamicObjectCollection)this.getModel().getValue("filter_sonorg");
        if (sonOrg != null && !sonOrg.isEmpty()) {
            List orgIdList = sonOrg.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            queryParam.getFilter().getFilterItem("filter_sonorg").setValue(orgIdList);
        }
        if ((accountGroup = (DynamicObjectCollection)this.getModel().getValue("filter_accountgroup")) != null && !accountGroup.isEmpty()) {
            List accountGroupIdList = accountGroup.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            queryParam.getFilter().getFilterItem("filter_accountgroup").setValue(accountGroupIdList);
        }
    }

    public boolean verifyQuery(ReportQueryParam param) {
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)param);
        String filterPeriod = (String)paramMap.get("filter_period");
        if (EmptyUtil.isEmpty((String)filterPeriod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5468\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (Objects.equals(StatisCycleEnum.CONSTOM.getCode(), filterPeriod) && (paramMap.get("filter_startdate") == null || paramMap.get("filter_enddate") == null)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty(paramMap.get("filter_biztype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if ("billno".equals(event.getFieldName())) {
            int rowIndex = event.getRowIndex();
            ReportList reportList = (ReportList)event.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String sourceBillId = rowData.getString("id");
            String bizType = rowData.getString("biztype");
            IReportView view = this.getView();
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setPkId((Object)sourceBillId);
            parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId(bizType);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private List<Long> getAuthParentOrgList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"company", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("company")).collect(Collectors.toList());
    }

    private List<Long> getAuthSonOrgList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("entrys.bankacct.company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"entrys.bankacct.company", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("entrys.bankacct.company")).collect(Collectors.toList());
    }

    private List<Long> getCurrencyIdList() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"currency", (QFilter[])new QFilter[]{filter});
        return groupAccount.stream().map(g -> g.getLong("currency")).collect(Collectors.toList());
    }

    private List<Long> getBankIdList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"accountbank.bank.id", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("accountbank.bank.id")).collect(Collectors.toList());
    }

    private List<Long> getAccountGroupIdList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("id")).collect(Collectors.toList());
    }

    private void setDefaultOrg() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        this.getModel().setValue("filter_org", null);
        if (authOrgIds != null && authOrgIds.size() > 0) {
            if (authOrgIds.contains(org)) {
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                DynamicObjectCollection collection = new DynamicObjectCollection();
                collection.add((Object)bosOrg);
                this.getModel().setValue("filter_org", (Object)collection);
            } else {
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)bosOrg)) {
                    DynamicObjectCollection collection = new DynamicObjectCollection();
                    collection.add((Object)bosOrg);
                    this.getModel().setValue("filter_org", (Object)collection);
                }
            }
        }
    }
}

