/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.StatisCycleEnum;

public class TransBillSumReportFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String SYSTEM_TYPE = "tmc-fca-report";
    private static final String[] BANK_DIMENSION = new String[]{"sumlevel", "parentorg", "parentorgid", "bank", "bankid", "statcurrency", "upamount", "downamount", "differenceamount"};
    private static final String[] SON_ORG_DIMENSION = new String[]{"sumlevel", "parentorg", "parentorgid", "sonorg", "sonorgid", "statcurrency", "upamount", "downamount", "differenceamount"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit accountGroup = (BasedataEdit)this.getControl("filter_accountgroup");
        accountGroup.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection parentOrg = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (parentOrg != null && !parentOrg.isEmpty()) {
                List orgIdList = parentOrg.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
                evt.getCustomQFilters().add(new QFilter("company", "in", orgIdList));
            }
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        BasedataEdit org = (BasedataEdit)this.getControl("filter_org");
        org.setQFilter(new QFilter("id", "in", this.getAuthParentOrgList(authOrgList)));
        BasedataEdit sonOrg = (BasedataEdit)this.getControl("filter_sonorg");
        sonOrg.setQFilter(new QFilter("id", "in", this.getAuthSonOrgList(authOrgList)));
        BasedataEdit currency = (BasedataEdit)this.getControl("filter_currency");
        currency.setQFilter(new QFilter("id", "in", this.getCurrencyIdList()));
        BasedataEdit bank = (BasedataEdit)this.getControl("filter_bank");
        bank.setQFilter(new QFilter("id", "in", this.getBankIdList(authOrgList)));
        BasedataEdit accountGroup = (BasedataEdit)this.getControl("filter_accountgroup");
        accountGroup.setQFilter(new QFilter("id", "in", this.getAccountGroupIdList(authOrgList)));
        this.setDefaultOrg();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_dimension": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                rptFilter.search();
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam param) {
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)param);
        String filterPeriod = (String)paramMap.get("filter_period");
        if (EmptyUtil.isEmpty((String)filterPeriod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5468\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (Objects.equals(StatisCycleEnum.CONSTOM.getCode(), filterPeriod) && (paramMap.get("filter_startdate") == null || paramMap.get("filter_enddate") == null)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillReportFormListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection accountGroup;
        super.beforeQuery(queryParam);
        String dimension = (String)this.getModel().getValue("filter_dimension");
        queryParam.getFilter().addFilterItem("filter_dimension", (Object)dimension);
        if ("bank".equals(dimension)) {
            this.rebuildColumn(BANK_DIMENSION);
        } else {
            this.rebuildColumn(SON_ORG_DIMENSION);
        }
        DynamicObjectCollection sonOrg = (DynamicObjectCollection)this.getModel().getValue("filter_sonorg");
        if (sonOrg != null && !sonOrg.isEmpty()) {
            List orgIdList = sonOrg.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            queryParam.getFilter().getFilterItem("filter_sonorg").setValue(orgIdList);
        }
        if ((accountGroup = (DynamicObjectCollection)this.getModel().getValue("filter_accountgroup")) != null && !accountGroup.isEmpty()) {
            List accountGroupIdList = accountGroup.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            queryParam.getFilter().getFilterItem("filter_accountgroup").setValue(accountGroupIdList);
        }
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        queryParam.getFilter().addFilterItem("orgIdList", this.getAuthParentOrgList(authOrgList));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String field = evt.getFieldName();
        if ("upamount".equals(field) || "downamount".equals(field) || "differenceamount".equals(field)) {
            DynamicObjectCollection accountGroup;
            int rowIndex = evt.getRowIndex();
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            ReportShowParameter param = new ReportShowParameter();
            if (EmptyUtil.isNoEmpty((Object)rowData.get("parentorgid"))) {
                param.getCustomParams().put("filter_org", new Object[]{rowData.get("parentorgid")});
            } else {
                DynamicObjectCollection parentOrg = (DynamicObjectCollection)this.getModel().getValue("filter_org");
                if (parentOrg != null && !parentOrg.isEmpty()) {
                    Object[] parentOrgIds = parentOrg.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray();
                    param.getCustomParams().put("filter_org", parentOrgIds);
                }
            }
            if (EmptyUtil.isNoEmpty((Object)rowData.get("bankid"))) {
                param.getCustomParams().put("filter_bank", new Object[]{rowData.get("bankid")});
            } else {
                DynamicObjectCollection bank = (DynamicObjectCollection)this.getModel().getValue("filter_bank");
                if (bank != null && !bank.isEmpty()) {
                    Object[] bankIds = bank.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray();
                    param.getCustomParams().put("filter_bank", bankIds);
                }
            }
            if (EmptyUtil.isNoEmpty((Object)rowData.get("sonorgid"))) {
                param.getCustomParams().put("filter_sonorg", new Object[]{rowData.get("sonorgid")});
            } else {
                DynamicObjectCollection sonOrg = (DynamicObjectCollection)this.getModel().getValue("filter_sonorg");
                if (sonOrg != null && !sonOrg.isEmpty()) {
                    Object[] orgIds = sonOrg.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray();
                    param.getCustomParams().put("filter_sonorg", orgIds);
                }
            }
            DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("filter_currency");
            if (currency != null && !currency.isEmpty()) {
                Object[] currencyIds = currency.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray();
                param.getCustomParams().put("filter_currency", currencyIds);
            }
            if ((accountGroup = (DynamicObjectCollection)this.getModel().getValue("filter_accountgroup")) != null && !accountGroup.isEmpty()) {
                Object[] accountGroupIds = accountGroup.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray();
                param.getCustomParams().put("filter_accountgroup", accountGroupIds);
            }
            if ("upamount".equals(field)) {
                param.getCustomParams().put("filter_biztype", "fca_transupbill");
            } else if ("downamount".equals(field)) {
                param.getCustomParams().put("filter_biztype", "fca_transdownbill");
            }
            param.getCustomParams().put("filter_period", this.getModel().getValue("filter_period"));
            param.getCustomParams().put("filter_startdate", this.getModel().getValue("filter_startdate"));
            param.getCustomParams().put("filter_enddate", this.getModel().getValue("filter_enddate"));
            param.getCustomParams().put("filter_statcurrency", ((DynamicObject)rowData.get("statcurrency")).getPkValue());
            param.getCustomParams().put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
            param.setFormId("transbill_detail_report");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private List<Long> getAuthParentOrgList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"company", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("company")).collect(Collectors.toList());
    }

    private List<Long> getAuthSonOrgList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("entrys.bankacct.company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"entrys.bankacct.company", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("entrys.bankacct.company")).collect(Collectors.toList());
    }

    private List<Long> getCurrencyIdList() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"currency", (QFilter[])new QFilter[]{filter});
        return groupAccount.stream().map(g -> g.getLong("currency")).collect(Collectors.toList());
    }

    private List<Long> getBankIdList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"accountbank.bank.id", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("accountbank.bank.id")).collect(Collectors.toList());
    }

    private List<Long> getAccountGroupIdList(List<Long> authOrgList) {
        QFilter companyIdFilter = new QFilter("company", "in", authOrgList);
        DynamicObjectCollection groupAccount = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{companyIdFilter});
        return groupAccount.stream().map(g -> g.getLong("id")).collect(Collectors.toList());
    }

    private void rebuildColumn(String[] fields) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        if (fields == null || fields.length < 1) {
            return;
        }
        List columns = listTable.getColumns();
        ArrayList<ReportColumn> rebuildColumns = new ArrayList<ReportColumn>(fields.length);
        block0: for (String s : fields) {
            String field = s.trim();
            for (AbstractReportColumn absColumn : columns) {
                ReportColumn column = (ReportColumn)absColumn;
                if (!column.getFieldKey().equalsIgnoreCase(field)) continue;
                rebuildColumns.add(column);
                continue block0;
            }
        }
        if (!rebuildColumns.isEmpty()) {
            columns.clear();
            columns.addAll(rebuildColumns);
        }
    }

    private void setDefaultOrg() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        this.getModel().setValue("filter_org", null);
        if (authOrgIds != null && authOrgIds.size() > 0) {
            if (authOrgIds.contains(org)) {
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                DynamicObjectCollection collection = new DynamicObjectCollection();
                collection.add((Object)bosOrg);
                this.getModel().setValue("filter_org", (Object)collection);
            } else {
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)bosOrg)) {
                    DynamicObjectCollection collection = new DynamicObjectCollection();
                    collection.add((Object)bosOrg);
                    this.getModel().setValue("filter_org", (Object)collection);
                }
            }
        }
    }
}

