/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.mservice.paywriteback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class TransUpBillPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doRenoteValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: %2$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u9000\u7968\u3002", (String)"TransUpBillPayBillWriteBackService_0", (String)"tmc-fca-mservice", (Object[])new Object[0]), PayBillWriteBackOperateEnum.RENOTE.getName(), this.getEntityName(param, sourceBill)));
    }

    protected void doChargeBackValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: %2$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u9000\u5355\u3002", (String)"TransUpBillPayBillWriteBackService_1", (String)"tmc-fca-mservice", (Object[])new Object[0]), PayBillWriteBackOperateEnum.CHARGEBACK.getName(), this.getEntityName(param, sourceBill)));
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"fca_transupbill", (String)"id, billno, currency, entrys.transamt");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject dynamicObject) {
        return null;
    }

    protected BigDecimal getSourceBillPayAmount(PayBillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObjectCollection entries = sourceBill.getDynamicObjectCollection("entrys");
        Optional<DynamicObject> entry = entries.stream().filter(e -> Objects.equals(e.getPkValue(), param.getPayBill().getSourceBillEntryId())).findFirst();
        if (entry.isPresent()) {
            return entry.get().getBigDecimal("transamt");
        }
        return BigDecimal.ZERO;
    }

    protected BigDecimal getSourceBillLockPayAmount(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrayList<String> billStatus = new ArrayList<String>(2);
        billStatus.addAll(Arrays.asList("G", "F"));
        QFilter filter = new QFilter("billstatus", "not in", billStatus);
        QFilter sourceFilter = new QFilter("entry.e_sourcebillentryid", "=", (Object)param.getPayBill().getSourceBillEntryId());
        filter = filter.and(sourceFilter);
        filter = filter.and("id", "<>", (Object)param.getPayBill().getPayBillId());
        DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.e_actamt", (QFilter[])filter.toArray());
        return paybills.stream().map(p -> p.getBigDecimal("entry.e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String getEntityName(PayBillWriteBackParam param, DynamicObject sourceBill) {
        Object dataEntityType = sourceBill == null || sourceBill.getDataEntityType().getName().equals("PlainObject") ? MetadataServiceHelper.getDataEntityType((String)param.getPayBill().getSourceBillNumber()) : sourceBill.getDataEntityType();
        return dataEntityType.getDisplayName().toString();
    }
}

