/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.applytransbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fca.common.enums.FcaDownWayEnum;
import kd.tmc.fca.common.util.String2DecUtil;

public class Apply2TransDownBillRefTransAmtConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObjectCollection entries;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObject currency = targetBill.getDynamicObject("currency");
            DynamicObject bankAcct = targetBill.getDynamicObject("accountbank");
            if (currency == null || bankAcct == null || (entries = targetBill.getDynamicObjectCollection("entrys")).isEmpty()) continue;
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                DynamicObject subAcct = entry.getDynamicObject("subacct");
                DynamicObject strategy = this.getTransStrategyBySubAcct(bankAcct, subAcct, currency);
                if (subAcct == null || strategy == null || !strategy.getBoolean("istransdown") || !FcaDownWayEnum.ISHAND.getValue().equals(strategy.getString("downway"))) continue;
                BigDecimal transAmt = entry.getBigDecimal("transamt");
                String intAmtStr = strategy.getString("transdownint");
                BigDecimal intAmt = String2DecUtil.string2Dec((String)intAmtStr);
                if (BigDecimal.ZERO.compareTo(intAmt) < 0) {
                    transAmt = transAmt.divide(intAmt, 0, RoundingMode.UP).multiply(intAmt);
                }
                entry.set("transamt", (Object)transAmt);
                amount = amount.add(transAmt);
            }
            targetBill.set("amount", (Object)amount);
        }
    }

    private DynamicObject getTransStrategyBySubAcct(DynamicObject bankAcct, DynamicObject subAcct, DynamicObject currency) {
        DynamicObject acctGrp = this.getAcctGrpBySubAcct(bankAcct, subAcct, currency);
        if (acctGrp == null) {
            return null;
        }
        DynamicObject strategy = acctGrp.getDynamicObjectCollection("entrys").stream().filter(o -> o.getDynamicObject("bankacct").getPkValue().equals(subAcct.getPkValue())).findFirst().map(o -> o.getDynamicObject("transtrategy")).orElse(null);
        if (strategy != null) {
            strategy = BusinessDataServiceHelper.loadSingleFromCache((Object)strategy.getPkValue(), (String)"fca_transtrategy");
        }
        return strategy;
    }

    private DynamicObject getAcctGrpBySubAcct(DynamicObject bankAcct, DynamicObject subAcct, DynamicObject currency) {
        QFilter acctGrpCurrencyFlt = new QFilter("currency", "=", currency.getPkValue());
        QFilter acctFlt = new QFilter("accountbank", "=", bankAcct.getPkValue());
        QFilter acctGrpSubAcctFlt = new QFilter("entrys.bankacct", "in", subAcct.getPkValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        String selectProps = "bankacct, transtrategy";
        return BusinessDataServiceHelper.loadSingle((String)"fca_acctgroup", (String)selectProps, (QFilter[])new QFilter[]{acctGrpCurrencyFlt, acctFlt, acctGrpSubAcctFlt, enableFilter});
    }
}

