/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.applytransbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fca.business.opservice.applytransbill.PullPayBillService;
import kd.tmc.fca.common.errorcode.TransErrorCode;
import kd.tmc.fca.common.exception.FcaException;
import kd.tmc.fca.common.resource.FcaBizResource;

public class ApplyTransBillList
extends AbstractTmcBillBaseList {
    private static Log logger = LogFactory.getLog(ApplyTransBillList.class);
    private boolean isUnTreated = false;
    private static final String[] hideBtnsField = new String[]{"tblnew", "tbldel", "tblsubmit", "btlcheck", "barviewflow", "tblprint", "baritemap", "tblcheck"};
    private static final String[] staticFields = new String[]{"fseq", "company.name", "subacct.bankaccountnumber", "subacct.bank.name", "transamt", "parentorg.name", "pbankacct.bankaccountnumber", "billno", "createtime", "transdate", "auditdate", "remark", "description", "e_fundflowitem.name", "sourcebilltype"};
    private static final String[] hideButtons = new String[]{"trackdown", "roundingamountdown", "bar_export"};

    public void initialize() {
        super.initialize();
        this.isUnTreated = this.isFromControlCenter();
        if (this.isUnTreated) {
            ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
            ListUserOption listUserOption = showParameter.getListUserOption();
            listUserOption.setMergeRow(false);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isUnTreated) {
            List qFilters = e.getQFilters();
            qFilters.add(new QFilter("entrys.isgeneratebill", "=", (Object)Character.valueOf('0')));
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String entityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            String permItem = entityId.equals("fca_applytransupbill") ? "04PGH52CSKRY" : (entityId.equals("fca_applytransdownbill") ? "04PGNGN13ZLV" : "");
            String appId = this.getView().getFormShowParameter().getAppId();
            List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"fca_control_index", (String)permItem);
            qFilters.add(new QFilter("parentorg", "in", (Object)authIdList));
            e.setOrderBy("parentorg.number,entrys.pbankacct.bankaccountnumber asc,createtime desc,transdate desc");
        } else {
            e.setOrderBy("bizdate desc");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String commFilterFields;
        super.filterContainerInit(args);
        List commonFilterColumnList = args.getCommonFilterColumns();
        ArrayList<FilterColumn> filterColumnList = new ArrayList<FilterColumn>();
        ArrayList<FilterColumn> fastFilterColumnList = new ArrayList<FilterColumn>();
        String fastFilterFields = "";
        if (this.isUnTreated) {
            commFilterFields = "parentorg.name,company.name,createtime,sourcebilltype";
            fastFilterFields = "company.name,billno";
        } else {
            commFilterFields = "company.name,billstatus,bizdate,sourcebilltype";
        }
        int len = commonFilterColumnList.size();
        for (int i = 0; i < len; ++i) {
            FilterColumn filterColumn = (FilterColumn)commonFilterColumnList.get(i);
            String fieldName = filterColumn.getFieldName();
            if (this.isUnTreated && StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"company.")) {
                filterColumn.setDefaultValue("");
            }
            if (!commFilterFields.contains(fieldName)) continue;
            filterColumnList.add(filterColumn);
        }
        commonFilterColumnList.clear();
        commonFilterColumnList.addAll(filterColumnList);
        if (this.isUnTreated) {
            List fastFilterColumns = args.getFastFilterColumns();
            int len2 = fastFilterColumns.size();
            for (int i = 0; i < len2; ++i) {
                FilterColumn filterColumn = (FilterColumn)fastFilterColumns.get(i);
                String fieldName = filterColumn.getFieldName();
                if (!fastFilterFields.contains(fieldName)) continue;
                fastFilterColumnList.add(filterColumn);
            }
            fastFilterColumns.clear();
            fastFilterColumns.addAll(fastFilterColumnList);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        List qFilters = args.getQFilters();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"parentorg.")) {
            qFilters.add(this.getParentOrgFilter());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"parentorg.")) {
            args.getQfilters().add(this.getParentOrgFilter());
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        if (!this.isUnTreated) {
            return null;
        }
        switch (fieldName) {
            case "company.name": {
                return this.getCompanyOrgFilter();
            }
        }
        return null;
    }

    private List<QFilter> getCompanyOrgFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String entityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String mainTable = "t_fca_apptransup";
        String entityTable = "t_fca_apptransup_entry";
        if ("fca_applytransdownbill".equals(entityId)) {
            mainTable = "t_fca_apptransdown";
            entityTable = "t_fca_apptransdown_entry";
        }
        StringBuilder selectStr = new StringBuilder("SELECT DISTINCT A.fcompanyid as fcompanyid FROM ").append(mainTable).append(" A  INNER JOIN ").append(entityTable).append(" B ON B.FId=A.FId AND B.fisgeneratebill = '0' WHERE A.fbillstatus = 'C'");
        List authOrgIds = this.getPageFilterColumnCache("parentorg.name");
        Set<Object> authOrgPks = new HashSet();
        HashSet parentOrgIds = new HashSet();
        if (!EmptyUtil.isEmpty((Collection)authOrgIds)) {
            int len = authOrgIds.size();
            for (int i = 0; i < len; ++i) {
                Object authOrgId = authOrgIds.get(i);
                if (!authOrgId.toString().equals("")) continue;
                authOrgIds.remove(i);
            }
            if (!authOrgIds.isEmpty()) {
                authOrgPks = authOrgIds.stream().map(s -> (String)s).collect(Collectors.toSet());
            }
        }
        if (authOrgPks.isEmpty()) {
            DB.query((DBRoute)DBRouteConst.TMC, (String)selectStr.toString(), rs -> {
                while (rs.next()) {
                    parentOrgIds.add(rs.getLong(1));
                }
                return parentOrgIds;
            });
        } else {
            String authOrgPk = String.join((CharSequence)",", authOrgPks);
            selectStr.append(" and fparentorgid in (").append(authOrgPk).append(")");
            DB.query((DBRoute)DBRouteConst.TMC, (String)selectStr.toString(), rs -> {
                while (rs.next()) {
                    parentOrgIds.add(rs.getLong(1));
                }
                return parentOrgIds;
            });
        }
        logger.info("authOrgPks :{}", authOrgPks);
        logger.info("parentOrgIds :{}", parentOrgIds);
        filters.add(new QFilter("id", "in", parentOrgIds));
        return filters;
    }

    private QFilter getParentOrgFilter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String entityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String permItem = entityId.equals("fca_applytransupbill") ? "04PGH52CSKRY" : (entityId.equals("fca_applytransdownbill") ? "04PGNGN13ZLV" : "");
        List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"fca_control_index", (String)permItem);
        HashSet parentOrgIds = new HashSet();
        DynamicObject[] acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"company", (QFilter[])new QFilter[]{new QFilter("company.id", "in", (Object)authIdList)});
        if (null != acctGroups) {
            Arrays.asList(acctGroups).stream().forEach(v -> parentOrgIds.add(v.getLong("company.id")));
        }
        QFilter parentOrgFilter = new QFilter("id", "in", parentOrgIds);
        return parentOrgFilter;
    }

    protected void initToolButtonStatus() {
        super.initToolButtonStatus();
        if (this.isUnTreated) {
            this.getView().setVisible(Boolean.valueOf(false), hideBtnsField);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), hideButtons);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String targetBill;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String entityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String type = op.getType();
        Map parameter = op.getParameter();
        if ("exportlistbyselectfields".equals(operateKey)) {
            RequestContext context;
            String appId;
            boolean hasPerm;
            if (!this.isUnTreated && !(hasPerm = TmcOrgDataHelper.hasPermission((String)(appId = this.getView().getFormShowParameter().getAppId()), (long)(context = RequestContext.get()).getCurrUserId(), (long)context.getOrgId(), (String)entityId, (String)"4730fc9f000004ae"))) {
                throw new FcaException(new TransErrorCode().MUSEXPORTLIST());
            }
        } else if ("push".equalsIgnoreCase(type) && EmptyUtil.isNoEmpty((Object)parameter) && !operateKey.endsWith("_nofrdcheck") && ("fca_transupbill".equalsIgnoreCase(targetBill = (String)parameter.get("targetbill")) || "fca_transdownbill".equalsIgnoreCase(targetBill))) {
            DynamicObject[] selectedObj;
            List selectedEntryIdList = this.getSelectedEntryIdList();
            List selectedIdList = this.getSelectedIdList();
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject data : selectedObj = TmcDataServiceHelper.load((String)entityId, (String)"billstatus, entrys.pbankacct, entrys.subacct, entrys.isgeneratebill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedIdList)})) {
                if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u9700\u5df2\u5ba1\u6838\uff0c\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"ApplyTransBillList_9", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
                for (DynamicObject obj : entries) {
                    DynamicObject pAccount = obj.getDynamicObject("pbankacct");
                    String pAccountStatus = "";
                    if (pAccount != null) {
                        pAccountStatus = pAccount.getString("acctstatus");
                    }
                    String subAccountStatus = "";
                    DynamicObject subAccount = obj.getDynamicObject("subacct");
                    if (subAccount != null) {
                        subAccountStatus = subAccount.getString("acctstatus");
                    }
                    String dataEntityName = this.getDataEntityName();
                    if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                        if (StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)dataEntityName)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0a\u5212\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]), pAccount == null ? "" : pAccount.getString("bankaccountnumber")));
                        }
                        if (StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)dataEntityName)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0b\u62e8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_3", (String)"tmc-fca-formplugin", (Object[])new Object[0]), pAccount == null ? "" : pAccount.getString("bankaccountnumber")));
                        }
                        args.setCancel(true);
                    }
                    if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)dataEntityName)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u201c%1$s\u201d\u7684\u8d26\u6237\u72b6\u6001\u4e3a\u201c\u51bb\u7ed3\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0b\u62e8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_6", (String)"tmc-fca-formplugin", (Object[])new Object[0]), pAccount == null ? "" : pAccount.getString("bankaccountnumber")));
                        args.setCancel(true);
                    }
                    if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                        if (StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)dataEntityName)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0a\u5212\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_4", (String)"tmc-fca-formplugin", (Object[])new Object[0]), subAccount == null ? "" : subAccount.getString("bankaccountnumber")));
                        }
                        if (StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)dataEntityName)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0b\u62e8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_5", (String)"tmc-fca-formplugin", (Object[])new Object[0]), subAccount == null ? "" : subAccount.getString("bankaccountnumber")));
                        }
                        args.setCancel(true);
                    }
                    if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)dataEntityName)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u201c%s\u201d\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0a\u5212\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_7", (String)"tmc-fca-formplugin", (Object[])new Object[0]), subAccount == null ? "" : subAccount.getString("bankaccountnumber")));
                        args.setCancel(true);
                    }
                    for (Long id : selectedEntryIdList) {
                        DynamicObject pBankAcct;
                        if (!obj.getPkValue().equals(id) || !EmptyUtil.isNoEmpty((DynamicObject)(pBankAcct = obj.getDynamicObject("pbankacct")))) continue;
                        ids.add(pBankAcct.getLong("id"));
                    }
                }
            }
            if (ids.size() > 1) {
                this.getView().showTipNotification(new FcaBizResource().getErrorSameacct());
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "pullbill": {
                PullPayBillService pullPayBillService = new PullPayBillService("fca_applytransdownbill");
                pullPayBillService.setOperationResult(new OperationResult());
                pullPayBillService.process(null);
                ApplyTransBillList.showMessage(this.getView(), pullPayBillService.getOperationResult());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "downrule": {
                ListShowParameter showPara = new ListShowParameter();
                showPara.setBillFormId("fca_downrule");
                showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showPara);
                break;
            }
            case "pullrule": {
                ListShowParameter showPara1 = new ListShowParameter();
                showPara1.setBillFormId("fca_pullrule");
                showPara1.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showPara1);
                break;
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isUnTreated) {
            List listColumns = args.getListColumns();
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList hideColumns = new ArrayList();
            String[] fields = staticFields;
            String entityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            String caption = entityId.equals("fca_applytransupbill") ? ResManager.loadKDString((String)"\u4e0a\u5212\u7533\u8bf7\u5355", (String)"ApplyTransBillList_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]) : (entityId.equals("fca_applytransdownbill") ? ResManager.loadKDString((String)"\u8bf7\u6b3e\u7533\u8bf7\u5355", (String)"ApplyTransBillList_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]) : "");
            block0: for (String field : fields) {
                int columnLen = listColumns.size();
                for (int j = 0; j < columnLen; ++j) {
                    IListColumn column = (IListColumn)listColumns.get(j);
                    if (!field.equals(column.getListFieldKey())) continue;
                    if (field.equals("billno")) {
                        column.setCaption(new LocaleString(caption));
                    }
                    column.setVisible(11);
                    columns.add(column);
                    continue block0;
                }
            }
            columns.addAll(hideColumns);
            args.setListColumns(columns);
        }
    }

    public boolean isFromControlCenter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isUnTreated = formShowParameter.getCustomParam("isUnTreated");
        return EmptyUtil.isEmpty((Object)isUnTreated) ? false : (Boolean)isUnTreated;
    }

    public static void showMessage(IFormView formView, OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            formView.showSuccessNotification(operationResult.getMessage(), Integer.valueOf(5000));
        } else {
            List allErrorInfo = operationResult.getAllErrorInfo();
            ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
            StringBuilder title = new StringBuilder(operationResult.getMessage());
            StringBuilder message = new StringBuilder();
            if (!allErrorInfo.isEmpty()) {
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    message.append(operateErrorInfo.getMessage()).append("\r\n");
                }
            }
            if (!validateResultCollection.getValidateErrors().isEmpty()) {
                for (ValidateResult validateResult : validateResultCollection.getValidateErrors()) {
                    message.append(ResManager.loadKDString((String)"\u5355\u636e\u4fdd\u5b58\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef\uff1a", (String)"ApplyTransBillList_8", (String)"tmc-fca-formplugin", (Object[])new Object[0])).append("\r\n");
                    for (OperateErrorInfo operateErrorInfo : validateResult.getAllErrorInfo()) {
                        message.append(operateErrorInfo.getMessage()).append("\r\n");
                    }
                }
            }
            if (message.length() == 0) {
                formView.showTipNotification(title.toString(), Integer.valueOf(5000));
            } else {
                formView.showMessage(title.toString(), message.substring(0, message.length() - 2), MessageTypes.Default);
            }
        }
    }
}

