/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.errorcode.TransErrorCode;
import kd.tmc.fca.common.exception.FcaException;

public class ControlCenterPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private static final Long PAYBILL_SPAN = 1257237460727909376L;
    private static final Long PAYBILL_SYN = 993266082510901248L;
    private List<Long> billList = Arrays.asList(PAYBILL_SPAN, PAYBILL_SYN);
    private static Log logger = LogFactory.getLog(ControlCenterPlugin.class);
    private static final String REFRESH = "refresh";

    public void initialize() {
        super.initialize();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        this.addItemClickListeners(new String[]{"toolbarap"});
        bar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"uprequestnum", "downrequestnum", "transferrequestnum"});
        this.addClickListeners(new String[]{"uptempnum", "upsubmittednum", "upaudittednum", "uppayednum"});
        this.addClickListeners(new String[]{"downtempnum", "downsubmittednum", "downaudittednum", "downpayednum"});
        this.addClickListeners(new String[]{"transfertempnum", "transfersubmittednum", "transferaudittednum", "transferpayednum"});
        this.addClickListeners(new String[]{"btn_transdown_addnew", "btn_transup_addnew", "btn_transfer_addnew"});
        this.addClickListeners(new String[]{REFRESH});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (REFRESH.equals(key)) {
            this.transUpAndDownValue();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ((ProgressBar)this.getControl("progressbarap")).start();
        this.transUpAndDownValue();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if ("btn_transup_addnew".equalsIgnoreCase(key)) {
            this.showBillEdit("fca_transupbill");
        } else if (srcControl.getKey().equalsIgnoreCase("btn_transdown_addnew")) {
            this.showBillEdit("fca_transdownbill");
        } else if ("uprequestnum".equals(key)) {
            this.goApplyTransupList(BillStatusEnum.SUBMIT.getValue());
        } else if ("downrequestnum".equals(key)) {
            this.goApplyTransdownList(BillStatusEnum.SUBMIT.getValue());
        } else if ("uptempnum".equals(key)) {
            this.goTransupList(BillStatusEnum.SAVE.getValue());
        } else if ("upsubmittednum".equals(key)) {
            this.goTransupList(BillStatusEnum.SUBMIT.getValue());
        } else if ("upaudittednum".equals(key)) {
            this.goTransupList(BillStatusEnum.AUDIT.getValue() + "," + BillStatusEnum.PAYING.getValue());
        } else if ("downtempnum".equals(key)) {
            this.goTransdownList(BillStatusEnum.SAVE.getValue());
        } else if ("downsubmittednum".equals(key)) {
            this.goTransdownList(BillStatusEnum.SUBMIT.getValue());
        } else if ("downaudittednum".equals(key)) {
            this.goTransdownList(BillStatusEnum.AUDIT.getValue() + "," + BillStatusEnum.PAYING.getValue());
        } else if ("transferrequestnum".equalsIgnoreCase(key)) {
            this.goApplyTransferList(BillStatusEnum.AUDIT.getValue());
        } else if ("transfertempnum".equalsIgnoreCase(key)) {
            this.goTransferList(BillStatusEnum.SAVE.getValue());
        } else if ("transfersubmittednum".equalsIgnoreCase(key)) {
            this.goTransferList(BillStatusEnum.SUBMIT.getValue());
        } else if ("transferaudittednum".equalsIgnoreCase(key)) {
            this.goTransferList(BillStatusEnum.AUDIT.getValue() + ",E");
        } else if (REFRESH.equals(key)) {
            this.transUpAndDownValue();
        }
    }

    private void goApplyTransferList(String status) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cas_transferapply");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGNGN13ZLV");
        para.setCustomParam("authOrgIds", (Object)authOrgIds);
        para.setCustomParam("billstatus", (Object)status);
        para.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        para.setCustomParam("isUnTreated", (Object)Boolean.TRUE);
        para.setCustomParam("paidstatus", (Object)"A");
        para.setCaption(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8c03\u62e8\u7533\u8bf7\u5355", (String)"ControlCenterPlugin_01", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    private void goApplyTransupList(String status) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGNGN13ZLV");
        if (EmptyUtil.isEmpty((Collection)authOrgIds)) {
            throw new FcaException(new TransErrorCode().MUSTUNTRANSUPQX());
        }
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fca_applytransupbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("billstatus", "=", (Object)status);
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        para.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        para.setCustomParam("isUnTreated", (Object)Boolean.TRUE);
        para.setCaption(ResManager.loadKDString((String)"\u672a\u5904\u7406\u4e0a\u5212\u7533\u8bf7\u5355", (String)"ControlCenterPlugin_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    private void goApplyTransdownList(String status) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGNGN13ZLV");
        if (EmptyUtil.isEmpty((Collection)authOrgIds)) {
            throw new FcaException(new TransErrorCode().MUSTUNTRANSDOWNQX());
        }
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fca_applytransdownbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("billstatus", "=", (Object)status);
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        para.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        para.setCustomParam("isUnTreated", (Object)Boolean.TRUE);
        para.setCaption(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8bf7\u6b3e\u7533\u8bf7\u5355", (String)"ControlCenterPlugin_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    private void goTransferList(String status) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cas_paybill_spanmainpart");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        para.setCustomParam("status", (Object)status);
        para.setCustomParam("isUnTreated", (Object)Boolean.TRUE);
        para.setCaption(ResManager.loadKDString((String)"\u8c03\u62e8\u5904\u7406\u5217\u8868", (String)"ControlCenterPlugin_11", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    private void goTransupList(String status) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fca_transupbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        String filterStr = "billstatus" + ":" + status;
        para.setCustomParam("filter", (Object)filterStr);
        this.getView().showForm((FormShowParameter)para);
    }

    private void goTransdownList(String status) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fca_transdownbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        String filterStr = "billstatus" + ":" + status;
        para.setCustomParam("filter", (Object)filterStr);
        this.getView().showForm((FormShowParameter)para);
    }

    private void showBillEdit(String fromId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(fromId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void transUpAndDownValue() {
        Map<String, Integer> map = this.getTransUpAndDownDefaultValue();
        this.applyTransUpValue(map);
        this.applyTransDownValue(map);
        this.applyTransFerValue(map);
        this.transUpValue(map);
        this.transDownValue(map);
        this.transFerValue(map);
        this.setLabelText(map);
    }

    private void setLabelText(Map<String, Integer> countMap) {
        if (countMap != null && !countMap.isEmpty()) {
            for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
                String controlKey = entry.getKey();
                Integer num = entry.getValue();
                ((Label)this.getView().getControl(controlKey)).setText(num == null ? "0" : num.toString());
            }
        }
    }

    private Map<String, Integer> getTransUpAndDownDefaultValue() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int defaultValue = 0;
        map.put("uprequestnum", defaultValue);
        map.put("downrequestnum", defaultValue);
        map.put("uptempnum", defaultValue);
        map.put("upsubmittednum", defaultValue);
        map.put("upaudittednum", defaultValue);
        map.put("downtempnum", defaultValue);
        map.put("downsubmittednum", defaultValue);
        map.put("downaudittednum", defaultValue);
        map.put("transferrequestnum", defaultValue);
        map.put("transfertempnum", defaultValue);
        map.put("transfersubmittednum", defaultValue);
        map.put("transferaudittednum", defaultValue);
        return map;
    }

    private void applyTransFerValue(Map<String, Integer> map) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGNGN13ZLV");
        filters.add(new QFilter("applyorg", "in", (Object)authOrgIds));
        String selectFields = "billstatus";
        filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("paidstatus", "=", (Object)"A"));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"cas_transferapply", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        logger.info("applyTransFerValue()-size:" + objects.size());
        map.put("transferrequestnum", objects.size());
    }

    private void applyTransUpValue(Map<String, Integer> map) {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGH52CSKRY");
        filters.add(new QFilter("parentorg", "in", (Object)authorizedAccountLegalOrgId));
        filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("entrys.isgeneratebill", "!=", (Object)"1"));
        String selectFields = "billstatus,entrys.isgeneratebill";
        try (DataSet applyTransupDataSet = QueryServiceHelper.queryDataSet((String)"applyTransUpValue()", (String)"fca_applytransupbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupByData = applyTransupDataSet.groupBy(new String[]{"entrys.isgeneratebill"});
            groupByData.count();
            DataSet applyTransupCountDataSet = groupByData.finish();
            for (Row row : applyTransupCountDataSet) {
                if (row.getBoolean("entrys.isgeneratebill").booleanValue()) continue;
                Integer newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                map.put("uprequestnum", newCount);
            }
            applyTransupCountDataSet.close();
        }
    }

    private void applyTransDownValue(Map<String, Integer> map) {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGNGN13ZLV");
        filters.add(new QFilter("parentorg", "in", (Object)authorizedAccountLegalOrgId));
        filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("entrys.isgeneratebill", "!=", (Object)"1"));
        String selectFields = "billstatus,entrys.isgeneratebill";
        try (DataSet applyTransupDataSet = QueryServiceHelper.queryDataSet((String)"applyTransUpValue()", (String)"fca_applytransdownbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupByData = applyTransupDataSet.groupBy(new String[]{"entrys.isgeneratebill"});
            groupByData.count();
            DataSet applyTransupCountDataSet = groupByData.finish();
            for (Row row : applyTransupCountDataSet) {
                if (row.getBoolean("entrys.isgeneratebill").booleanValue()) continue;
                Integer newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                map.put("downrequestnum", newCount);
            }
            applyTransupCountDataSet.close();
        }
    }

    private void transUpValue(Map<String, Integer> map) {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_transupbill", (String)"47156aff000000ac");
        filters.add(new QFilter("company", "in", (Object)authorizedAccountLegalOrgId));
        String selectFields = "billstatus";
        try (DataSet transupDataSet = QueryServiceHelper.queryDataSet((String)"getTransUpAndDownValue()", (String)"fca_transupbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupByData = transupDataSet.groupBy(new String[]{"billstatus"});
            groupByData.count();
            DataSet transupCountDataSet = groupByData.finish();
            for (Row row : transupCountDataSet) {
                Integer newCount;
                String status = row.getString("billstatus");
                String controlkey = this.getTransupControlKeyByStatus(status);
                if (EmptyUtil.isEmpty((String)controlkey)) continue;
                Integer n = newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                if (BillStatusEnum.AUDIT.getValue().equals(status) || BillStatusEnum.PAYING.getValue().equals(status)) {
                    newCount = newCount + map.get(controlkey);
                }
                map.put(controlkey, newCount);
            }
            transupCountDataSet.close();
        }
    }

    private Map<String, Integer> transDownValue(Map<String, Integer> map) {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_transdownbill", (String)"47156aff000000ac");
        filters.add(new QFilter("company", "in", (Object)authorizedAccountLegalOrgId));
        String selectFields = "billstatus";
        try (DataSet transdownDataSet = QueryServiceHelper.queryDataSet((String)"getTransUpAndDownValue()", (String)"fca_transdownbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupTByransdowData = transdownDataSet.groupBy(new String[]{"billstatus"});
            groupTByransdowData.count();
            DataSet transdownountDataSet = groupTByransdowData.finish();
            for (Row row : transdownountDataSet) {
                Integer newCount;
                String status = row.getString("billstatus");
                String controlkey = this.getTransdownControlKeyByStatus(status);
                if (EmptyUtil.isEmpty((String)controlkey)) continue;
                Integer n = newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                if (BillStatusEnum.AUDIT.getValue().equals(status) || BillStatusEnum.PAYING.getValue().equals(status)) {
                    newCount = newCount + map.get(controlkey);
                }
                map.put(controlkey, newCount);
            }
            transdownountDataSet.close();
        }
        return map;
    }

    private Map<String, Integer> transFerValue(Map<String, Integer> map) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"fca_control_index", (String)"04PGNGN13ZLV");
        filters.add(new QFilter("org", "in", (Object)authorizedAccountLegalOrgId));
        filters.add(new QFilter("sourcetype", "=", (Object)"FCA"));
        filters.add(new QFilter("billtype", "in", this.billList));
        String selectFields = "billstatus";
        try (DataSet transFerDate = QueryServiceHelper.queryDataSet((String)"getTransUpAndDownValue()", (String)"cas_paybill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupTBytransFerDate = transFerDate.groupBy(new String[]{"billstatus"});
            groupTBytransFerDate.count();
            DataSet transFerDataSet = groupTBytransFerDate.finish();
            for (Row row : transFerDataSet) {
                String status = row.getString("billstatus");
                String controlkey = this.getTransferControlKeyByStatus(status);
                if (EmptyUtil.isEmpty((String)controlkey)) continue;
                Integer newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                logger.info("transFerValue()-count:" + newCount + "status : " + status);
                if (BillStatusEnum.AUDIT.getValue().equals(status) || "E".equals(status) || BillStatusEnum.BEING.getValue().equals(status) || BillStatusEnum.SUBMIT.getValue().equals(status) || BillStatusEnum.SAVE.getValue().equals(status)) {
                    newCount = newCount + map.get(controlkey);
                }
                map.put(controlkey, newCount);
            }
            transFerDataSet.close();
        }
        return map;
    }

    private String getTransupControlKeyByStatus(String status) {
        String controlKey = null;
        if (status.equals(BillStatusEnum.SAVE.getValue())) {
            controlKey = "uptempnum";
        } else if (status.equals(BillStatusEnum.SUBMIT.getValue())) {
            controlKey = "upsubmittednum";
        } else if (status.equals(BillStatusEnum.AUDIT.getValue()) || status.equals(BillStatusEnum.PAYING.getValue())) {
            controlKey = "upaudittednum";
        }
        return controlKey;
    }

    private String getTransdownControlKeyByStatus(String status) {
        String controlKey = null;
        if (status.equals(BillStatusEnum.SAVE.getValue())) {
            controlKey = "downtempnum";
        } else if (status.equals(BillStatusEnum.SUBMIT.getValue())) {
            controlKey = "downsubmittednum";
        } else if (status.equals(BillStatusEnum.AUDIT.getValue()) || status.equals(BillStatusEnum.PAYING.getValue())) {
            controlKey = "downaudittednum";
        }
        return controlKey;
    }

    private String getTransferControlKeyByStatus(String status) {
        String controlKey = null;
        if (status.equals(BillStatusEnum.SAVE.getValue())) {
            controlKey = "transfertempnum";
        } else if (status.equals(BillStatusEnum.SUBMIT.getValue())) {
            controlKey = "transfersubmittednum";
        } else if (status.equals(BillStatusEnum.AUDIT.getValue()) || status.equals("E")) {
            controlKey = "transferaudittednum";
        }
        return controlKey;
    }

    public void onProgress(ProgressEvent event) {
        this.transUpAndDownValue();
        event.setProgress(10);
    }
}

