/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.helper.DynamicListHelper;
import org.apache.commons.lang3.StringUtils;

public class CashPoolingPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final int ENTRYNUMS = 20;
    private static final String FLEXCONTENT = "flexcontent";
    private static final BigDecimal TENTHOUSAND = new BigDecimal(10000);
    private static final String BTNTRANSUP = "btntransup";
    private static final String BTNTRANSDOWN = "btntransdown";
    private static final String BTNTRANSDETAIL = "btntransdetail";
    private static final String BARREFRESH = "bar_refresh";
    private static final String BARADD = "bar_add";
    private static final String BARDEL = "delete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BARADD, BARREFRESH, BARDEL});
        for (int i = 1; i <= 20; ++i) {
            this.addClickListeners(new String[]{BTNTRANSUP + i, BTNTRANSDOWN + i, BTNTRANSDETAIL + i, BARDEL + i});
            CardEntry entryentity = (CardEntry)this.getControl("entryentity" + i);
            if (entryentity == null) continue;
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry card = (CardEntry)evt.getSource();
        this.getPageCache().put("entryKey", card.getEntryKey());
        this.getPageCache().put("rowIndex", String.valueOf(evt.getRow()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        ListShowParameter fsp = new ListShowParameter();
        if (key.contains(BTNTRANSUP)) {
            this.showTransBillPage("fca_transupbill", key.replace(BTNTRANSUP, ""));
        } else if (key.contains(BTNTRANSDOWN)) {
            this.showTransBillPage("fca_transdownbill", key.replace(BTNTRANSDOWN, ""));
        } else if (key.contains(BTNTRANSDETAIL)) {
            this.showTransDetail(fsp, key.replace(BTNTRANSDETAIL, ""));
        } else if (key.contains(BARREFRESH)) {
            this.refresh();
        } else if (key.equals(BARADD)) {
            this.showAddAcctGroupView();
        } else if (key.contains(BARDEL)) {
            this.delEntry();
        }
    }

    public void delEntry() {
        String entryKey = this.getPageCache().get("entryKey");
        Integer rowIndex = Integer.valueOf(this.getPageCache().get("rowIndex"));
        String entryIndex = entryKey.split("entryentity")[1];
        DynamicObject entryRow = this.getModel().getEntryRowEntity(entryKey, rowIndex.intValue());
        Long acctGroupId = entryRow.getDynamicObject("fcagroup" + entryIndex).getLong("id");
        DynamicObject[] settings = TmcDataServiceHelper.load((String)"fca_cash_poolsetting", (String)"user,acctgroup", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())});
        int len = settings.length;
        if (len != 0) {
            if (len > 1) {
                DeleteServiceHelper.delete((String)"fca_cash_poolsetting", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()), new QFilter("acctgroup", "=", (Object)acctGroupId)});
            } else {
                settings[0].set("acctgroup", (Object)0);
                SaveServiceHelper.save((DynamicObject[])settings);
            }
        } else {
            List<DynamicObject> acctGroups = this.getTargetAcctGroups("id");
            if (null != acctGroups) {
                ArrayList<Long> acctGroupIds = new ArrayList<Long>(acctGroups.size());
                for (DynamicObject acctGroup : acctGroups) {
                    acctGroupIds.add(acctGroup.getLong("id"));
                }
                acctGroupIds.remove(acctGroupId);
                this.saveAttentionSetting(acctGroupIds);
            }
        }
        this.getModel().deleteEntryRow(entryKey, rowIndex.intValue());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
        if (null == entryEntity || entryEntity.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXCONTENT + entryIndex});
            this.getModel().setValue("currency" + entryIndex, null);
        }
    }

    private void refresh() {
        for (int i = 1; i <= 20; ++i) {
            this.getModel().deleteEntryData("entryentity" + i);
            this.getModel().setValue("currency" + i, null);
        }
        this.loadCardData();
    }

    private void showAddAcctGroupView() {
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"fca_acctgroup", (String)"47150e89000000ac");
        List<DynamicObject> userSetting = this.getUserSetting();
        ArrayList acctGroupIds = new ArrayList();
        userSetting.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("acctgroup"))).forEach(v -> acctGroupIds.add(v.getDynamicObject("acctgroup").getPkValue()));
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("company", "in", (Object)authOrgIds));
        qfilters.add(new QFilter("id", "not in", acctGroupIds));
        qfilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        boolean isExist = TmcDataServiceHelper.exists((String)"fca_acctgroup", (QFilter[])qfilters.toArray(new QFilter[0]));
        if (!isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6bcd\u5b50\u8d26\u6237\u7ec4\u3002", (String)"CashPoolingPlugin_01", (String)"tmc-fca-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            ListShowParameter lsp = DynamicListHelper.getAcctGroupShowParameter(qfilters);
            if (lsp != null) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addAcctGroup");
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if ("addAcctGroup".equals(actionId) && !EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection rowDatas = (ListSelectedRowCollection)returnData;
            rowDatas.get(0).getPrimaryKeyValue();
            ArrayList<Long> pks = new ArrayList<Long>();
            for (ListSelectedRow row : rowDatas) {
                pks.add((Long)row.getPrimaryKeyValue());
            }
            this.saveAttentionSetting(pks);
            this.refresh();
        }
    }

    private List<DynamicObject> getUserSetting() {
        Long userId = RequestContext.get().getCurrUserId();
        String selectors = "user,acctgroup";
        DynamicObject[] userSettings = BusinessDataServiceHelper.load((String)"fca_cash_poolsetting", (String)selectors, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        ArrayList<DynamicObject> attentionSettings = new ArrayList<DynamicObject>(userSettings.length);
        for (int i = 0; i < userSettings.length; ++i) {
            attentionSettings.add(userSettings[i]);
        }
        return attentionSettings;
    }

    private void saveAttentionSetting(List<Long> acctGroupIds) {
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<DynamicObject> settings = new ArrayList<DynamicObject>(acctGroupIds.size());
        int len = acctGroupIds.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject setting = TmcDataServiceHelper.newDynamicObject((String)"fca_cash_poolsetting");
            setting.set("user", (Object)userId);
            setting.set("acctgroup", (Object)acctGroupIds.get(i));
            settings.add(setting);
        }
        SaveServiceHelper.save((DynamicObject[])settings.toArray(new DynamicObject[0]));
    }

    public void afterCreateNewData(EventObject e) {
        this.loadCardData();
    }

    private void loadCardData() {
        String selectProperties = "id,currency,accountbank,accountbank.issetbankinterface";
        List<DynamicObject> authAcctGroupList = this.getTargetAcctGroups(selectProperties);
        this.createEntryCard(authAcctGroupList);
        this.hideEmptyEntry();
    }

    private void hideEmptyEntry() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        for (int i = 1; i <= 20; ++i) {
            if (null != model.getValue("currency" + i)) continue;
            view.setVisible(Boolean.valueOf(false), new String[]{FLEXCONTENT + i});
        }
    }

    private void createEntryCard(List<DynamicObject> authAcctGroupList) {
        IDataModel model = this.getModel();
        HashMap<Long, List<DynamicObject>> groupsMap = new HashMap<Long, List<DynamicObject>>();
        HashSet<Long> bankIdSet = new HashSet<Long>();
        this.groupbyCurrency(authAcctGroupList, groupsMap, bankIdSet);
        String serviceUrl = UrlService.getDomainContextUrl();
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id,logo", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIdSet)});
        Map<Object, String> bankLogoMap = Arrays.stream(dynamicObjects).filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("logo")) && o.getString("logo").contains("/icons/")).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> serviceUrl.concat(o.getString("logo")), (a, b) -> a));
        Map<Object, String> bankLogoMap2 = Arrays.stream(dynamicObjects).filter(o -> StringUtils.isBlank((CharSequence)o.getString("logo")) || !o.getString("logo").contains("/icons/")).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o.getString("logo"), (a, b) -> a));
        bankLogoMap.putAll(bankLogoMap2);
        Iterator<Map.Entry<Long, List<DynamicObject>>> curencygroups = groupsMap.entrySet().iterator();
        int i = 0;
        Boolean isFlagMore = false;
        Set<Long> curIds = groupsMap.keySet();
        Map<Long, HashMap<String, Map>> curUpMap = this.transBillDataBatch(curIds, "fca_transupbill");
        Map<Long, HashMap<String, Map>> curDownMap = this.transBillDataBatch(curIds, "fca_transdownbill");
        while (curencygroups.hasNext()) {
            if (++i > 20 || i <= 0) {
                isFlagMore = true;
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXCONTENT + i});
            Map.Entry<Long, List<DynamicObject>> group = curencygroups.next();
            Long currencyid = group.getKey();
            List<DynamicObject> value = group.getValue();
            model.setValue("currency" + i, (Object)currencyid);
            BigDecimal balanceSum = BigDecimal.ZERO;
            HashMap<String, Map> transupbillMap = curUpMap.get(currencyid);
            HashMap<String, Map> transdownbillMap = curDownMap.get(currencyid);
            for (DynamicObject fcagroup : value) {
                DynamicObject accountbank = fcagroup.getDynamicObject("accountbank");
                if (accountbank == null) continue;
                BigDecimal currBalance = AmtCalcHelper.getA_CurrBalance((DynamicObject)accountbank, (Object)currencyid);
                balanceSum = balanceSum.add(currBalance);
                int rowIndex = model.createNewEntryRow("entryentity" + i);
                DynamicObject bank = accountbank.getDynamicObject("bank");
                if (bank == null) continue;
                model.setValue("banklogo" + i, (Object)bankLogoMap.get(bank.getPkValue()), rowIndex);
                model.setValue("fcagroup" + i, fcagroup.getPkValue(), rowIndex);
                model.setValue("amount" + i, (Object)this.changeToTenThousand(currBalance), rowIndex);
                this.setValueTransbill(transupbillMap, fcagroup, rowIndex, "transupamount" + i, "transupids" + i);
                this.setValueTransbill(transdownbillMap, fcagroup, rowIndex, "transdownamount" + i, "transdownids" + i);
            }
            model.setValue("amountall" + i, (Object)this.changeToTenThousand(balanceSum));
        }
        this.getView().updateView();
        if (isFlagMore.booleanValue()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4ec5\u5c55\u793a20\u5f20\u5361\u7247\uff0c\u5269\u4f59%s\u5f20\u5361\u7247\u672a\u5c55\u793a\u3002", (String)"CashPoolingPlugin_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]), i - 20));
        }
    }

    private BigDecimal changeToTenThousand(BigDecimal Balance) {
        return Balance.divide(TENTHOUSAND, 4, 4);
    }

    private void groupbyCurrency(List<DynamicObject> authAcctGroupList, HashMap<Long, List<DynamicObject>> groupsMap, HashSet<Long> bankIdSet) {
        for (DynamicObject acctgroup : authAcctGroupList) {
            Object id;
            if (acctgroup.getDynamicObject("currency") == null) continue;
            Long currencyId = acctgroup.getDynamicObject("currency").getLong("id");
            if (acctgroup.getDynamicObject("accountbank") != null && acctgroup.getDynamicObject("accountbank").getDynamicObject("bank") != null && (id = acctgroup.getDynamicObject("accountbank").getDynamicObject("bank").getPkValue()) != null) {
                bankIdSet.add((Long)id);
            }
            if (groupsMap.get(currencyId) == null) {
                ArrayList<DynamicObject> DynamicObjectList = new ArrayList<DynamicObject>();
                DynamicObjectList.add(acctgroup);
                groupsMap.put(currencyId, DynamicObjectList);
                continue;
            }
            List<DynamicObject> list = groupsMap.get(currencyId);
            list.add(acctgroup);
        }
    }

    private void setValueTransbill(HashMap<String, Map> transupbillMap, DynamicObject fcagroup, int rowIndex, String transamount, String transids) {
        Map transupbillValueMap;
        if (transupbillMap != null && (transupbillValueMap = transupbillMap.get(fcagroup.getString("id"))) != null) {
            this.getModel().setValue(transamount, transupbillValueMap.get("transsucamt"), rowIndex);
            List transIds = (List)transupbillValueMap.get("transIds");
            if (transIds != null) {
                this.getModel().setValue(transids, (Object)String.join((CharSequence)",", transIds.toArray(new String[transIds.size()])), rowIndex);
            }
        }
    }

    private Map<Long, HashMap<String, Map>> transBillDataBatch(Set<Long> currrencyIds, String transBill) {
        Map map;
        HashMap transbillMap;
        Long rowCurId;
        if (EmptyUtil.isEmpty(currrencyIds)) {
            return new HashMap<Long, HashMap<String, Map>>();
        }
        Date currentDate = DateUtils.getCurrentDate();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue()));
        qFilters.add(new QFilter("entrys.paydate", ">=", (Object)DateUtils.getLastDay((Date)currentDate, (int)1)));
        qFilters.add(new QFilter("entrys.paydate", "<", (Object)DateUtils.getLastDay((Date)currentDate, (int)0)));
        qFilters.add(new QFilter("currency", "in", currrencyIds));
        HashMap<Long, HashMap<String, Map>> maps = new HashMap<Long, HashMap<String, Map>>(currrencyIds.size());
        for (Long currrencyId : currrencyIds) {
            maps.put(currrencyId, new HashMap());
        }
        DataSet transbillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)transBill, (String)"id,acctgrpid,transsucamt,currency.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
        DataSet sumDataSet = transbillDS.groupBy(new String[]{"id", "acctgrpid", "transsucamt", "currency.id"}).finish().groupBy(new String[]{"currency.id", "acctgrpid"}).sum("transsucamt").finish();
        DataSet billIdDataSet = transbillDS.groupBy(new String[]{"currency.id", "acctgrpid", "id"}).finish();
        for (Row row : sumDataSet) {
            rowCurId = row.getLong("currency.id");
            String rowAcctgrpid = row.getString("acctgrpid");
            BigDecimal sumAmt = row.getBigDecimal("transsucamt");
            transbillMap = (HashMap)maps.get(rowCurId);
            map = new HashMap<String, BigDecimal>();
            ((HashMap)map).put("transsucamt", this.changeToTenThousand(sumAmt));
            transbillMap.put(rowAcctgrpid, map);
            maps.put(rowCurId, transbillMap);
        }
        for (Row row : billIdDataSet) {
            rowCurId = row.getLong("currency.id");
            String acctgrpid = row.getString("acctgrpid");
            String billId = row.getString("id");
            transbillMap = (HashMap)maps.get(rowCurId);
            map = (Map)transbillMap.get(acctgrpid);
            List<String> transIds = map.containsKey("transIds") ? (List)map.get("transIds") : new ArrayList();
            transIds.add(billId);
            map.put("transIds", transIds);
            transbillMap.put(acctgrpid, map);
            maps.put(rowCurId, transbillMap);
        }
        transbillDS.close();
        return maps;
    }

    private List<DynamicObject> getTargetAcctGroups(String selectProperties) {
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"fca_acctgroup", (String)"47150e89000000ac");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        qfilters.add(new QFilter("company", "in", (Object)authOrgList));
        List<DynamicObject> userSettings = this.getUserSetting();
        if (!EmptyUtil.isEmpty(userSettings) || userSettings.size() == 1 && userSettings.get(0).getDynamicObject("acctgroup") == null) {
            ArrayList<Object> acctGroupIds = new ArrayList<Object>();
            for (DynamicObject userSetting : userSettings) {
                DynamicObject acctgroup = userSetting.getDynamicObject("acctgroup");
                if (!EmptyUtil.isNoEmpty((DynamicObject)acctgroup)) continue;
                acctGroupIds.add(acctgroup.getPkValue());
            }
            qfilters.add(new QFilter("id", "in", acctGroupIds));
        }
        List<DynamicObject> authAcctGroupList = Stream.of(TmcDataServiceHelper.load((String)"fca_acctgroup", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]))).collect(Collectors.toList());
        return authAcctGroupList;
    }

    private void showTransDetail(ListShowParameter fsp, String num) {
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setBillFormId("bei_transdetail");
        List qFiltersCol = fsp.getListFilterParameter().getQFilters();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter firstDayOfCurMonth = new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfCurMonth());
        QFilter lastDayOfCurMonth = new QFilter("bizdate", "<", (Object)DateUtils.getLastDayOfCurMonth());
        DynamicObject fcagroup = (DynamicObject)this.getModel().getValue("fcagroup" + num);
        if (!EmptyUtil.isEmpty((DynamicObject)fcagroup)) {
            Object accountbankId = fcagroup.getDynamicObject("accountbank").getPkValue();
            QFilter accountbank = new QFilter("accountbank.id", "=", accountbankId);
            DynamicObject accountbankDO = TmcDataServiceHelper.loadSingle((Object)accountbankId, (String)"am_accountbank");
            if (!EmptyUtil.isEmpty((DynamicObject)accountbankDO)) {
                QFilter company = new QFilter("company.id", "=", accountbankDO.getDynamicObject("company").getPkValue());
                qFilters.add(company);
            }
            qFilters.add(accountbank);
        }
        qFilters.add(firstDayOfCurMonth);
        qFilters.add(lastDayOfCurMonth);
        qFiltersCol.addAll(qFilters);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void showTransBillPage(String fromType, String num) {
        int index = this.getModel().getEntryCurrentRowIndex("entryentity" + num);
        DynamicObject entryRow = this.getModel().getEntryRowEntity("entryentity" + num, index);
        DynamicObject acctGroup = entryRow.getDynamicObject("fcagroup" + num);
        List<Object> pkIds = this.loadTransBill(acctGroup, fromType);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", pkIds));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId(fromType);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Object> loadTransBill(DynamicObject acctGroup, String entity) {
        ArrayList<Object> billIds = new ArrayList<Object>();
        Date currentDate = DateUtils.getCurrentDate();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue()));
        qFilters.add(new QFilter("entrys.paydate", ">=", (Object)DateUtils.getLastDay((Date)currentDate, (int)1)).and("entrys.paydate", "<", (Object)DateUtils.getLastDay((Date)currentDate, (int)0)));
        qFilters.add(new QFilter("currency", "=", acctGroup.getDynamicObject("currency").getPkValue()));
        qFilters.add(new QFilter("accountbank", "=", acctGroup.getDynamicObject("accountbank").getPkValue()));
        DynamicObject[] transBills = TmcDataServiceHelper.load((String)entity, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        Stream.of(transBills).forEach(v -> billIds.add(v.getPkValue()));
        return billIds;
    }
}

