/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.provider;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fca.common.helper.TransBillHelper;

public class GetListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty() || !((DynamicObject)rows.get(0)).containsProperty("entrys.bankacct")) {
            return rows;
        }
        List fields = this.getListFields();
        LongProp idProp = new LongProp();
        idProp.setAlias("finneracctid");
        idProp.setName("inneracct_id");
        BasedataProp basedataProp = this.createBaseDataProp(idProp);
        rows.getDynamicObjectType().addProperty((DynamicProperty)basedataProp);
        rows.getDynamicObjectType().addProperty((DynamicProperty)idProp);
        for (ListField f : fields) {
            if (!f.getKey().startsWith("inneracct") || f.getFieldProp() != null) continue;
            f.setFieldProp((IDataEntityProperty)basedataProp);
        }
        Set rowIds = rows.stream().filter(d -> d.get("entrys.bankacct") != null).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        if (!rowIds.isEmpty()) {
            DynamicObjectCollection accountGroup = QueryServiceHelper.query((String)"fca_acctgroup", (String)"company, currency, id", (QFilter[])new QFilter[]{new QFilter("id", "in", rowIds)});
            Set bankAccountIds = rows.stream().filter(d -> d.getDynamicObject("entrys.bankacct") != null).map(d -> d.getDynamicObject("entrys.bankacct").getPkValue()).collect(Collectors.toSet());
            if (!bankAccountIds.isEmpty()) {
                Map<Object, Object> orgAccountId = accountGroup.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.get("company"), (e1, e2) -> e1));
                Map<Object, Object> currencyAccountId = accountGroup.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.get("currency"), (e1, e2) -> e1));
                Map orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
                for (DynamicObject detail : rows) {
                    DynamicObjectCollection currencies;
                    List currencyIdList;
                    Object companyPkId = orgAccountId.get(detail.getPkValue());
                    Object currencyPkId = currencyAccountId.get(detail.getPkValue());
                    if (detail.get("entrys.bankacct") == null || !orgInnerAccountMap.containsKey(companyPkId)) continue;
                    DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(companyPkId)).get(detail.getDynamicObject("entrys.bankacct").getPkValue());
                    if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currencyPkId)) {
                        innerAccount = null;
                    }
                    detail.set("entrys.inneracct", (Object)innerAccount);
                }
            }
        }
        return rows;
    }

    private BasedataProp createBaseDataProp(LongProp idProp) {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ifm_inneracct"));
        basedataProp.setName("entrys.inneracct");
        basedataProp.setDisplayProp("name");
        basedataProp.setNumberProp("number");
        basedataProp.setRefIdProp((IDataEntityProperty)idProp);
        basedataProp.setRefIdPropName(idProp.getName());
        return basedataProp;
    }
}

