/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.formula.excel.FormulaException;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class PullRuleEdit
extends AbstractBasePlugIn
implements ClickListener {
    private static final int MAX_LENGTH = 255;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"datafilterdesc"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey()) || "submit".equals(op.getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            CRCondition conditionObj = new CRCondition();
            conditionObj.setFilterCondition(filterGridState.getFilterCondition());
            try {
                String tranExpr = this.tranFormula((CRFormula)conditionObj);
                conditionObj.setExprTran(tranExpr);
            }
            catch (FormulaException exp) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
                return;
            }
            catch (Exception exp) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getMessage()));
                return;
            }
            this.receiveExpressionSet(SerializationUtils.toJsonString((Object)conditionObj));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (fieldKey) {
            case "sourceentity": {
                this.getRule();
                this.getModel().setValue("datafilterdesc", (Object)"");
                this.reBuildFilterGrid();
                break;
            }
            case "targetentity": {
                this.getRule();
                break;
            }
            case "datafilterdesc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getPageCache().put("datafilter", "");
                this.getModel().setValue("datafilter", (Object)"");
                this.getModel().setValue("datafilter_TAG", (Object)"");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("datafilter".equals(e.getActionId()) && e.getReturnData() != null) {
            this.receiveExpressionSet((String)e.getReturnData());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getRule();
        this.reBuildFilterGrid();
    }

    private void receiveExpressionSet(String formula) {
        if (StringUtils.isBlank((CharSequence)formula)) {
            this.getModel().setValue("datafilter", (Object)"");
        } else {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
            this.getModel().setValue("datafilter_TAG", (Object)formula);
            String desc = "";
            if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                desc = filterObj.getExprTran();
            }
            if (desc.length() > 255) {
                desc = desc.substring(0, 255);
            }
            this.getModel().setValue("datafilterdesc", (Object)desc);
        }
    }

    private void getRule() {
        ComboEdit rule = (ComboEdit)this.getControl("rule");
        DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue("sourceentity");
        DynamicObject targetEntity = (DynamicObject)this.getModel().getValue("targetentity");
        if (sourceEntity == null || targetEntity == null) {
            rule.setComboItems(null);
        } else {
            List convertRuleElementList = ConvertMetaServiceHelper.loadRules((String)sourceEntity.getString("number"), (String)targetEntity.getString("number"));
            convertRuleElementList = convertRuleElementList.stream().filter(ConvertRuleElement::isEnabled).collect(Collectors.toList());
            ArrayList<ComboItem> listItems = new ArrayList<ComboItem>(convertRuleElementList.size());
            for (ConvertRuleElement convertRuleElement : convertRuleElementList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(convertRuleElement.getId());
                comboItem.setCaption(convertRuleElement.getName());
                listItems.add(comboItem);
            }
            rule.setComboItems(listItems);
        }
    }

    private void reBuildFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        String entityNumber = null;
        if (this.getModel().getValue("sourceentity") != null) {
            entityNumber = ((DynamicObject)this.getModel().getValue("sourceentity")).getString("number");
        }
        if (StringUtils.isNotBlank(entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType(entityNumber);
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            option.setCompatibleProductMode(true);
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            String conditionJson = (String)this.getModel().getValue("datafilter_TAG");
            if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
                FilterCondition filterCondition = conditionObj.getFilterCondition();
                if (filterCondition != null) {
                    filterGrid.SetValue(filterCondition);
                }
            } else {
                filterGrid.SetValue(new FilterCondition());
            }
            this.getView().updateView("ffiltergrid");
        }
    }

    private String tranFormula(CRFormula formulaObj) {
        String tranExpr = " ";
        DynamicObject entity = (DynamicObject)this.getModel().getValue("sourceentity");
        String entityNumber = entity.getString("number");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && !filterCondition.getFilterRow().isEmpty()) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>(2);
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"PullRuleEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }
}

