/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.transbill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankPaymentBillList
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tracebankupbill": 
            case "tracebankdownbill": {
                this.traceBankbill(key);
            }
        }
    }

    private void traceBankbill(String sourceBillType) {
        String targetBillType = null;
        targetBillType = sourceBillType.equalsIgnoreCase("tracebankupbill") ? "bei_banktransupbill" : "bei_banktransdownbill";
        HashSet<Long> billIds = this.getSelectedBillIds();
        DynamicObject[] targetBills = new DynamicObject[]{};
        if (EmptyUtil.isEmpty(billIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BankPaymentBillList_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (billIds.size() == 1) {
            targetBills = BusinessDataServiceHelper.load((String)targetBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billIds.iterator().next())}, (String)"createtime desc");
            if (null == targetBills || targetBills.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"BankPaymentBillList_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (billIds.size() > 1 && ((targetBills = BusinessDataServiceHelper.load((String)targetBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds)})) == null || targetBills.length == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"BankPaymentBillList_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (targetBills.length == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(targetBills[0].get("id"));
            showParameter.setFormId(targetBillType);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(targetBillType);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            HashSet<Object> pks = new HashSet<Object>(targetBills.length);
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    protected HashSet<Long> getSelectedBillIds() {
        HashSet<Long> billIds = new HashSet<Long>();
        IListView listView = (IListView)this.getView();
        for (ListSelectedRow row : listView.getSelectedRows()) {
            Long billId;
            if (!(row.getPrimaryKeyValue() instanceof Long) || billIds.contains(billId = (Long)row.getPrimaryKeyValue())) continue;
            billIds.add(billId);
        }
        return billIds;
    }
}

