/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.transtrategy;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.constant.FcaBizConstant;
import kd.tmc.fca.common.enums.FcaDownWayEnum;
import kd.tmc.fca.common.enums.FcaUpWayEnum;
import kd.tmc.fca.common.util.String2DecUtil;

public class TranStrategyEdit
extends AbstractBasePlugIn {
    private boolean repeatFlag = false;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        long orgId = TmcOrgDataHelper.getCurrentOrgId();
        if (model.getProperty("currency") != null) {
            DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)orgId);
            model.setValue("currency", EmptyUtil.isEmpty((DynamicObject)currency) ? null : currency.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean dataChanged = this.getModel().getDataChanged();
        Container fs_baseinfo = (Container)this.getView().getControl("fs_baseinfo");
        if ("ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applist"});
            fs_baseinfo.setCollapse(false);
            return;
        }
        Label label = (Label)this.getView().getControl("count");
        BillList acctgroupbilllist = (BillList)this.getControl("acctgroupbilllist");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        fs_baseinfo.setCollapse(true);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        BillList billlistap = (BillList)this.getControl("billlistap");
        if ((Long)pkValue != 0L) {
            QFilter transtryFilter = new QFilter("entrys.transtrategy", "=", pkValue);
            QFilter transtryEnableFilter = transtryFilter.and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()));
            boolean acctexists = TmcDataServiceHelper.exists((String)"fca_acctgroup", (QFilter[])new QFilter[]{transtryFilter});
            if (acctexists) {
                billlistap.setFilter(transtryEnableFilter);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applist"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
                DynamicObjectCollection acctGroups = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{transtryEnableFilter});
                if (!acctGroups.isEmpty()) {
                    acctgroupbilllist.setFilter(transtryEnableFilter);
                    acctgroupbilllist.refresh();
                    ListSelectedRowCollection currRows = acctgroupbilllist.getCurrentListAllRowCollection();
                    String total = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u6bcd\u5b50\u8d26\u6237\u7ec4\uff0c\u5171%2$s\u4e2a\u5b50\u8d26\u6237\u3002", (String)"TranStrategyEdit_01", (String)"tmc-fca-formplugin", (Object[])new Object[0]), acctGroups.size(), currRows.size());
                    label.setText(total);
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"count"});
            }
        } else {
            billlistap.setFilter(new QFilter("name", "=", null));
        }
        billlistap.refresh();
        ListSelectedRowCollection allRow = billlistap.getCurrentListAllRowCollection();
        if (EmptyUtil.isNoEmpty((Object)allRow)) {
            billlistap.clearSelection();
            billlistap.selectRows(0);
            ListSelectedRow selectedRow = allRow.get(0);
            if (EmptyUtil.isNoEmpty((Object)selectedRow)) {
                Object primaryKey = selectedRow.getPrimaryKeyValue();
                this.loadListData(primaryKey);
            }
        }
        this.getModel().setDataChanged(dataChanged);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        boolean bisuptrans = (Boolean)this.getModel().getValue("istransup");
        boolean bisdowntrans = (Boolean)this.getModel().getValue("istransdown");
        BigDecimal dminupamt = (BigDecimal)this.getModel().getValue("minupamt");
        BigDecimal dmindownamt = (BigDecimal)this.getModel().getValue("mindownamt");
        switch (key) {
            case "minupamt": 
            case "transupint": {
                if (this.repeatFlag) {
                    this.repeatFlag = false;
                    break;
                }
                String transUpInt = (String)this.getModel().getValue("transupint");
                BigDecimal transUpIntDec = String2DecUtil.string2Dec((String)transUpInt);
                if (!bisuptrans || FcaUpWayEnum.ISUPQUOTA.getValue().equals(this.getModel().getValue("upway")) || dminupamt.compareTo(transUpIntDec) >= 0) break;
                this.repeatFlag = true;
                this.getView().showTipNotification(new FcaBizConstant().getUpamtatleastminupamt(), Integer.valueOf(2000));
                this.getModel().setValue("minupamt", (Object)0);
                break;
            }
            case "mindownamt": 
            case "transdownint": {
                if (this.repeatFlag) {
                    this.repeatFlag = false;
                    break;
                }
                String transDownInt = (String)this.getModel().getValue("transdownint");
                BigDecimal transDownIntDec = String2DecUtil.string2Dec((String)transDownInt);
                if (!bisdowntrans || FcaDownWayEnum.ISDOWNQUOTA.getValue().equals(this.getModel().getValue("downway")) || dmindownamt.compareTo(transDownIntDec) >= 0) break;
                this.repeatFlag = true;
                this.getView().showTipNotification(new FcaBizConstant().getDownamtatleastmindownamt(), Integer.valueOf(2000));
                this.getModel().setValue("mindownamt", (Object)0);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final BillList cardbilllist = (BillList)this.getControl("billlistap");
        BillList acctgroupbilllist = (BillList)this.getControl("acctgroupbilllist");
        if (EmptyUtil.isEmpty((Object)cardbilllist)) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)acctgroupbilllist)) {
            return;
        }
        cardbilllist.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ListSelectedRow selectCar = evt.getCurrentListSelectedRow();
                if (selectCar != null) {
                    Object primaryKey = selectCar.getPrimaryKeyValue();
                    TranStrategyEdit.this.loadListData(primaryKey);
                } else {
                    ListSelectedRowCollection allRow = cardbilllist.getCurrentListAllRowCollection();
                    if (EmptyUtil.isNoEmpty((Object)allRow)) {
                        cardbilllist.clearSelection();
                        cardbilllist.selectRows(0);
                        ListSelectedRow selectedRow = allRow.get(0);
                        if (EmptyUtil.isNoEmpty((Object)selectedRow)) {
                            Object primaryKey = selectedRow.getPrimaryKeyValue();
                            TranStrategyEdit.this.loadListData(primaryKey);
                        }
                    }
                }
            }
        });
        cardbilllist.addHyperClickListener(evt -> {
            Object focusRowPkId = ((BillList)evt.getSource()).getFocusRowPkId();
            String fieldName = evt.getFieldName();
            BaseShowParameter showParameter = new BaseShowParameter();
            switch (fieldName) {
                case "acctgroupnumber": {
                    showParameter.setFormId("fca_acctgroup");
                    showParameter.setPkId(focusRowPkId);
                    this.linkShow(showParameter);
                }
            }
        });
        acctgroupbilllist.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            BaseShowParameter showParameter = new BaseShowParameter();
            Object entryPk = acctgroupbilllist.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
            switch (fieldName) {
                case "bankacct_number": {
                    String entrbankacctsql = "select fentrybankacctid from t_fca_acctgroup_entrys  where fentryid=?";
                    List entrbankacctid = (List)DB.query((DBRoute)DBRouteConst.TMC, (String)entrbankacctsql, (Object[])new Object[]{entryPk}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                        public List<String> handle(ResultSet resultSet) throws Exception {
                            ArrayList<String> entrbankacctid = new ArrayList<String>(resultSet.getRow() + 1);
                            while (resultSet.next()) {
                                entrbankacctid.add(resultSet.getString(1));
                            }
                            return entrbankacctid;
                        }
                    });
                    showParameter.setPkId(entrbankacctid.get(0));
                    showParameter.setFormId("bd_accountbanks");
                    this.linkShow(showParameter);
                    break;
                }
                case "inneracct_number": {
                    String entrinnacctsql = "select finneracctid from t_fca_acctgroup_entrys  where fentryid=?";
                    List entrinnacctid = (List)DB.query((DBRoute)DBRouteConst.TMC, (String)entrinnacctsql, (Object[])new Object[]{entryPk}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                        public List<String> handle(ResultSet resultSet) throws Exception {
                            ArrayList<String> entrinnacctid = new ArrayList<String>(resultSet.getRow() + 1);
                            while (resultSet.next()) {
                                entrinnacctid.add(resultSet.getString(1));
                            }
                            return entrinnacctid;
                        }
                    });
                    showParameter.setPkId(entrinnacctid.get(0));
                    showParameter.setFormId("ifm_inneracct");
                    this.linkShow(showParameter);
                }
            }
        });
        acctgroupbilllist.addSetFilterListener(listener -> {
            if (this.getModel().getValue("acctgroup") != null) {
                DynamicObject acctGroup = (DynamicObject)this.getModel().getValue("acctgroup");
                QFilter acctgroupFilter = new QFilter("id", "=", acctGroup.getPkValue());
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                QFilter transtryFilter = new QFilter("entrys.transtrategy", "=", pkValue);
                acctgroupFilter.and(transtryFilter);
                listener.getQFilters().add(acctgroupFilter);
            }
        });
    }

    void loadListData(Object primaryKey) {
        BillList acctgroupbilllist = (BillList)this.getControl("acctgroupbilllist");
        this.getModel().setValue("acctgroup", primaryKey);
        DynamicObject accountbankDO = TmcDataServiceHelper.loadSingle((Object)primaryKey, (String)"fca_acctgroup", (String)"accountbank.bank,accountbank.acctstatus");
        String bankname = "";
        if (accountbankDO.getLocaleString("accountbank.bank.name") != null) {
            bankname = accountbankDO.getLocaleString("accountbank.bank.name").getLocaleValue();
        }
        String acctstatus = accountbankDO.getString("accountbank.acctstatus");
        this.getModel().setValue("bank", (Object)bankname);
        this.getModel().setValue("acctstatus", (Object)acctstatus);
        QFilter acctgroupFilter = new QFilter("id", "=", primaryKey);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        QFilter transtryFilter = new QFilter("entrys.transtrategy", "=", pkValue);
        acctgroupFilter.and(transtryFilter);
        acctgroupbilllist.setFilter(acctgroupFilter);
        acctgroupbilllist.refresh();
    }

    private void linkShow(BaseShowParameter showParameter) {
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

