/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fcs.common.enums.RiskCheckScopeEnum;

public class TradeInterChangeConfig
implements Serializable {
    private static final long serialVersionUID = 5444748364587823956L;
    private boolean isSameBill = false;
    private String billNumber;
    private String checkNumber;
    private String forwardPayAccount;
    private String payAmount;
    private String forwardRecAccount;
    private String forwardEntity;
    private Set<String> forwardField = new HashSet<String>();
    private String reversePayAccount;
    private String recAmount;
    private String reverseRecAccount;
    private Set<String> reverseField = new HashSet<String>();
    private String reverseEntity;
    private String filterCondition;
    private String objectScope;

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getForwardPayAccount() {
        return this.forwardPayAccount;
    }

    public void setForwardPayAccount(String forwardPayAccount) {
        this.forwardPayAccount = forwardPayAccount;
    }

    public String getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(String payAmount) {
        this.payAmount = payAmount;
    }

    public String getForwardRecAccount() {
        return this.forwardRecAccount;
    }

    public void setForwardRecAccount(String forwardRecAccount) {
        this.forwardRecAccount = forwardRecAccount;
    }

    public String getReversePayAccount() {
        return this.reversePayAccount;
    }

    public void setReversePayAccount(String reversePayAccount) {
        this.reversePayAccount = reversePayAccount;
    }

    public String getRecAmount() {
        return this.recAmount;
    }

    public void setRecAmount(String recAmount) {
        this.recAmount = recAmount;
    }

    public String getReverseRecAccount() {
        return this.reverseRecAccount;
    }

    public void setReverseRecAccount(String reverseRecAccount) {
        this.reverseRecAccount = reverseRecAccount;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public String getObjectScope() {
        return this.objectScope;
    }

    public void setObjectScope(String objectScope) {
        this.objectScope = objectScope;
    }

    public String getForwardEntity() {
        return this.forwardEntity;
    }

    public void setForwardEntity(String forwardEntity) {
        this.forwardEntity = forwardEntity;
    }

    public String getReverseEntity() {
        return this.reverseEntity;
    }

    public void setReverseEntity(String reverseEntity) {
        this.reverseEntity = reverseEntity;
    }

    public Set<String> getForwardField() {
        return this.forwardField;
    }

    public void setForwardField(Set<String> forwardField) {
        this.forwardField = forwardField;
    }

    public Set<String> getReverseField() {
        return this.reverseField;
    }

    public void setReverseField(Set<String> reverseField) {
        this.reverseField = reverseField;
    }

    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public boolean isSameBill() {
        return this.isSameBill;
    }

    public void setSameBill(boolean sameBill) {
        this.isSameBill = sameBill;
    }

    public static List<TradeInterChangeConfig> loadFromDynamicObject(DynamicObject itemConfig) {
        ArrayList<TradeInterChangeConfig> configList = new ArrayList<TradeInterChangeConfig>(10);
        String billNumber = itemConfig.getDynamicObject("appbill").getString("number");
        String checkWay = itemConfig.getString("checkway");
        if (RiskCheckScopeEnum.OTHER.getValue().equals(checkWay)) {
            DynamicObjectCollection filterList = itemConfig.getDynamicObjectCollection("filterentry");
            for (DynamicObject filter : filterList) {
                TradeInterChangeConfig config = new TradeInterChangeConfig();
                config.setBillNumber(billNumber);
                config.setCheckNumber(filter.getDynamicObject("flobject").getString("number"));
                config.setFilterCondition(filter.getString("flcondition_tag"));
                config.setObjectScope(filter.getString("flobjscope_tag"));
                DynamicObjectCollection paramEntrys = filter.getDynamicObjectCollection("paramentry");
                Set paramBills = paramEntrys.stream().filter(s -> "payamount".equals(s.get("param")) || "recamount".equals(s.get("param"))).map(s -> s.getDynamicObject("parambill").getString("number")).collect(Collectors.toSet());
                if (paramBills.size() == 1) {
                    config.setSameBill(true);
                }
                paramEntrys.forEach(config::setByParam);
                configList.add(config);
            }
        }
        return configList;
    }

    private void setByParam(DynamicObject paramObject) {
        String param = paramObject.getString("param");
        String field = paramObject.getString("paramfield");
        switch (param) {
            case "forwardpayaccount": {
                String payNumber = paramObject.getDynamicObject("parambill").getString("number");
                this.setForwardEntity(payNumber);
                this.setForwardPayAccount(field);
                this.forwardField.add(field);
                break;
            }
            case "payamount": {
                this.setPayAmount(field);
                this.forwardField.add(field);
                if (!this.isSameBill) break;
                this.reverseField.add(field);
                break;
            }
            case "forwardrecaccount": {
                this.setForwardRecAccount(field);
                this.forwardField.add(field);
                break;
            }
            case "reversepayaccount": {
                String recNumber = paramObject.getDynamicObject("parambill").getString("number");
                this.setReverseEntity(recNumber);
                this.setReversePayAccount(field);
                this.reverseField.add(field);
                break;
            }
            case "recamount": {
                this.setRecAmount(field);
                this.reverseField.add(field);
                if (!this.isSameBill) break;
                this.forwardField.add(field);
                break;
            }
            case "reverserecaccount": {
                this.setReverseRecAccount(field);
                this.reverseField.add(field);
                break;
            }
        }
    }
}

