/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ConditionFactory {
    private static final Log logger = LogFactory.getLog(ConditionFactory.class);
    protected ConvertContext context;
    protected SingleRuleContext ruleContext;

    public void init(CRCondition conditionObj, String entityName) {
        ConvertContext context = new ConvertContext();
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        context.setSourceMainType(srcMainType);
        ConvertRuleElement rule = new ConvertRuleElement();
        rule.setRunCondition(conditionObj);
        SingleRuleContext ruleContext = new SingleRuleContext();
        ruleContext.setContext(context);
        ruleContext.setRule(rule);
        ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
        ruleContext.setRuleCompiler(ruleCompiler);
        this.context = context;
        this.ruleContext = ruleContext;
    }

    public void init(ConvertContext context, SingleRuleContext ruleContext) {
        this.context = context;
        this.ruleContext = ruleContext;
    }

    private Set<Long> getIdsOnlyGridFilter(CRConditionCompiler runCondCompiler, Set<Long> srcBillIds) {
        DynamicObject[] col;
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        runCondCompiler.getGridQFilters().add(idFilter);
        Object[] filters = runCondCompiler.getGridQFilters().toArray(new QFilter[0]);
        logger.info("getIdsOnlyGridFilter:" + Arrays.toString(filters));
        for (DynamicObject co : col = BusinessDataServiceHelper.load((String)entityNumber, (String)"id", (QFilter[])filters)) {
            logger.info("\u5904\u7406\u540e\u7684ID:" + co.getLong("id"));
        }
        Set<Long> ids = Arrays.stream(col).map(o -> o.getLong("id")).collect(Collectors.toSet());
        logger.info("ids:" + ids.size());
        return ids;
    }

    public Set<Long> runCondition(Set<Long> srcBillIds) {
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        if (runCondCompiler.getGridQFilters().isEmpty() && this.isExpressionExecuter()) {
            return srcBillIds;
        }
        if (!runCondCompiler.getGridQFilters().isEmpty() && this.isExpressionExecuter()) {
            return this.getIdsOnlyGridFilter(runCondCompiler, srcBillIds);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        HashMap<String, String> fieldAlias = new HashMap<String, String>(16);
        ArrayList<String> selectFields = new ArrayList<String>(10);
        fieldAlias.put(pkFieldName, pkFieldName);
        selectFields.add(pkFieldName);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        this.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
        this.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
        String selectString = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        qFilters.add(idFilter);
        QFilter[] arrQFilters = new QFilter[qFilters.size()];
        arrQFilters = qFilters.toArray(arrQFilters);
        ORM orm = ORM.create();
        DynamicObjectCollection rows = null;
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectString, arrQFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = rows.getDynamicObjectType();
        for (Map.Entry entry : fieldAlias.entrySet()) {
            String fldKey = (String)entry.getKey();
            String fldAlias = (String)entry.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(fldKey, property);
        }
        HashMap<String, Long> memIdSet = new HashMap<String, Long>(srcBillIds.size());
        for (Long id : srcBillIds) {
            String idString = String.valueOf(id);
            memIdSet.put(idString, id);
        }
        HashSet<Long> hashSet = new HashSet<Long>(16);
        for (DynamicObject row : rows) {
            if (!((Boolean)expressExecutor.getValue(fieldPropertys, row)).booleanValue() || !((Boolean)gridFilterExecutor.getValue(fieldPropertys, row)).booleanValue()) continue;
            Object billId = row.get(pkFieldName);
            String idString = String.valueOf(billId);
            Long memBillId = (Long)memIdSet.get(idString);
            hashSet.add(memBillId);
        }
        return hashSet;
    }

    public boolean isExpressionExecuter() {
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        return runCondCompiler.getExpressionExecuter() instanceof GetConstValue && (Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue() != false;
    }

    public Map<String, BigDecimal> runCondition(Set<Long> srcBillIds, String amtFieldProp, String entryIdFieldProp) {
        HashMap<String, BigDecimal> myBillIds = new HashMap<String, BigDecimal>(16);
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        qFilters.add(idFilter);
        QFilter[] arrQFilters = new QFilter[qFilters.size()];
        arrQFilters = qFilters.toArray(arrQFilters);
        if (runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            ORM orm = ORM.create();
            DynamicObjectCollection rows = null;
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, entryIdFieldProp + "," + amtFieldProp, arrQFilters);){
                rows = orm.toPlainDynamicObjectCollection(ds);
            }
            for (DynamicObject row : rows) {
                Object entryId = row.get(entryIdFieldProp);
                Object amt = row.get(amtFieldProp);
                myBillIds.put(String.valueOf(entryId), new BigDecimal(String.valueOf(amt)));
            }
            return myBillIds;
        }
        HashMap<String, String> fieldAlias = new HashMap<String, String>(16);
        ArrayList<String> selectFields = new ArrayList<String>(10);
        fieldAlias.put(pkFieldName, pkFieldName);
        fieldAlias.put(amtFieldProp, amtFieldProp);
        fieldAlias.put(entryIdFieldProp, entryIdFieldProp);
        selectFields.add(pkFieldName);
        selectFields.add(amtFieldProp);
        selectFields.add(entryIdFieldProp);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        this.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
        this.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
        String selectString = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        ORM orm = ORM.create();
        DynamicObjectCollection rows = null;
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectString, arrQFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = rows.getDynamicObjectType();
        for (Map.Entry aliasItem : fieldAlias.entrySet()) {
            String fldKey = (String)aliasItem.getKey();
            String fldAlias = (String)aliasItem.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(fldKey, property);
        }
        for (DynamicObject row : rows) {
            if (!((Boolean)expressExecutor.getValue(fieldPropertys, row)).booleanValue() || !((Boolean)gridFilterExecutor.getValue(fieldPropertys, row)).booleanValue()) continue;
            Object entryId = row.get(entryIdFieldProp);
            Object amt = row.get(amtFieldProp);
            myBillIds.put(String.valueOf(entryId), new BigDecimal(String.valueOf(amt)));
        }
        return myBillIds;
    }

    public Boolean isMatchCondition(DynamicObject row) {
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        if (runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            return true;
        }
        BillEntityType srcMainType = this.context.getSourceMainType();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        HashMap<String, String> fieldAlias = new HashMap<String, String>(16);
        fieldAlias.put(pkFieldName, pkFieldName);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        for (IVariableMode var : expressExecutor.getVars()) {
            if (!(var instanceof SourceFieldVariable)) continue;
            fieldAlias.put(var.getVar(), var.getVar());
        }
        for (IVariableMode var : gridFilterExecutor.getVars()) {
            if (!(var instanceof SourceFieldVariable)) continue;
            fieldAlias.put(var.getVar(), var.getVar());
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = row.getDynamicObjectType();
        for (Map.Entry aliasItem : fieldAlias.entrySet()) {
            String fldKey = (String)aliasItem.getKey();
            String fldAlias = (String)aliasItem.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(fldKey, property);
        }
        return (Boolean)expressExecutor.getValue(fieldPropertys, row) != false && (Boolean)gridFilterExecutor.getValue(fieldPropertys, row) != false;
    }

    private void addSourceFields(List<IVariableMode> vars, List<String> selectFldStrings, Map<String, String> fieldAlias) {
        int fieldIndex = fieldAlias.size();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable) || fieldAlias.containsKey(var.getVar())) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldAlias = "f" + fieldIndex;
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            fieldAlias.put(var.getVar(), fldAlias);
            ++fieldIndex;
        }
    }
}

