/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.tmc.fcs.common.helper.BillTreeBuildParameter;

public class EntityParseHelper {
    public static TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = EntityParseHelper.buildFldTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet(mainType.getAllEntities().keySet());
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityParseHelper_0", (String)"tmc-fcs-common", (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            EntityParseHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = EntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), entityNode, "");
            if (idNode != null) {
                idNode.setText(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"tmc-fcs-common", (Object[])new Object[]{entityType.getDisplayName().toString()}));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode idNode = EntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), entityNode, entityType.getName());
            if (idNode != null) {
                idNode.setText(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"tmc-fcs-common", (Object[])new Object[]{entityType.getDisplayName().toString()}));
                entityFldNodes.add(idNode);
            }
        }
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix) {
        TreeNode fldNode = null;
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (prop != null) {
            String fldNodeId = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }
}

