/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ErrorFieldMapHelper {
    public static DynamicObject getErrorFieldMapBySrcEntity(String srcEntity) {
        QFilter qFilter = new QFilter("srcentity.number", "=", (Object)srcEntity);
        qFilter.and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        return TmcDataServiceHelper.loadSingleFromCache((String)"fcs_errorfield_map", (QFilter[])qFilter.toArray());
    }

    public static String querySrcFieldPropByDestField(DynamicObjectCollection entrys, String destField) {
        DynamicObject entry = entrys.stream().filter(s -> destField.equals(s.getString("destfield"))).findFirst().orElse(null);
        if (entry != null) {
            return entry.getString("srcfield");
        }
        return null;
    }

    public static Pair<DynamicObject, Map<Long, DynamicObject>> genErrorData(String entity, List<Long> ids) {
        HashMap<Long, DynamicObject> returnMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject errorFieldMap = ErrorFieldMapHelper.getErrorFieldMapBySrcEntity(entity);
        DynamicObjectCollection entrys = errorFieldMap.getDynamicObjectCollection("entry");
        String select = entrys.stream().map(s -> s.getString("srcfield")).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(","));
        QFilter qFilter = new QFilter("id", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryGenErrorData", (String)entity, (String)("id," + select), (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                DynamicObject errorData = TmcDataServiceHelper.newDynamicObject((String)"fcs_errordata");
                Long billId = row.getLong("id");
                errorData.set("billid", (Object)billId);
                errorData.set("billno", (Object)row.getString("billno"));
                errorData.set("datatype", (Object)entity);
                errorData.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                for (DynamicObject entry : entrys) {
                    String srcField = entry.getString("srcfield");
                    if (!EmptyUtil.isNoEmpty((String)srcField)) continue;
                    errorData.set(entry.getString("destfield"), row.get(srcField));
                }
                errorData.set("creator", (Object)RequestContext.get().getCurrUserId());
                errorData.set("createtime", (Object)DateUtils.getCurrentTime());
                returnMap.put(billId, errorData);
            }
        }
        return Pair.of((Object)errorFieldMap, returnMap);
    }
}

