/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;

public class OpenBillHelper {
    private OpenBillHelper() {
    }

    public static void openSchema(IFormView view, DynamicObject dyn) {
        DynamicObject schedule = dyn.getDynamicObject("schedule");
        String entity = ScheduleTaskTypeEnum.isOperation(schedule.getString("tasktype")) ? "fcs_schedule_bussoper" : "fcs_schedule_task";
        OpenBillHelper.openFormByPKId(view, schedule.getLong("id"), entity);
    }

    public static void openExecOperDetailLog(IFormView view, DynamicObject dyn, Long entryPk) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("schemaid", dyn.getLong("schedule.id"));
        if (ScheduleTaskTypeEnum.isOperation(dyn.getString("tasktype"))) {
            params.put("schemasumlogid", dyn.getLong("id"));
        }
        params.put("taskid", OpenBillHelper.getTaskId(dyn, entryPk));
        OpenBillHelper.openBillList(view, params);
    }

    private static Long getTaskId(DynamicObject dyn, Long entryPk) {
        DynamicObjectCollection entryEntitys = dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntitys) {
            if (entry.getLong("id") != entryPk.longValue()) continue;
            return entry.getLong("taskid");
        }
        return 0L;
    }

    private static void openBillList(IFormView view, Map<String, Object> params) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fcs_scheduledetail_log");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        if (Objects.nonNull(params)) {
            parameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)parameter);
    }

    public static void openFormByPKId(IFormView view, Object pkId, String bussiness) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(bussiness);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)parameter);
    }
}

