/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class PayAccessHelper {
    public static Map<Object, Object> getBotpInfos(DynamicObject[] bills) {
        HashMap<Object, Object> BilsMap = new HashMap<Object, Object>(16);
        for (DynamicObject bill : bills) {
            Map<String, Object> map = PayAccessHelper.getBotpInfo(bill);
            BilsMap.put(bill.getPkValue(), map);
        }
        return BilsMap;
    }

    public static Map<String, Object> getBotpInfo(DynamicObject bill) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)bill.getDynamicObjectType().getName());
        Map allEntities = mainType.getAllEntities();
        List lkList = allEntities.keySet().stream().filter(s -> s.contains("_lk")).collect(Collectors.toList());
        map.put("lkList", lkList);
        map.put("isBotp", false);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        HashMap<String, Object> recordMap = new HashMap<String, Object>(16);
        if (EmptyUtil.isNoEmpty(lkList)) {
            for (String linkProp : lkList) {
                if (linkProp.equals("billhead_lk")) {
                    PayAccessHelper.setCommonMapInfo(map, bill, linkProp, list, recordMap, null);
                    continue;
                }
                List collect = mainType.getAllEntities().entrySet().stream().filter(s -> ((String)s.getKey()).equals(linkProp)).map(o -> ((EntityType)o.getValue()).getParent().getName()).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(collect) || !bill.getDynamicObjectType().getProperties().containsKey(collect.get(0))) continue;
                DynamicObjectCollection entrtyDatas = bill.getDynamicObjectCollection((String)collect.get(0));
                for (DynamicObject entrtyData : entrtyDatas) {
                    PayAccessHelper.setCommonMapInfo(map, entrtyData, linkProp, list, recordMap, (String)collect.get(0));
                }
            }
            map.put("lkinfo", recordMap);
        }
        return map;
    }

    private static void setCommonMapInfo(Map<String, Object> map, DynamicObject bill, String linkProp, List<DynamicObject> list, Map<String, Object> recordMap, String entryName) {
        DynamicObjectCollection lk;
        if (bill.getDynamicObjectType().getProperties().containsKey((Object)linkProp) && (lk = bill.getDynamicObjectCollection(linkProp)).size() > 0) {
            if (entryName != null) {
                recordMap.put("entryName", entryName);
            }
            map.put("isBotp", true);
            list.addAll((Collection<DynamicObject>)lk);
            if (list.get(0).getDynamicObjectType().getProperties().containsKey((Object)(linkProp + "_stableid"))) {
                Long stableId = list.get(0).getLong(linkProp + "_stableid");
                String srcEntityNumber = EntityMetadataCache.loadTableDefine((Long)stableId).getEntityNumber();
                recordMap.put("srcEntityNumber", srcEntityNumber);
            }
            recordMap.put(linkProp, list);
        }
    }

    public static boolean isInBlackList(String destEntity) {
        DynamicObject entity = PayAccessHelper.getBlackListByEntity(destEntity);
        return EmptyUtil.isNoEmpty((DynamicObject)entity);
    }

    public static DynamicObject getBlackListByEntity(String destEntity) {
        QFilter qFilter = new QFilter("destentity.number", "=", (Object)destEntity);
        qFilter.and("enable", "=", (Object)"1");
        return TmcDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess_blacklist", (QFilter[])qFilter.toArray());
    }

    public static boolean isInWhiteList(Object pkValue) {
        DynamicObject entity = PayAccessHelper.getWhiteList(pkValue);
        return EmptyUtil.isNoEmpty((DynamicObject)entity);
    }

    public static DynamicObject getWhiteList(Object pkValue) {
        QFilter qFilter = new QFilter("payaccess", "=", pkValue);
        qFilter.and("enable", "=", (Object)"1");
        return TmcDataServiceHelper.loadSingleFromCache((String)"fcs_repeatctrl_whitelist", (QFilter[])qFilter.toArray());
    }

    public static Map<Object, DynamicObject> queryWhiteOrBlackListByEntity(Set<String> entrySet, String queryEntity) {
        QFilter qFilter = new QFilter("destentity.number", "in", entrySet);
        qFilter.and("enable", "=", (Object)"1");
        return TmcDataServiceHelper.loadFromCache((String)queryEntity, (QFilter[])qFilter.toArray());
    }

    public static boolean isFullNodeCtrl() {
        DynamicObject ctrlNode = PayAccessHelper.getPayAccessNode();
        if (ctrlNode != null) {
            return ctrlNode.getBoolean("isfulllink");
        }
        return false;
    }

    public static boolean isApiPass() {
        DynamicObject ctrlNode = PayAccessHelper.getPayAccessNode();
        if (ctrlNode != null) {
            return ctrlNode.getBoolean("apipass");
        }
        return false;
    }

    public static boolean isAsync() {
        DynamicObject async = PayAccessHelper.getPayAccessNode();
        if (async != null) {
            return async.getBoolean("async");
        }
        return false;
    }

    public static boolean isAsyncValid() {
        DynamicObject ctrlNode = PayAccessHelper.getPayAccessNode();
        if (ctrlNode != null) {
            boolean isFullLink = ctrlNode.getBoolean("isfulllink");
            boolean isAsync = ctrlNode.getBoolean("async");
            return !isFullLink || isFullLink && isAsync;
        }
        return false;
    }

    public static DynamicObject getPayAccessNode() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        return TmcDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess_set", (QFilter[])qFilter.toArray());
    }

    public static Map<Object, DynamicObject> getPayAccessInfo(Set<String> entrySet, Set<Object> idSet) {
        QFilter qFilter = new QFilter("destentity.number", "in", entrySet);
        qFilter.or("srcentity.number", "in", entrySet);
        qFilter.and("enable", "=", (Object)"1");
        if (idSet.size() > 0) {
            qFilter.and("id", "not in", idSet);
        }
        return TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess", (String)"id,srcentity,destentity,operate", (QFilter[])qFilter.toArray());
    }

    public static Pair<Map<Long, List<DynamicObject>>, List<String>> getPayAccessRecordByDestBills(DynamicObject[] bills) {
        Set<Long> idSet = Arrays.stream(bills).map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] payRecords = PayAccessHelper.getPayAccessRecord(idSet);
        Map<Long, List<DynamicObject>> collect = Arrays.stream(payRecords).collect(Collectors.groupingBy(v -> v.getLong("destbillpkid")));
        List srcPkIdList = Arrays.stream(payRecords).map(s -> s.getString("srcbillpkid")).collect(Collectors.toList());
        return Pair.of(collect, srcPkIdList);
    }

    public static DynamicObject[] getPayAccessRecord(Set<Long> pks) {
        QFilter qFilter = new QFilter("destbillpkid", "in", pks);
        String selctProp = "id,srcentity,srcentryprop,srcbillpkid,srcbillid,srcidprop,destentity,destentryprop,destbillpkid,destbillid,destidprop,isrepeatresult,isexcessresult,newway,batchno,fulllinkid,success";
        return TmcDataServiceHelper.load((String)"fcs_payaccess_record", (String)selctProp, (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getPayAccessRecord(Long pks) {
        QFilter qFilter = new QFilter("destbillpkid", "=", (Object)pks);
        return QueryServiceHelper.queryOne((String)"fcs_payaccess_record", (String)"id", (QFilter[])qFilter.toArray());
    }

    public static Map<Object, DynamicObject> getPayAccessInfo(String entryNumber) {
        QFilter qFilter = new QFilter("destentity.number", "=", (Object)entryNumber);
        qFilter.and("enable", "=", (Object)"1");
        return TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess", (String)"id,srcentity,destentity,operate", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getMainEntityInfo(String entryNumber) {
        QFilter filter = new QFilter("number", "=", (Object)entryNumber);
        return TmcDataServiceHelper.loadSingleFromCache((String)"bos_billmainentity", (QFilter[])filter.toArray());
    }

    public static String getRedisKey() {
        String requestId = RequestContext.get().getRequestId();
        return requestId + ".src.entity";
    }

    public static String getPayaccessNewParam() {
        QFilter qFilter = new QFilter("number", "=", (Object)"NEW_PARAM");
        DynamicObject newParam = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess_newparam", (String)"param", (QFilter[])qFilter.toArray());
        return newParam.getString("param");
    }
}

