/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.TradeInterChangeConfig;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.RiskServiceHelper;

public class RiskChangeServiceHelper {
    public static final String CACHE_KEY = "tmc.fcs.TradeInterChangeService";
    public static final String CACHE_TIME_KEY = "tmc.fcs.TradeInterChangeService.Time";
    private static final Log logger = LogFactory.getLog(RiskChangeServiceHelper.class);

    static Map<Object, List<DynamicObject>> queryLeftData(List<Long> billIdList, DynamicObject riskItemConfig) {
        List<TradeInterChangeConfig> configList = TradeInterChangeConfig.loadFromDynamicObject(riskItemConfig);
        ConditionFactory factory = new ConditionFactory();
        for (TradeInterChangeConfig config : configList) {
            Set<Long> matchIds = new HashSet<Long>(billIdList);
            String filterCondition = config.getFilterCondition();
            if (EmptyUtil.isNoEmpty((String)filterCondition)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)filterCondition, CRCondition.class);
                factory.init(conditionObj, config.getBillNumber());
                matchIds = factory.runCondition(new HashSet<Long>(billIdList));
                if (EmptyUtil.isEmpty(matchIds)) continue;
            }
            long startTime = System.currentTimeMillis();
            String forwardProp = "id,billno," + String.join((CharSequence)",", config.getForwardField());
            DynamicObjectCollection forwardDatas = QueryServiceHelper.query((String)config.getBillNumber(), (String)forwardProp, (QFilter[])new QFilter("id", "in", matchIds).toArray());
            logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u6b63\u5411\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
            List<DynamicObject> forwardDataList = RiskServiceHelper.filterOppUnits(new ArrayList<DynamicObject>((Collection<DynamicObject>)forwardDatas), config.getForwardRecAccount());
            if (EmptyUtil.isEmpty(forwardDataList)) {
                logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb:\u5254\u9664\u5185\u90e8\u5f80\u6765\u3001\u4e0a\u5212\u4e0b\u62e8\u3001\u8c03\u62e8\u5904\u7406");
                return null;
            }
            Map<Object, List<DynamicObject>> collectPay = forwardDatas.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get(config.getPayAmount())) && new BigDecimal(String.valueOf(o.get(config.getPayAmount()))).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.groupingBy(s -> s.get(config.getPayAmount()), Collectors.toList()));
            if (config.isSameBill()) {
                Map<Object, List<DynamicObject>> collectRec = forwardDatas.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get(config.getRecAmount())) && new BigDecimal(String.valueOf(o.get(config.getRecAmount()))).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.groupingBy(s -> s.get(config.getRecAmount()), Collectors.toList()));
                RiskChangeServiceHelper.mergeMap(collectPay, collectRec);
            }
            return collectPay;
        }
        return null;
    }

    private static void mergeMap(Map<Object, List<DynamicObject>> payMap, Map<Object, List<DynamicObject>> recMap) {
        for (Map.Entry<Object, List<DynamicObject>> entry : recMap.entrySet()) {
            Object key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            if (payMap.containsKey(key)) {
                List<DynamicObject> existingValues = payMap.get(key);
                existingValues.addAll(value);
                continue;
            }
            payMap.put(key, value);
        }
    }

    public static String loadRiskParamValue(String number) {
        DynamicObject riskParam = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_riskparam", (String)"number,paramvalue", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return EmptyUtil.isNoEmpty((DynamicObject)riskParam) ? riskParam.getString("paramvalue") : null;
    }
}

