/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RiskExecStatusEnum;
import kd.tmc.fcs.common.model.RiskLogInfo;
import kd.tmc.fcs.common.model.RiskLogOp;
import org.apache.commons.lang3.StringUtils;

public class RiskLogHelper {
    private static final Log logger = LogFactory.getLog(RiskLogHelper.class);
    public static final int LONG_BYTES = 8;
    private static volatile RiskLogHelper INSTANT;
    private static final String OP_INSERT = "INSERT";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_START_BILL = "START_BILL";
    private static final String OP_START_SCREEN = "START_SCREEN";
    private final BlockingQueue<RiskLogOp> logOpQueue = new ArrayBlockingQueue<RiskLogOp>(10000);
    private static final ThreadPool THREAD_POOL;
    private volatile boolean isRunning = false;
    private static final ThreadLocal<RiskLogInfo> riskLogInfoLocal;

    private RiskLogHelper() {
    }

    private void executeTask() {
        this.isRunning = true;
        logger.info("start RiskLogHelper thread");
        THREAD_POOL.execute(this::run, RequestContext.get());
    }

    public static synchronized RiskLogHelper getInstance() {
        if (null == INSTANT) {
            INSTANT = new RiskLogHelper();
        }
        return INSTANT;
    }

    private void run() {
        while (true) {
            try {
                while (true) {
                    RiskLogOp logOp;
                    if (null != (logOp = this.logOpQueue.poll(10L, TimeUnit.SECONDS))) {
                        this.processLogOp(logOp);
                        continue;
                    }
                    this.isRunning = false;
                    if (this.logOpQueue.isEmpty()) break;
                }
                logger.info("task finish");
            }
            catch (Exception e) {
                logger.error("UnExpected Error:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void processLogOp(RiskLogOp logOp) {
        switch (logOp.getOpType()) {
            case "INSERT": {
                TmcDataServiceHelper.save((DynamicObject[])logOp.getDynamicObjects());
                break;
            }
            case "UPDATE": {
                DB.execute((DBRoute)DBRoute.of((String)DBRouteConst.TMC.getRouteKey()), (String)logOp.getSql(), (Object[])logOp.getParams());
                break;
            }
            case "START_BILL": {
                this.startBillLog(logOp);
                break;
            }
            case "START_SCREEN": {
                this.startScreenLog(logOp);
                break;
            }
        }
    }

    private void startBillLog(RiskLogOp logOp) {
        DynamicObject screenLog = logOp.getDynamicObjects()[0];
        ArrayList<DynamicObject> billLogs = new ArrayList<DynamicObject>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryStartBillLog", (String)screenLog.getString("billtype"), (String)"id,billno", (QFilter[])new QFilter("id", "in", logOp.getBillIds()).toArray(), null);){
            for (Row row : dataSet) {
                billLogs.add(this.toBillLog(row.getLong("id"), row.getString("billno"), screenLog));
            }
        }
        TmcDataServiceHelper.save((DynamicObject[])billLogs.toArray(new DynamicObject[0]));
    }

    /*
     * Exception decompiling
     */
    private void startScreenLog(RiskLogOp logOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String mergeBatchIdStr(String dbBatchId, String batchId) {
        return EmptyUtil.isBlank((CharSequence)dbBatchId) ? batchId : dbBatchId + "," + batchId;
    }

    public Long startRiskLog(Long riskScreenId, String execType, String billType, List<Long> billIds) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_risk_log");
        String tableName = obj.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        long id = ids[0];
        long userId = RequestContext.get().getCurrUserId();
        Date curTime = new Date();
        obj.set("id", (Object)id);
        obj.set("riskscreen", (Object)riskScreenId);
        obj.set("exectype", (Object)execType);
        obj.set("execstatus", (Object)RiskExecStatusEnum.PROCESS.getValue());
        obj.set("execuser", (Object)userId);
        obj.set("starttime", (Object)curTime);
        obj.set("creater", (Object)userId);
        RiskLogOp logOp = new RiskLogOp();
        logOp.setOpType(OP_INSERT);
        logOp.setDynamicObjects(new DynamicObject[]{obj});
        this.doOfferQueue(logOp);
        DynamicObject screenLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_riskscreen_log");
        screenLog.set("riskscreen", (Object)riskScreenId);
        screenLog.set("risklogid", (Object)id);
        screenLog.set("billtype", (Object)billType);
        screenLog.set("screenbatchid", (Object)0L);
        screenLog.set("execuser", (Object)userId);
        screenLog.set("starttime", (Object)curTime);
        screenLog.set("execres", (Object)RiskExecStatusEnum.PROCESS.getValue());
        screenLog.set("creater", (Object)userId);
        RiskLogOp billOp = new RiskLogOp();
        billOp.setOpType(OP_START_BILL);
        billOp.setDynamicObjects(new DynamicObject[]{screenLog});
        billOp.setBillIds(billIds);
        this.doOfferQueue(billOp);
        return id;
    }

    private DynamicObject toBillLog(Long billId, String billNo, DynamicObject screenLog) {
        DynamicObject billLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_riskbill_log");
        billLog.set("risklogid", screenLog.get("risklogid"));
        billLog.set("billtype", screenLog.get("billtype"));
        billLog.set("execres", screenLog.get("execres"));
        billLog.set("riskscreen", screenLog.get("riskscreen"));
        billLog.set("execuser", screenLog.get("execuser"));
        billLog.set("batchid", (Object)"");
        billLog.set("billid", (Object)billId);
        billLog.set("billno", (Object)billNo);
        billLog.set("starttime", screenLog.get("starttime"));
        billLog.set("creater", screenLog.get("creater"));
        return billLog;
    }

    public void noBillLog(String msg) {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        Date now = new Date();
        String sql = "update t_fcs_risk_log set fexecstatus=?,fendtime=?,fdetail=? where fid=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.SUCCESS.getValue(), now, msg, logInfo.getRiskLogId()));
        sql = "update t_fcs_riskbill_log set fexecres=?,fendtime=?,ferrormsg=? where frisklogid=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.SUCCESS.getValue(), now, msg, logInfo.getRiskLogId()));
    }

    public void filterBillLog(String msg, Collection<Long> billIds) {
        if (billIds.isEmpty()) {
            return;
        }
        RiskLogInfo logInfo = this.getRiskLogInfo();
        Date now = new Date();
        String sql = "update t_fcs_riskbill_log set fexecres=?,fendtime=?,ferrormsg=? where frisklogid=? and fbillid in (" + StringUtils.join(billIds, (String)",") + ")";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.SUCCESS.getValue(), now, msg, logInfo.getRiskLogId()));
    }

    public void finishRiskLog() {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        Date now = new Date();
        String successSql = "update t_fcs_riskbill_log set fexecres=?,fendtime=? where frisklogid=? and fexecnum=fsuccessnum and fexecres=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, successSql, RiskExecStatusEnum.SUCCESS.getValue(), now, logInfo.getRiskLogId(), RiskExecStatusEnum.PROCESS.getValue()));
        String billFailSql = "update t_fcs_riskbill_log set fexecres=?,fendtime=? where frisklogid=? and fexecres=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, billFailSql, RiskExecStatusEnum.FAILURE.getValue(), now, logInfo.getRiskLogId(), RiskExecStatusEnum.PROCESS.getValue()));
        String sql = "update t_fcs_risk_log set fexecstatus=?,fendtime=? where fid=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.SUCCESS.getValue(), now, logInfo.getRiskLogId()));
    }

    public void errorRiskLog(String errorMsg) {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        Date now = new Date();
        String billFailSql = "update t_fcs_riskbill_log set fexecres=?,fendtime=? where frisklogid=? and fexecnum!=fsuccessnum+ffailnum and fexecres=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, billFailSql, RiskExecStatusEnum.FAILURE.getValue(), now, logInfo.getRiskLogId(), RiskExecStatusEnum.PROCESS.getValue()));
        errorMsg = errorMsg.length() > 2000 ? errorMsg.substring(0, 1995) + "..." : errorMsg;
        String sql = "update t_fcs_risk_log set fexecstatus=?,fendtime=?,fdetail=? where fid=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.FAILURE.getValue(), now, errorMsg, logInfo.getRiskLogId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOfferQueue(RiskLogOp logOp) {
        while (!this.logOpQueue.offer(logOp)) {
            logger.warn("offer queue error");
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (Exception e) {
                logger.error("wait error", (Throwable)e);
            }
        }
        if (!this.isRunning) {
            BlockingQueue<RiskLogOp> blockingQueue = this.logOpQueue;
            synchronized (blockingQueue) {
                if (!this.isRunning) {
                    this.executeTask();
                }
            }
        }
    }

    public Long startBatch(Integer partIndex, List<Long> billIds) {
        DynamicObject screenLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_riskscreen_log");
        String tableName = screenLog.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        long id = ids[0];
        long userId = RequestContext.get().getCurrUserId();
        Date curTime = new Date();
        RiskLogInfo logInfo = this.getRiskLogInfo();
        screenLog.set("id", (Object)id);
        screenLog.set("riskscreen", (Object)logInfo.getScreenId());
        screenLog.set("risklogid", (Object)logInfo.getRiskLogId());
        screenLog.set("screenitem", (Object)logInfo.getScreenItem());
        screenLog.set("billtype", (Object)logInfo.getBillType());
        screenLog.set("screenbatchid", (Object)this.genScreenBatchId(partIndex));
        screenLog.set("execuser", (Object)userId);
        screenLog.set("starttime", (Object)curTime);
        screenLog.set("execres", (Object)RiskExecStatusEnum.PROCESS.getValue());
        screenLog.set("creater", (Object)userId);
        RiskLogOp billOp = new RiskLogOp();
        billOp.setOpType(OP_START_SCREEN);
        billOp.setDynamicObjects(new DynamicObject[]{screenLog});
        billOp.setBillIds(billIds);
        this.doOfferQueue(billOp);
        return id;
    }

    public void finishBatch(List<Long> billIds) {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        Date now = new Date();
        String sql = "update t_fcs_riskscreen_log set fexecres=?,fendtime=? where fid=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.SUCCESS.getValue(), now, logInfo.getBatchId()));
        sql = "update t_fcs_riskbill_log set fsuccessnum=fsuccessnum+1 where frisklogid=? and fbillid in (" + StringUtils.join(billIds, (String)",") + ")";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, logInfo.getRiskLogId()));
    }

    public void errorBatch(List<Long> billIds, String errorMsg) {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        Date now = new Date();
        errorMsg = errorMsg.length() > 2000 ? errorMsg.substring(0, 1995) + "..." : errorMsg;
        String sql = "update t_fcs_riskscreen_log set fexecres=?,fendtime=?,ferrormsg=? where fid=?";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.FAILURE.getValue(), now, errorMsg, logInfo.getBatchId()));
        sql = "update t_fcs_riskbill_log set ffailnum=ffailnum+1 where frisklogid=? and fbillid in (" + StringUtils.join(billIds, (String)",") + ")";
        this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, logInfo.getRiskLogId()));
    }

    public void checkBillFinish(List<Long> billIds) {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        if (logInfo.getScreenIndex() + 1 == logInfo.getScreenSize()) {
            Date now = new Date();
            String sql = "update t_fcs_riskbill_log set fexecres=?,fendtime=? where frisklogid=? and fexecnum=fsuccessnum and fbillid in (" + StringUtils.join(billIds, (String)",") + ")";
            this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.SUCCESS.getValue(), now, logInfo.getRiskLogId()));
            sql = "update t_fcs_riskbill_log set fexecres=?,fendtime=? where frisklogid=? and fexecnum=fsuccessnum+ffailnum and ffailnum>0 and fbillid in (" + StringUtils.join(billIds, (String)",") + ")";
            this.doOfferQueue(new RiskLogOp(OP_UPDATE, sql, RiskExecStatusEnum.FAILURE.getValue(), now, logInfo.getRiskLogId()));
        }
    }

    public RiskLogInfo getRiskLogInfo() {
        return riskLogInfoLocal.get();
    }

    public void setRiskLog(RiskLogInfo logInfo) {
        riskLogInfoLocal.set(logInfo);
    }

    public void removeRiskLog() {
        riskLogInfoLocal.remove();
    }

    private Integer genScreenBatchId(int partIndex) {
        RiskLogInfo logInfo = this.getRiskLogInfo();
        return logInfo.getScreenIndex() * logInfo.getBillCount() + partIndex + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String zipBillList(List<Long> billLogIds) {
        int size = billLogIds.size();
        byte[] bytes = new byte[size * 8];
        for (int i = 0; i < size; ++i) {
            System.arraycopy(Longs.toByteArray((long)billLogIds.get(i)), 0, bytes, 8 * i, 8);
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(bytes);
            }
            String string = Base64.getEncoder().encodeToString(out.toByteArray());
            return string;
        }
        catch (Exception e) {
            logger.error("zipBillList error:", (Throwable)e);
            return "";
        }
    }

    public static List<Long> unzipBillList(String billStr) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] bytes = Base64.getDecoder().decode(billStr);
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                 GZIPInputStream gin = new GZIPInputStream(in);){
                int n;
                byte[] buffer = new byte[256];
                while ((n = gin.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
            }
            bytes = out.toByteArray();
            int size = bytes.length;
            for (int i = 0; i < size; i += 8) {
                ids.add(Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, i, i + 8)));
            }
        }
        catch (Exception e) {
            logger.error("unzipBillList error:", (Throwable)e);
        }
        return ids;
    }

    static {
        THREAD_POOL = ThreadPools.newFixedThreadPool((String)"RiskLogHelper", (int)1, (String)TmcAppEnum.FCS.getValue());
        riskLogInfoLocal = new ThreadLocal();
    }
}

