/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.bizrule.fcs.IRiskSceneCullingService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.risk.RiskRpcResp;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RiskExecTypeEnum;
import kd.tmc.fcs.common.enums.RiskResultEnum;
import kd.tmc.fcs.common.enums.ScreenItemEnum;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.ErrorFieldMapHelper;
import kd.tmc.fcs.common.helper.RiskChangeServiceHelper;
import kd.tmc.fcs.common.helper.RiskLogHelper;
import kd.tmc.fcs.common.model.RiskLogInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RiskServiceHelper {
    private static final Log logger = LogFactory.getLog(RiskServiceHelper.class);
    private static final ThreadPool BATCH_POOL = ThreadPools.newFixedThreadPool((String)"RiskServiceHelper_Auto_BATCH", (int)8, (String)TmcAppEnum.FCS.getValue());
    private static final ThreadPool HANDLE_POOL = ThreadPools.newFixedThreadPool((String)"RiskServiceHelper_Handle_BATCH", (int)8, (String)TmcAppEnum.FCS.getValue());
    private static final ThreadPool ASYNC_POOL = ThreadPools.newFixedThreadPool((String)"RiskRpcService_ASYNC", (int)2, (String)TmcAppEnum.FCS.getValue());
    private static final int TRY_LOCK_TIME = 60000;
    private static final Map<String, ThreadPool> EXECUTOR_MAP = new HashMap<String, ThreadPool>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPool getThreadPool() {
        Map<String, ThreadPool> map = EXECUTOR_MAP;
        synchronized (map) {
            String tenantId = RequestContext.get().getTenantId();
            ThreadPool threadPool = EXECUTOR_MAP.get(tenantId);
            if (threadPool == null) {
                int size = 2;
                try {
                    DynamicObjectCollection col = QueryServiceHelper.query((String)"fcs_riskparam", (String)"number,paramvalue", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"RiskItemPoolSize")});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)col)) {
                        size = Integer.parseInt(((DynamicObject)col.get(0)).getString("paramvalue"));
                    }
                }
                catch (Exception e) {
                    logger.error("fcs_riskparam:RiskItemPoolSize->error value");
                }
                threadPool = ThreadPools.newFixedThreadPool((String)("RiskServiceHelper_" + tenantId), (int)size, (String)TmcAppEnum.FCS.getValue());
                EXECUTOR_MAP.put(tenantId, threadPool);
            }
            return threadPool;
        }
    }

    public static String getRiskServerPath() {
        DynamicObject defaultConfig = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_riskconfig", (String)"pyserver", (QFilter[])new QFilter("number", "=", (Object)"DEFAULT").toArray());
        String serverPath = defaultConfig.getString("pyserver");
        if (EmptyUtil.isBlank((CharSequence)serverPath)) {
            ErrorCode ec = new ErrorCode("pyserver", ResManager.loadKDString((String)"\u8bed\u4e49\u8bc6\u522b\u7684python\u670d\u52a1\u5668\u5730\u5740\u6ca1\u6709\u914d\u7f6e\u4e3a\u7a7a\u3002", (String)"RiskServiceHelper_0", (String)"tmc-fcs-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return serverPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, DynamicObject> invokeProposal(List<Long> billIdList, DynamicObject proposal, Boolean isHandle) {
        String billType = proposal.getDynamicObject("billentity").getString("number");
        logger.info("\u5f00\u59cb\u7b5b\u67e5\u5355\u636e\u3010{}\u3011\u6761\u6570\uff1a{}", (Object)billType, (Object)billIdList.size());
        Map<Long, DynamicObject> billMap = Collections.emptyMap();
        String execType = isHandle != false ? RiskExecTypeEnum.HANDLE.getValue() : RiskExecTypeEnum.AUTO.getValue();
        RiskLogHelper logHelper = RiskLogHelper.getInstance();
        Long riskLogId = logHelper.startRiskLog(proposal.getLong("id"), execType, billType, billIdList);
        RiskLogInfo logInfo = new RiskLogInfo();
        logInfo.setScreenId(proposal.getLong("id"));
        logInfo.setRiskLogId(riskLogId);
        logInfo.setBillType(billType);
        logInfo.setBillCount(billIdList.size());
        HashSet<Long> allBillIds = new HashSet<Long>(billIdList);
        try {
            Object conditionObj;
            logHelper.setRiskLog(logInfo);
            long startTime = System.currentTimeMillis();
            String startCondition = proposal.getString("condition_tag");
            if (EmptyUtil.isNotBlank((CharSequence)startCondition)) {
                ConditionFactory factory = new ConditionFactory();
                conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)startCondition, CRCondition.class);
                factory.init((CRCondition)conditionObj, billType);
                Set<Long> matchIds = factory.runCondition(new HashSet<Long>(billIdList));
                if (EmptyUtil.isEmpty(matchIds)) {
                    logger.info("\u7b5b\u67e5\u65b9\u6848\u3010{}\u3011\u65e0\u6570\u636e\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6", (Object)billType);
                    logHelper.noBillLog(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\u3002", (String)"RiskServiceHelper_1", (String)"tmc-fcs-common", (Object[])new Object[0]));
                    RiskServiceHelper.cleanOldErrorData(allBillIds, billType);
                    Map<Long, DynamicObject> map = billMap;
                    return map;
                }
                logHelper.filterBillLog(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\u3002", (String)"RiskServiceHelper_1", (String)"tmc-fcs-common", (Object[])new Object[0]), CollectionUtils.subtract(billIdList, matchIds));
                billIdList = new ArrayList<Long>(matchIds);
                logger.info("\u5355\u636e\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\u6570\u636e\u6761\u6570\uff1a{}", (Object)billIdList.size());
            }
            List<Long> filterBillIds = RiskServiceHelper.filterSpec(billIdList, billType);
            if (EmptyUtil.isEmpty(billIdList)) {
                logger.info("\u6240\u6709\u5355\u636e\u5df2\u7ecf\u6709\u4e13\u5bb6\u610f\u89c1");
                logHelper.noBillLog(ResManager.loadKDString((String)"\u6240\u6709\u5355\u636e\u5df2\u7ecf\u6709\u4e13\u5bb6\u610f\u89c1\u3002", (String)"RiskServiceHelper_2", (String)"tmc-fcs-common", (Object[])new Object[0]));
                RiskServiceHelper.cleanOldErrorData(allBillIds, billType);
                conditionObj = billMap;
                return conditionObj;
            }
            logHelper.filterBillLog(ResManager.loadKDString((String)"\u6240\u6709\u5355\u636e\u5df2\u7ecf\u6709\u4e13\u5bb6\u610f\u89c1\u3002", (String)"RiskServiceHelper_2", (String)"tmc-fcs-common", (Object[])new Object[0]), CollectionUtils.subtract(billIdList, filterBillIds));
            billIdList = filterBillIds;
            Pair<DynamicObject, Map<Long, DynamicObject>> pair = ErrorFieldMapHelper.genErrorData(billType, billIdList);
            billMap = RiskServiceHelper.filterFeatureCulling((DynamicObject)pair.getLeft(), (Map)pair.getRight());
            filterBillIds = RiskServiceHelper.getAllNonInnerBill(billMap.values());
            logHelper.filterBillLog(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002", (String)"RiskServiceHelper_3", (String)"tmc-fcs-common", (Object[])new Object[0]), CollectionUtils.subtract(billIdList, filterBillIds));
            if (EmptyUtil.isEmpty(filterBillIds)) {
                logger.info("\u6240\u6709\u5355\u636e\u90fd\u662f\u7ec4\u7ec7\u5185\u90e8\u5355\u636e");
            } else {
                RiskServiceHelper.execProposalEntry(proposal, filterBillIds, billMap, isHandle);
            }
            billMap = RiskServiceHelper.filterSceneCulling((DynamicObject)pair.getLeft(), billMap);
            RiskServiceHelper.syncBillErrorData(billMap, billType, allBillIds);
            logHelper.finishRiskLog();
            logger.info("\u7b5b\u67e5\u5b8c\u6210(ms):{}", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            logger.error("process proposal error:", (Throwable)e);
            logHelper.errorRiskLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        finally {
            logHelper.removeRiskLog();
        }
        return billMap;
    }

    private static void execProposalEntry(DynamicObject proposal, List<Long> nonInnerBill, Map<Long, DynamicObject> billMap, Boolean isHandle) throws Exception {
        DynamicObjectCollection propList = proposal.getDynamicObjectCollection("entry");
        List itemConfList = propList.stream().flatMap(t -> t.getDynamicObjectCollection("subentry").stream().map(w -> Tuple.create((Object)t.getString("typename"), (Object)w))).filter(t -> ((DynamicObject)t.item2).getBoolean("subenable")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(itemConfList)) {
            logger.info("\u6ca1\u6709\u542f\u7528\u7684\u7b5b\u67e5\u9879");
            return;
        }
        ArrayList<Tuple> futureList = new ArrayList<Tuple>(10);
        RequestContext rc = RequestContext.get();
        RiskLogInfo riskLogInfo = RiskLogHelper.getInstance().getRiskLogInfo();
        riskLogInfo.setScreenSize(itemConfList.size());
        for (int i = 0; i < itemConfList.size(); ++i) {
            Tuple tuple = (Tuple)itemConfList.get(i);
            riskLogInfo.setScreenIndex(i);
            RiskLogInfo riskLogInfo2 = riskLogInfo.clone();
            Future future = RiskServiceHelper.getThreadPool().submit(() -> RiskServiceHelper.itemRun(nonInnerBill, (DynamicObject)tuple.item2, isHandle, rc, clone), rc);
            futureList.add(Tuple.create((Object)tuple.item1, (Object)future));
        }
        HashMap<String, List> itemResultMap = new HashMap<String, List>(16);
        for (Tuple tuple : futureList) {
            List resultList = (List)((Future)tuple.item2).get();
            if (resultList.isEmpty()) continue;
            List res = itemResultMap.computeIfAbsent((String)tuple.item1, t -> new ArrayList(10));
            res.addAll(resultList);
        }
        for (Map.Entry entry : itemResultMap.entrySet()) {
            RiskServiceHelper.setTypeScreenResult(billMap, (String)entry.getKey(), (List)entry.getValue(), proposal.getLong("id"));
        }
    }

    private static List<Long> filterSpec(List<Long> billList, String billType) {
        QFilter[] filters = new QFilter[]{new QFilter("billid", "in", billList), new QFilter("datatype", "=", (Object)billType), new QFilter("result", "in", Arrays.asList(RiskResultEnum.NORMAL_TRADE.getValue(), RiskResultEnum.SHAM_TRADE.getValue()))};
        Set normIds = QueryServiceHelper.query((String)"fcs_errordata", (String)"billid", (QFilter[])filters).stream().map(t -> t.getLong("billid")).collect(Collectors.toSet());
        return billList.stream().filter(t -> !normIds.contains(t)).collect(Collectors.toList());
    }

    private static Map<Long, DynamicObject> filterFeatureCulling(DynamicObject errorFieldMap, Map<Long, DynamicObject> billMap) {
        DynamicObject featureCulling;
        boolean isBeforeCulling = errorFieldMap.getBoolean("beforeculling");
        if (isBeforeCulling && EmptyUtil.isNoEmpty((DynamicObject)(featureCulling = errorFieldMap.getDynamicObject("featureculling")))) {
            featureCulling = TmcDataServiceHelper.loadSingleFromCache((Object)featureCulling.getPkValue(), (String)"fcs_riskfeature_culling");
            logger.info("\u6267\u884c\u5f02\u5e38\u6570\u636e\u7279\u5f81\u5254\u9664\u914d\u7f6e:\u6267\u884c\u524d{}\u6761", (Object)billMap.size());
            long startTime = System.currentTimeMillis();
            DynamicObjectCollection entrys = featureCulling.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String destField = entry.getString("destfield");
                String feature = entry.getString("feature_tag");
                try {
                    Set featureSet = Arrays.stream(feature.split(";")).collect(Collectors.toSet());
                    Set cullings = billMap.values().stream().filter(s -> featureSet.stream().anyMatch(a -> s.getString(destField).contains((CharSequence)a))).map(o -> o.getLong("billid")).collect(Collectors.toSet());
                    for (Long culling : cullings) {
                        billMap.remove(culling);
                    }
                }
                catch (Exception e) {
                    logger.error("\u6267\u884c\u5f02\u5e38\u6570\u636e\u7279\u5f81\u5254\u9664\u914d\u7f6e\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
            logger.info("\u6267\u884c\u5f02\u5e38\u6570\u636e\u7279\u5f81\u5254\u9664\u914d\u7f6e:\u6267\u884c\u540e{}\u6761", (Object)billMap.size());
            logger.info("\u6267\u884c\u5f02\u5e38\u6570\u636e\u7279\u5f81\u5254\u9664\u914d\u7f6e:\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return billMap;
    }

    private static Map<Long, DynamicObject> filterSceneCulling(DynamicObject errorFieldMap, Map<Long, DynamicObject> billMap) {
        DynamicObjectCollection sceneCulling;
        boolean isBeforeCulling = errorFieldMap.getBoolean("beforeculling");
        if (isBeforeCulling && EmptyUtil.isNoEmpty((DynamicObjectCollection)(sceneCulling = errorFieldMap.getDynamicObjectCollection("sceneculling")))) {
            logger.info("\u6267\u884c\u5f02\u5e38\u6570\u636e\u573a\u666f\u5254\u9664\u914d\u7f6e:\u6267\u884c\u524d{}\u6761", (Object)billMap.size());
            long startTime = System.currentTimeMillis();
            List classNames = sceneCulling.stream().map(s -> s.getDynamicObject("fbasedataid").getString("classname")).collect(Collectors.toList());
            for (String className : classNames) {
                try {
                    IRiskSceneCullingService service = (IRiskSceneCullingService)Class.forName(className).newInstance();
                    billMap = service.execute(billMap);
                }
                catch (Exception e) {
                    logger.error("\u6267\u884c\u5f02\u5e38\u6570\u636e\u573a\u666f\u5254\u9664\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Object)className);
                }
            }
            logger.info("\u6267\u884c\u5f02\u5e38\u6570\u636e\u573a\u666f\u5254\u9664\u914d\u7f6e:\u6267\u884c\u540e{}\u6761", (Object)billMap.size());
            logger.info("\u6267\u884c\u5f02\u5e38\u6570\u636e\u573a\u666f\u5254\u9664\u914d\u7f6e:\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return billMap;
    }

    private static List<Long> getAllNonInnerBill(Collection<DynamicObject> errorDataList) {
        Set companyIds = errorDataList.stream().map(s -> s.getLong("company")).collect(Collectors.toSet());
        Map<Object, String> orgBills = TmcDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", companyIds).toArray()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, t -> ((DynamicObject)t.getValue()).getString("name")));
        return errorDataList.stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.get("company")) && EmptyUtil.isNoEmpty((String)((String)orgBills.get(t.get("company")))) && !((String)orgBills.get(t.get("company"))).equals(t.getString("counterparty"))).map(t -> t.getLong("billid")).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RiskItemResult> itemRun(List<Long> billNumList, DynamicObject itemConfig, Boolean isHandle, RequestContext rc, RiskLogInfo riskLogInfo) {
        List<RiskItemResult> itemResultList = new ArrayList<RiskItemResult>(10);
        String checkDiaName = ScreenItemEnum.getName(itemConfig.getString("screenitem"));
        long startTime = System.currentTimeMillis();
        try {
            String errorDesc = itemConfig.getString("errordesc");
            String controlModel = itemConfig.getString("controlmodel");
            String screenItem = itemConfig.getString("screenitem");
            riskLogInfo.setScreenItem(screenItem);
            RiskLogHelper.getInstance().setRiskLog(riskLogInfo);
            logger.info("[{}]->\u5f00\u59cb\u7b5b\u67e5\u3010{}\u3011\uff0c\u6570\u636e\u6761\u6570\u3010{}\u3011", new Object[]{rc.getTraceId(), checkDiaName, billNumList.size()});
            itemResultList = RiskServiceHelper.invokeItem(billNumList, itemConfig, isHandle, rc);
            itemResultList.forEach(t -> {
                t.setErrorDesc(errorDesc);
                t.setControlModel(controlModel);
                t.setScreenItem(screenItem);
            });
            logger.info("[{}]->\u7b5b\u67e5\u9879\u3010{}}\u3011\u5b8c\u6210\uff0c\u82b1\u8d39(ms)\uff1a{}", new Object[]{rc.getTraceId(), checkDiaName, System.currentTimeMillis() - startTime});
        }
        catch (Exception e) {
            logger.error("[{}]->\u7b5b\u67e5\u9879\u3010{}}\u3011\u5f02\u5e38\uff0c\u82b1\u8d39(ms)\uff1a{}", new Object[]{rc.getTraceId(), checkDiaName, System.currentTimeMillis() - startTime});
            logger.error((Throwable)e);
        }
        finally {
            RiskLogHelper.getInstance().removeRiskLog();
        }
        return itemResultList;
    }

    private static void setTypeScreenResult(Map<Long, DynamicObject> billMap, String typeName, List<RiskItemResult> typeResultList, Long proposalId) {
        Map<Long, List<RiskItemResult>> billResultMap = typeResultList.stream().collect(Collectors.groupingBy(RiskItemResult::getBillId));
        for (Map.Entry<Long, DynamicObject> entry : billMap.entrySet()) {
            Long billId = entry.getKey();
            List<RiskItemResult> resultList = billResultMap.get(billId);
            if (!EmptyUtil.isNoEmpty(resultList)) continue;
            boolean isSuspect = false;
            DynamicObject result = entry.getValue();
            DynamicObjectCollection typeList = result.getDynamicObjectCollection("entry");
            DynamicObject typeResult = typeList.addNew();
            typeResult.set("typename", (Object)typeName);
            result.set("riskscreening", (Object)proposalId);
            DynamicObjectCollection subItemList = typeResult.getDynamicObjectCollection("subentry");
            for (RiskItemResult res : resultList) {
                DynamicObject item = subItemList.addNew();
                item.set("errordesc", (Object)res.getErrorDesc());
                String detail = res.getErrorDescDetail();
                detail = null != detail && detail.length() > 2000 ? detail.substring(0, 1995) + "..." : detail;
                item.set("errordescdetail", (Object)detail);
                if (!isSuspect && EmptyUtil.isNotBlank((CharSequence)detail)) {
                    isSuspect = true;
                }
                item.set("controlmodel", (Object)res.getControlModel());
                item.set("screenitem", (Object)res.getScreenItem());
            }
            if (EmptyUtil.isBlank((CharSequence)result.getString("billno"))) {
                result.set("billno", (Object)resultList.get(0).getBillNo());
            }
            if (!isSuspect) continue;
            result.set("result", (Object)RiskResultEnum.SUSPECT_TRADE.getValue());
        }
    }

    private static void syncBillErrorData(Map<Long, DynamicObject> billMap, String billType, Set<Long> allBillIds) {
        DynamicObject[] suspectArr = (DynamicObject[])billMap.values().stream().filter(t -> RiskResultEnum.SUSPECT_TRADE.getValue().equals(t.getString("result"))).toArray(DynamicObject[]::new);
        try (DLock lock = DLock.create((String)("/tmc/fcs/errorData/" + billType)).fastMode();){
            if (lock.tryLock(60000L)) {
                RiskServiceHelper.cleanOldErrorData(allBillIds, billType);
                if (suspectArr.length > 0) {
                    TmcDataServiceHelper.save((DynamicObject[])suspectArr);
                }
                logger.info("\u5355\u636e\u3010{}\u3011\u6761\uff0c\u7591\u4f3c\u865a\u5047\u4ea4\u6613\u3010{}\u3011\u6761", (Object)billMap.size(), (Object)suspectArr.length);
            } else {
                logger.error("\u7b5b\u67e5\u5165\u5e93\u83b7\u53d6\u9501\u5931\u8d25");
            }
        }
    }

    private static void cleanOldErrorData(Set<Long> billIds, String billType) {
        DeleteServiceHelper.delete((String)"fcs_errordata", (QFilter[])new QFilter[]{new QFilter("billid", "in", billIds), new QFilter("datatype", "=", (Object)billType), new QFilter("result", "=", (Object)RiskResultEnum.SUSPECT_TRADE.getValue())});
    }

    private static List<RiskItemResult> invokeItem(List<Long> billNumList, DynamicObject itemConfig, Boolean isHandle, RequestContext rc) throws Exception {
        long detailId = itemConfig.getLong("screensetting");
        String screenItem = itemConfig.getString("screenitem");
        List<RiskItemResult> resultList = new ArrayList<RiskItemResult>(10);
        DynamicObject detailConfig = TmcDataServiceHelper.loadSingleFromCache((Object)detailId, (String)"fcs_riskdiagitem");
        if (EmptyUtil.isEmpty((DynamicObject)detailConfig)) {
            logger.warn("[{}]->\u7b5b\u67e5\u9879\u3010{}\u3011\u8be6\u60c5\u914d\u7f6e\u4e3a\u7a7a", (Object)rc.getTraceId(), (Object)ScreenItemEnum.getName(screenItem));
            return resultList;
        }
        resultList = ScreenItemEnum.TRADE_INTERCHANGE.getValue().equals(screenItem) ? RiskServiceHelper.invokeRiskDetailItemTotal(billNumList, detailConfig, isHandle, rc) : RiskServiceHelper.invokeRiskDetailItem(billNumList, detailConfig, isHandle, rc);
        return resultList;
    }

    private static List<RiskItemResult> invokeRiskDetailItem(List<Long> billNumList, DynamicObject detailConfig, Boolean isHandle, RequestContext rc) throws Exception {
        ArrayList<RiskItemResult> resultList = new ArrayList<RiskItemResult>(10);
        int BATCH_BILL = 100;
        if (10000 > billNumList.size() && billNumList.size() > 1000) {
            BATCH_BILL = 200;
        } else if (billNumList.size() > 10000) {
            BATCH_BILL = 2000;
        }
        List partition = Lists.partition(billNumList, (int)BATCH_BILL);
        ArrayList<Future> futureList = new ArrayList<Future>(10);
        int len = partition.size();
        for (int i = 0; i < len; ++i) {
            List partIds = (List)partition.get(i);
            RiskLogHelper logHelper = RiskLogHelper.getInstance();
            RiskLogInfo logInfo = logHelper.getRiskLogInfo();
            Long batchId = logHelper.startBatch(i, partIds);
            logInfo.setBatchId(batchId);
            RiskLogInfo clone = logInfo.clone();
            Future future = isHandle != false ? HANDLE_POOL.submit(() -> RiskServiceHelper.invokeCal(partIds, detailConfig, rc, clone), rc) : BATCH_POOL.submit(() -> RiskServiceHelper.invokeCal(partIds, detailConfig, rc, clone), rc);
            futureList.add(future);
        }
        for (Future future : futureList) {
            resultList.addAll((Collection)future.get());
        }
        return resultList;
    }

    private static List<RiskItemResult> invokeRiskDetailItemTotal(List<Long> billIdList, DynamicObject detailConfig, Boolean isHandle, RequestContext rc) throws Exception {
        ArrayList<RiskItemResult> resultList = new ArrayList<RiskItemResult>(10);
        Map<Object, List<DynamicObject>> amountGroup = RiskChangeServiceHelper.queryLeftData(billIdList, detailConfig);
        ArrayList<Future> futureList = new ArrayList<Future>(10);
        if (amountGroup != null) {
            ArrayList<Map.Entry<Object, List<DynamicObject>>> entryList = new ArrayList<Map.Entry<Object, List<DynamicObject>>>(amountGroup.entrySet());
            int batchBill = 50;
            if (10000 > amountGroup.size() && amountGroup.size() > 1000) {
                batchBill = 100;
            } else if (amountGroup.size() > 10000) {
                batchBill = 500;
            }
            List partition = Lists.partition(entryList, (int)batchBill);
            int len = partition.size();
            for (int i = 0; i < len; ++i) {
                List parts = (List)partition.get(i);
                ArrayList billList = new ArrayList(10);
                for (Map.Entry part : parts) {
                    billList.addAll((Collection)part.getValue());
                }
                List<Long> billNums = billList.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
                RiskLogHelper logHelper = RiskLogHelper.getInstance();
                RiskLogInfo logInfo = logHelper.getRiskLogInfo();
                Long batchId = logHelper.startBatch(i, billNums);
                logInfo.setBatchId(batchId);
                RiskLogInfo clone = logInfo.clone();
                Future future = isHandle != false ? HANDLE_POOL.submit(() -> RiskServiceHelper.invokeCalTotal(billList, detailConfig, rc, clone)) : BATCH_POOL.submit(() -> RiskServiceHelper.invokeCalTotal(billList, detailConfig, rc, clone));
                futureList.add(future);
            }
        }
        for (Future future : futureList) {
            resultList.addAll((Collection)future.get());
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RiskItemResult> invokeCalTotal(List<DynamicObject> billList, DynamicObject detailConfig, RequestContext rc, RiskLogInfo logInfo) {
        List<Object> results = new ArrayList<RiskItemResult>();
        RiskLogHelper logHelper = RiskLogHelper.getInstance();
        List<Long> billIdList = billList.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        String item = detailConfig.getString("screenitem");
        try {
            logHelper.setRiskLog(logInfo);
            logger.info("[{}]->riskServiceHelper->invoke-[{}]", (Object)rc.getTraceId(), (Object)item);
            RiskRpcResp rpcResp = (RiskRpcResp)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tgptas", (String)"RiskRpcService", (String)"invokeRpc", (Object[])new Object[]{billList, detailConfig});
            if ("success".equals(rpcResp.getCode())) {
                results = rpcResp.getResultList();
                logger.info("[{}]->riskServiceHelper->invoke-[{}]->success", (Object)rc.getTraceId(), (Object)item);
                logHelper.finishBatch(billIdList);
            } else {
                logger.info("[{}]->riskServiceHelper->invoke-[{}]->fail", (Object)rc.getTraceId(), (Object)item);
                logHelper.errorBatch(billIdList, rpcResp.getMessage());
            }
        }
        catch (Exception e) {
            logHelper.errorBatch(billIdList, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error("[{}]->riskServiceHelper->invoke-[{}]->error", (Object)rc.getTraceId(), (Object)item);
            logger.error((Throwable)e);
        }
        finally {
            logHelper.checkBillFinish(billIdList);
            logHelper.removeRiskLog();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RiskItemResult> invokeCal(List<Long> billIdList, DynamicObject detailConfig, RequestContext rc, RiskLogInfo logInfo) {
        List<Object> results = new ArrayList<RiskItemResult>();
        RiskLogHelper logHelper = RiskLogHelper.getInstance();
        String item = detailConfig.getString("screenitem");
        try {
            logHelper.setRiskLog(logInfo);
            logger.info("[{}]->riskServiceHelper->invoke-[{}]", (Object)rc.getTraceId(), (Object)item);
            RiskRpcResp rpcResp = (RiskRpcResp)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tgptas", (String)"RiskRpcService", (String)"invokeRpc", (Object[])new Object[]{billIdList, detailConfig});
            if ("success".equals(rpcResp.getCode())) {
                results = rpcResp.getResultList();
                logger.info("[{}]->riskServiceHelper->invoke-[{}]->success", (Object)rc.getTraceId(), (Object)item);
                logHelper.finishBatch(billIdList);
            } else {
                logger.info("[{}]->riskServiceHelper->invoke-[{}]->fail", (Object)rc.getTraceId(), (Object)item);
                logHelper.errorBatch(billIdList, rpcResp.getMessage());
            }
        }
        catch (Exception e) {
            logHelper.errorBatch(billIdList, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error("[{}]->riskServiceHelper->invoke-[{}]->error", (Object)rc.getTraceId(), (Object)item);
            logger.error((Throwable)e);
        }
        finally {
            logHelper.checkBillFinish(billIdList);
            logHelper.removeRiskLog();
        }
        return results;
    }

    public static List<DynamicObject> filterOppUnits(List<DynamicObject> datas, String accountField) {
        Set oppUnits = datas.stream().map(s -> s.getString(accountField)).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(oppUnits)) {
            return datas;
        }
        QFilter accountFilter = new QFilter("bankaccountnumber", "in", oppUnits);
        Set<String> collect = RiskServiceHelper.getAccountNumberByFilter(accountFilter.toArray());
        return datas.stream().filter(s -> !collect.contains(s.getString(accountField))).collect(Collectors.toList());
    }

    public static void asyncExecProposal(String scheduleCycle, String scheduleDateRange, Long proposalId) {
        logger.info("asyncExecTask {} scheduleCycle {} scheduleDateRange {}", new Object[]{proposalId, scheduleCycle, scheduleDateRange});
        ASYNC_POOL.execute(() -> RiskServiceHelper.execProposal(scheduleCycle, scheduleDateRange, proposalId), RequestContext.get());
    }

    private static void execProposal(String scheduleCycle, String scheduleDateRange, Long proposalId) {
        DynamicObjectCollection entrys;
        String bizTimeField;
        Date endDate;
        Date startDate;
        if (EmptyUtil.isNoEmpty((String)scheduleDateRange)) {
            String[] dateRange = scheduleDateRange.split("-");
            startDate = DateUtils.stringToDate((String)dateRange[0], (String)"yyyyMMdd");
            endDate = DateUtils.stringToDate((String)dateRange[1], (String)"yyyyMMdd");
        } else {
            startDate = DateUtils.getCurrentDate();
            endDate = DateUtils.getCurrentDate();
            if (StringUtils.isNotEmpty((CharSequence)scheduleCycle)) {
                startDate = DateUtils.getLastDay((Date)startDate, (int)Integer.parseInt(scheduleCycle));
            }
        }
        DynamicObject proposal = TmcDataServiceHelper.loadSingleFromCache((Object)proposalId, (String)"fcs_riskscreening");
        String billEntity = proposal.getDynamicObject("billentity").getString("number");
        DynamicObject errorFieldMap = ErrorFieldMapHelper.getErrorFieldMapBySrcEntity(billEntity);
        if (EmptyUtil.isNoEmpty((DynamicObject)errorFieldMap) && (bizTimeField = ErrorFieldMapHelper.querySrcFieldPropByDestField(entrys = errorFieldMap.getDynamicObjectCollection("entry"), "biztime")) != null) {
            QFilter qFilter = new QFilter(bizTimeField, ">=", (Object)startDate);
            qFilter.and(bizTimeField, "<=", (Object)endDate);
            logger.info("\u7b5b\u67e5\u8c03\u5ea6\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)qFilter);
            List query = QueryServiceHelper.queryPrimaryKeys((String)billEntity, (QFilter[])qFilter.toArray(), null, (int)-1);
            logger.info("\u83b7\u53d6\u7684\u4e1a\u52a1\u5355\u636e\u662f\u5426\u4e3a\u7a7a\uff1a{}", (Object)EmptyUtil.isEmpty((Collection)query));
            if (EmptyUtil.isNoEmpty((Object)query)) {
                List<Long> billIds = query.stream().map(t -> (Long)t).collect(Collectors.toList());
                logger.info("\u7b5b\u67e5\u8c03\u5ea6\u67e5\u8be2\u6570\u636e\u91cf\u3010{}\u3011", (Object)billIds.size());
                try {
                    RiskServiceHelper.invokeProposal(billIds, proposal, false);
                }
                catch (Exception e) {
                    logger.error("\u8c03\u5ea6\u6267\u884c\u98ce\u9669\u7b5b\u67e5\u6a21\u578b\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static Set<String> getAccountNumberByFilter(QFilter[] filters) {
        HashSet<String> bankNumSet = new HashSet<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getAccountNumberByFilter", (String)"bd_accountbanks", (String)"bankaccountnumber", (QFilter[])filters, null);){
            for (Row row : dataSet) {
                String bankNum = row.getString("bankaccountnumber");
                if (EmptyUtil.isEmpty((String)bankNum) || bankNum.equals(" ")) continue;
                bankNumSet.add(bankNum);
            }
        }
        return bankNumSet;
    }

    public static void showRealProgressTask(IFormView view, FormShowParameter sp, Map<String, Object> params, String showWay, String taskId) {
        sp.setFormId("fcs_real_progresstask");
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.setHasRight(true);
        sp.getCustomParams().put("taskId", taskId);
        sp.getCustomParams().put("showWay", showWay);
        sp.getCustomParams().put("orgInfo", params.get("orgInfo"));
        sp.getCustomParams().put("startdate", params.get("startdate"));
        sp.getCustomParams().put("enddate", params.get("enddate"));
        sp.getCustomParams().put("datatype", params.get("datatype"));
        sp.getCustomParams().put("startTime", params.get("startTime"));
        view.showForm(sp);
    }
}

