/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.FormDesignDao;
import kd.tmc.fcs.common.model.DynamicParamBean;
import kd.tmc.fcs.common.model.ParamEntryBean;

public class ScheduleBussinessOperateHelper {
    public static void setBussinessComboItems(String appId, IFormView view) {
        Set<String> dataSet = new HashSet<String>(16);
        HashSet<String> checkEntity = new HashSet<String>(16);
        ArrayList<String> bizAppIds = new ArrayList<String>(10);
        bizAppIds.add(appId);
        DynamicObjectCollection extBizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)appId)});
        for (DynamicObject extBizApp : extBizApps) {
            bizAppIds.add(extBizApp.getString("id"));
        }
        String s = ScheduleBussinessOperateHelper.getQuerySQL(bizAppIds.size());
        String sql = "SELECT DISTINCT e.fnumber number FROM t_meta_entity e LEFT JOIN t_meta_bizunitrelform b ON e.fid = b.FFORMID WHERE b.FBIZAPPID in " + s;
        try (DataSet operateDataset = DB.queryDataSet((String)"queryForOperate", (DBRoute)DBRoute.meta, (String)sql, (Object[])bizAppIds.toArray());){
            Iterator iterator = operateDataset.iterator();
            while (iterator.hasNext()) {
                Row rh = (Row)iterator.next();
                String number = rh.getString("number");
                checkEntity.add(number);
            }
        }
        if (!checkEntity.isEmpty()) {
            for (String number : checkEntity) {
                List ops = EntityMetadataCache.getDataEntityOperate((String)number);
                if (!ScheduleBussinessOperateHelper.isContainSchedule(ops)) continue;
                dataSet.add(number);
            }
        }
        String viewOfAppId = view.getFormShowParameter().getAppId();
        if (TmcAppEnum.BEI.getValue().equals(viewOfAppId) && EmptyUtil.isNoEmpty(dataSet)) {
            Map configs = TmcDataServiceHelper.loadFromCache((String)"fcs_schedulefilterconf", (String)"entitynumber", (QFilter[])new QFilter[]{new QFilter("bizapp", "=", (Object)appId)});
            ArrayList entitynumbers = new ArrayList(10);
            for (DynamicObject config : configs.values()) {
                entitynumbers.addAll(Arrays.stream(config.getString("entitynumber").split(",")).collect(Collectors.toList()));
            }
            dataSet = dataSet.stream().filter(entitynumbers::contains).collect(Collectors.toSet());
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(dataSet.size());
        for (String business : dataSet) {
            ComboItem comboItem = new ComboItem();
            LocaleString name = new LocaleString(FormDesignDao.getDesignFormName(business));
            comboItem.setValue(business);
            comboItem.setCaption(name);
            list.add(comboItem);
        }
        ComboEdit combo = (ComboEdit)view.getControl("bussiness");
        combo.setComboItems(list);
    }

    private static boolean isContainSchedule(List<Map<String, Object>> ops) {
        return ops.stream().map(t -> t.get("opbiz")).filter(Objects::nonNull).flatMap(t -> ((List)t).stream()).anyMatch(t -> t.contains("TmcScheduleTaskExecute"));
    }

    public static void setOperateComboItems(String formId, IFormView view) {
        String os;
        String sql = "SELECT DISTINCT e.fnumber number, e.fkey oper FROM t_meta_entity e LEFT JOIN t_meta_bizunitrelform b ON e.fid = b.FFORMID left join t_meta_formdesign c on c.fentityid = e.fid WHERE c.fnumber = ?";
        Object[] dataResult = (Object[])DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new String[]{formId}, rh -> {
            Object[] result = new Object[2];
            String realFormId = null;
            HashSet<String> dataList = new HashSet<String>(16);
            while (rh.next()) {
                if (realFormId == null) {
                    realFormId = rh.getString("number");
                }
                List ops = EntityMetadataCache.getDataEntityOperate(realFormId);
                block1: for (Map each : ops) {
                    Object opts = each.get("opbiz");
                    if (opts == null) continue;
                    List oos = (List)opts;
                    for (String eac : oos) {
                        if (!eac.contains("TmcScheduleTaskExecute")) continue;
                        dataList.add(each.get("key").toString());
                        continue block1;
                    }
                }
            }
            result[0] = realFormId;
            result[1] = dataList;
            return result;
        });
        Object tempEntity = dataResult[0];
        if (tempEntity != null && StringUtils.isNotEmpty((String)(os = tempEntity.toString()))) {
            formId = os;
        }
        Set dataSet = (Set)dataResult[1];
        Map<String, String> operMap = FormDesignDao.getFormOperMap(formId);
        String viewOfAppId = view.getFormShowParameter().getAppId();
        if ((TmcAppEnum.BEI.getValue().equals(viewOfAppId) || "cbei".equals(viewOfAppId)) && EmptyUtil.isNoEmpty((Object)dataSet)) {
            Map configs = TmcDataServiceHelper.loadFromCache((String)"fcs_schedulefilterconf", (String)"entitynumber,opkey", (QFilter[])new QFilter[0]);
            for (DynamicObject config : configs.values()) {
                List entitynumbers = Arrays.stream(config.getString("entitynumber").split(",")).collect(Collectors.toList());
                if (!entitynumbers.contains(formId)) continue;
                String opkeyStr = config.getString("opkey");
                if (!EmptyUtil.isNoEmpty((String)opkeyStr)) break;
                List opkey = Arrays.stream(opkeyStr.split(",")).collect(Collectors.toList());
                dataSet = dataSet.stream().filter(opkey::contains).collect(Collectors.toSet());
                break;
            }
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(dataSet.size());
        for (String operKey : dataSet) {
            if (operKey.isEmpty()) continue;
            String nameStr = operMap.get(operKey);
            if (StringUtils.isEmpty((String)nameStr)) {
                nameStr = operKey;
            }
            LocaleString name = new LocaleString(nameStr);
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(operKey);
            comboItem.setCaption(name);
            list.add(comboItem);
        }
        ComboEdit combo = (ComboEdit)view.getControl("operatekey");
        combo.setComboItems(list);
    }

    public static List<DynamicParamBean> getParamList(QFilter[] qf) {
        String selectors = "bizapp,bussiness,operatekey,attention,classname,entryentity.id,entryentity.param,entryentity.paramname,entryentity.comboval,entryentity.require,entryentity.paramval,entryentity.paramdesc,entryentity.paramtype";
        DynamicObject[] paramCol = BusinessDataServiceHelper.load((String)"fcs_schedule_param", (String)selectors, (QFilter[])qf);
        ArrayList<DynamicParamBean> list = new ArrayList<DynamicParamBean>(paramCol.length);
        for (DynamicObject paramObj : paramCol) {
            DynamicParamBean model = new DynamicParamBean();
            DynamicObject app = paramObj.getDynamicObject("bizapp");
            model.setAppId(app == null ? "" : app.getPkValue().toString());
            model.setBusiness(paramObj.getString("bussiness"));
            model.setOper(paramObj.getString("operatekey"));
            model.setAttention(paramObj.getString("attention"));
            DynamicObject classname = paramObj.getDynamicObject("classname");
            if (EmptyUtil.isNoEmpty((DynamicObject)classname)) {
                model.setClassname(classname.getPkValue().toString());
            }
            DynamicObjectCollection entrys = paramObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                ParamEntryBean paramEntry = new ParamEntryBean();
                paramEntry.setId(entry.getString("id"));
                paramEntry.setNumber(entry.getString("param"));
                paramEntry.setName(entry.getString("paramname"));
                paramEntry.setRequire(entry.getBoolean("require"));
                paramEntry.setParamval(entry.getString("paramval"));
                paramEntry.setParamdesc(entry.getString("paramdesc"));
                paramEntry.setParamtype(entry.getString("paramtype"));
                paramEntry.setComboVal(entry.getString("comboval"));
                model.addParams(paramEntry);
            }
            list.add(model);
        }
        return list;
    }

    private static List<ConvertPath> loadAllConvertPaths(List<String> appIds) {
        String localeId = Lang.get().toString();
        String sBuilder = "SELECT t0.FSourceEntityNumber, t1_l.FName AS FSourceEntityName       ,t0.FTargetEntityNumber, t2_l.FName AS FTargetEntityName       ,t0.FBizAppId       ,t1.FBizAppId AS FSourceBizAppId, t2.FBizAppId AS FTargetBizAppId FROM T_BOTP_ConvertRule t0 LEFT JOIN T_META_EntityDesign t1 ON (t0.FSourceEntityNumber = t1.FNumber) LEFT JOIN T_META_EntityDesign t2 ON (t0.FTargetEntityNumber = t2.FNumber) LEFT JOIN T_META_EntityDesign_L t1_l ON (t0.FSourceEntityNumber = t1_l.FNumber and t1_l.FLocaleId = '" + localeId + "') LEFT JOIN T_META_EntityDesign_L t2_l ON (t0.FTargetEntityNumber = t2_l.FNumber and t2_l.FLocaleId = '" + localeId + "') WHERE t0.FType <> '2' AND t1.FBizAppId in (" + ScheduleBussinessOperateHelper.toSQLString(appIds) + ")";
        ResultSetHandler action = rs -> {
            HashSet<ConvertPath> paths = new HashSet<ConvertPath>(rs.getRow());
            while (rs.next()) {
                ConvertPath path = new ConvertPath();
                path.setSourceEntityNumber(rs.getString("FSourceEntityNumber"));
                path.setSourceEntityName(rs.getString("FSourceEntityName"));
                path.setTargetEntityNumber(rs.getString("FTargetEntityNumber"));
                path.setTargetEntityName(rs.getString("FTargetEntityName"));
                path.setBizAppId(rs.getString("FBizAppId"));
                path.setSourceBizAppId(rs.getString("FSourceBizAppId"));
                path.setTargetBizAppId(rs.getString("FTargetBizAppId"));
                paths.add(path);
            }
            return paths;
        };
        Set convertPaths = (Set)DB.query((DBRoute)DBRoute.meta, (String)sBuilder, null, (ResultSetHandler)action);
        return new ArrayList<ConvertPath>(convertPaths);
    }

    private static String toSQLString(List<String> param) {
        StringBuilder sb = new StringBuilder();
        if (param == null || param.size() == 0) {
            return "";
        }
        for (String val : param) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(val).append("'");
        }
        return sb.toString();
    }

    private static String getQuerySQL(int size) {
        StringBuilder sb = new StringBuilder();
        sb.append("(?");
        for (int i = 0; i < size - 1; ++i) {
            sb.append(",?");
        }
        return sb.append(")").toString();
    }

    public static Map<String, JSONObject> getParamComBoxMap(DynamicParamBean bean) {
        return Optional.ofNullable(bean.getParams()).orElseGet(Collections::emptyList).stream().filter(t -> Objects.nonNull(t.getComboVal())).collect(Collectors.toMap(ParamEntryBean::getNumber, ParamEntryBean::getComboVal, (p, q) -> p));
    }

    public static Map<String, Set<String>> checkExistIntellExecSchema(DataSet tmcScheduleDataSet, Set<String> entityNumbers, Set<String> opKeys) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        QFilter intellExecSchemaQFilter = new QFilter("enable", "=", (Object)"1").and("operationentry.bussiness", "in", entityNumbers).and("operationentry.oper", "in", opKeys);
        DataSet intellExecSchemaDataSet = QueryServiceHelper.queryDataSet((String)"checkExistIntellExecSchema_gl_intellexecschema", (String)"gl_intellexecschema", (String)"number fi_number,sheduleplanid,operationentry.bussiness fi_entitynumber,operationentry.oper fi_opkey", (QFilter[])new QFilter[]{intellExecSchemaQFilter}, null);
        DataSet dataSet1 = intellExecSchemaDataSet.leftJoin(tmcScheduleDataSet).on("fi_entitynumber", "tmc_entitynumber").on("fi_opkey", "tmc_opkey").select(new String[]{"tmc_number", "fi_number", "sheduleplanid", "fi_entitynumber", "tmc_entitynumber", "fi_opkey", "tmc_opkey"}).finish().filter("tmc_number is not null");
        if (dataSet1.copy().count("tmc_number", true) == 0) {
            return result;
        }
        ArrayList<Object> shedulePlanIds = new ArrayList<Object>(10);
        for (Row row : dataSet1.copy()) {
            shedulePlanIds.add(row.get("sheduleplanid"));
        }
        QFilter schedulePlanQFilter = new QFilter("id", "in", shedulePlanIds).and("endtime", ">", (Object)new Date()).and("repeatmode", "!=", (Object)"n");
        DataSet schedulePlanDataSet = QueryServiceHelper.queryDataSet((String)"checkExistIntellExecSchema_sch_schedule", (String)"sch_schedule", (String)"id,endtime,repeatmode", (QFilter[])new QFilter[]{schedulePlanQFilter}, null);
        DataSet dataSet2 = dataSet1.leftJoin(schedulePlanDataSet).on("sheduleplanid", "id").select(new String[]{"tmc_number", "fi_number", "sheduleplanid", "id", "endtime", "repeatmode"}).finish().filter("id is not null").orderBy(new String[]{"tmc_number"});
        for (Row row : dataSet2.copy()) {
            String tmc_Number = row.getString("tmc_number");
            if (result.containsKey(tmc_Number)) {
                ((Set)result.get(tmc_Number)).add(row.getString("fi_number"));
                continue;
            }
            result.put(tmc_Number, new HashSet(16));
            ((Set)result.get(tmc_Number)).add(row.getString("fi_number"));
        }
        return result;
    }

    public static String getWarningMessage(Set<String> numbers) {
        return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6709\u6548\u7684\u76f8\u540c\u201c\u4e1a\u52a1\u64cd\u4f5c\u201d\u7684\u201c\u667a\u80fd\u6267\u884c\u65b9\u6848\u201d\uff08\u673a\u5668\u4eba\u7f16\u7801\uff1a%s\uff09\uff0c\u4e3a\u907f\u514d\u540e\u53f0\u8c03\u5ea6\u6267\u884c\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u6761\u4ef6\u8bbe\u7f6e\u662f\u5426\u76f8\u540c\uff0c\u907f\u514d\u91cd\u590d\u914d\u7f6e\u3002", (String)"ScheduleBussinessOperateHelper_0", (String)"tmc-fcs-common", (Object[])new Object[]{String.join((CharSequence)",", numbers)});
    }

    public static QFilter getQFilterByFilterConfig() {
        Map configs = TmcDataServiceHelper.loadFromCache((String)"fcs_schedulefilterconf", (String)"entitynumber,opkey", (QFilter[])new QFilter[0]);
        QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        for (Map.Entry entry : configs.entrySet()) {
            DynamicObject config = (DynamicObject)entry.getValue();
            List entitynumbers = Arrays.stream(config.getString("entitynumber").split(",")).collect(Collectors.toList());
            QFilter qFilter1 = new QFilter("tasktype", "=", (Object)"operation");
            qFilter1.and("bussiness", "in", entitynumbers);
            String opkey = config.getString("opkey");
            if (EmptyUtil.isNoEmpty((String)opkey)) {
                qFilter1.and("taskentry.operatekey", "in", Arrays.stream(opkey.split(",")).collect(Collectors.toList()));
            }
            qFilter.or(qFilter1);
        }
        qFilter.or(new QFilter("tasktype", "=", (Object)"job").and("taskentry.schejob.appid", "=", (Object)TmcAppEnum.BEI.getValue()));
        return qFilter;
    }
}

