/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.SnapSchemeHelper;
import kd.tmc.fcs.common.model.ExportHeadMapper;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SnapExportExecutor {
    private static final Log logger = LogFactory.getLog(SnapExportExecutor.class);
    private static final int DEFAULT_FONT_HEIGHT = 11;
    private Map<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(8);
    private Map<String, DynamicObject> currencyCache = new HashMap<String, DynamicObject>(8);
    private Map<String, DynamicObject> baseDataCache = new HashMap<String, DynamicObject>(8);
    private XSSFWorkbook workbook;
    private DynamicObject exportScheme;
    private String snapType;
    private Date snapDate;

    public SnapExportExecutor(DynamicObject exportScheme, String snapType, Date snapDate) {
        this.exportScheme = exportScheme;
        this.snapType = snapType;
        this.snapDate = snapDate;
    }

    public String snapExport() {
        String exportName = this.exportScheme.getString("name");
        DynamicObjectCollection snapSchemeEntry = this.exportScheme.getDynamicObjectCollection("snapscheme_entry");
        return this.doExport(exportName, snapSchemeEntry);
    }

    private String doExport(String exportName, DynamicObjectCollection snapSchemeEntry) {
        logger.info(exportName + " \u5bfc\u51fa\u5f00\u59cb....");
        this.workbook = new XSSFWorkbook();
        int emptySize = 0;
        int disableSize = 0;
        int errorSize = 0;
        int sheetIndex = 0;
        StringBuilder errorMsg = new StringBuilder(10);
        for (DynamicObject entry : snapSchemeEntry) {
            Long snapSchemeId = (Long)entry.getDynamicObject("snapscheme").getPkValue();
            String isEnable = entry.getString("schemestatus");
            String sheetName = entry.getString("exportname");
            logger.info("exportName : " + exportName + " sheetName: " + sheetName + "\u5f00\u59cb\u5bfc\u51fa...");
            if (!BaseEnableEnum.ENABLE.getValue().equals(isEnable)) {
                ++disableSize;
                String description = String.format(ResManager.loadKDString((String)"\u5feb\u7167\u65b9\u6848\u5df2\u7981\u7528\u3002", (String)"SnapExportExecutor_3", (String)"tmc-fcs-common", (Object[])new Object[0]), DateUtils.formatString((Date)this.snapDate, (String)"yyyy-MM-dd"));
                this.addEmptySheet(sheetName, description, sheetIndex);
                continue;
            }
            try {
                DataSet reportDs = SnapSchemeHelper.getDataBySnapScheme(snapSchemeId, this.snapType, this.snapDate);
                if (null == reportDs) {
                    ++emptySize;
                    String description = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%s\u7684\u6570\u636e\u5feb\u7167\u3002", (String)"SnapExportExecutor_0", (String)"tmc-fcs-common", (Object[])new Object[0]), DateUtils.formatString((Date)this.snapDate, (String)"yyyy-MM-dd"));
                    this.addEmptySheet(sheetName, description, sheetIndex);
                } else {
                    String formId = entry.getDynamicObject("reportform").getString("number");
                    this.addSheet(reportDs, sheetName, formId, this.snapDate);
                }
            }
            catch (Exception e) {
                logger.error("exportName : " + exportName + " sheetName: " + sheetName + " \u83b7\u53d6\u62a5\u8868\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
                ++errorSize;
                this.addEmptySheet(sheetName, e.getMessage(), sheetIndex);
                errorMsg.append(sheetName).append(": ").append(e.getMessage()).append("\n");
            }
            ++sheetIndex;
            logger.info("exportName : " + exportName + " sheetName: " + sheetName + "\u7ed3\u675f\u5bfc\u51fa...");
        }
        if (errorSize == snapSchemeEntry.size()) {
            throw new KDBizException(errorMsg.toString());
        }
        if (disableSize == snapSchemeEntry.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u5f53\u524d\u5bfc\u51fa\u65b9\u6848\u7684\u6240\u6709\u5feb\u7167\u65b9\u6848\u90fd\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u751f\u6210\u6570\u636e\u5feb\u7167\u3002", (String)"SnapExportExecutor_4", (String)"tmc-fcs-common", (Object[])new Object[0]));
        }
        if (emptySize == snapSchemeEntry.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u5f53\u524d\u5bfc\u51fa\u65b9\u6848\u5728\u6307\u5b9a\u5feb\u7167\u65e5\u671f\u672a\u627e\u5230\u4efb\u4f55\u6570\u636e\u5feb\u7167\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u5feb\u7167\u65b9\u6848\u548c\u540e\u53f0\u8c03\u5ea6\u3002", (String)"SnapExportExecutor_2", (String)"tmc-fcs-common", (Object[])new Object[0]));
        }
        logger.info(exportName + " \u5bfc\u51fa\u7ed3\u675f....");
        return this.upload(exportName);
    }

    private void addEmptySheet(String sheetName, String description, int sheetIndex) {
        XSSFSheet sheet = this.workbook.getSheet(sheetName);
        if (null != sheet) {
            this.workbook.removeSheetAt(sheetIndex);
        }
        sheet = this.workbook.createSheet(sheetName);
        XSSFRow headRow = sheet.createRow(0);
        XSSFCell cell = headRow.createCell(0);
        cell.setCellValue(description);
        cell.setCellStyle(this.getHeadStyle(IndexedColors.RED.getIndex(), HorizontalAlignment.LEFT));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 4));
    }

    private void addSheet(DataSet reportDs, String sheetName, String formId, Date snapDate) {
        XSSFSheet sheet = this.workbook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(20);
        DynamicObject dataSnap = SnapDataHelper.getDataSnap((String)formId, null, null, (Date)snapDate);
        List<ExportHeadMapper> headers = SnapSchemeHelper.getHeaders(formId, dataSnap);
        Map<String, ExportHeadMapper> headersMap = this.transListMapperToMap(headers);
        this.addSnapDateRow(sheet, EmptyUtil.isNoEmpty((DynamicObject)dataSnap) ? dataSnap.getDate("createtime") : snapDate, headersMap.size());
        int rowIndex = this.createHeadRow(sheet, headers, this.getHeadStyle(IndexedColors.BLACK.getIndex(), HorizontalAlignment.CENTER));
        this.createBody(sheet, reportDs, headers, this.getBodyStyle(), rowIndex);
    }

    private void addSnapDateRow(XSSFSheet sheet, Date snapDate, int colSize) {
        XSSFRow headRow = sheet.createRow(0);
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String snapDataStr = ResManager.loadKDString((String)"\u5feb\u7167\u65e5\u671f\uff1a", (String)"SnapExportExecutor_5", (String)"tmc-fcs-common", (Object[])new Object[0]);
        for (int i = 0; i < colSize; ++i) {
            XSSFCell cell = headRow.createCell(i);
            cell.setCellValue(snapDataStr + formater.format(snapDate));
            cell.setCellStyle(this.getHeadStyle(IndexedColors.RED.getIndex(), HorizontalAlignment.LEFT));
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colSize - 1));
    }

    private int createHeadRow(XSSFSheet sheet, List<ExportHeadMapper> headers, CellStyle headStyle) {
        int cellNum = 0;
        int rowIndex = 1;
        XSSFRow headRow = sheet.createRow(rowIndex);
        for (ExportHeadMapper mapper : headers) {
            XSSFCell headCell = headRow.createCell(cellNum);
            headCell.setCellValue(mapper.getName());
            headCell.setCellStyle(headStyle);
            if (mapper.hasSubItem()) {
                List<ExportHeadMapper> subItems = mapper.getSubItems();
                sheet.addMergedRegion(new CellRangeAddress(1, 1, cellNum, cellNum + subItems.size() - 1));
                rowIndex = 2;
                XSSFRow subRow = sheet.getRow(rowIndex);
                if (null == subRow) {
                    subRow = sheet.createRow(rowIndex);
                }
                for (ExportHeadMapper subMapper : subItems) {
                    XSSFCell subCell = subRow.createCell(cellNum);
                    subCell.setCellValue(subMapper.getName());
                    subCell.setCellStyle(headStyle);
                    ++cellNum;
                }
                --cellNum;
            }
            ++cellNum;
        }
        return rowIndex;
    }

    private void createBody(XSSFSheet sheet, DataSet reportDs, List<ExportHeadMapper> mappers, CellStyle bodyStyle, int rowIndex) {
        Iterator iterator = reportDs.iterator();
        int rowNum = rowIndex;
        Map<String, ExportHeadMapper> headers = this.transListMapperToMap(mappers);
        while (iterator.hasNext()) {
            Row reportRow = (Row)iterator.next();
            XSSFRow row = sheet.createRow(rowNum + 1);
            int cellNum = 0;
            for (Map.Entry<String, ExportHeadMapper> entry : headers.entrySet()) {
                Object value;
                String field = entry.getKey();
                XSSFCell cell = row.createCell(cellNum);
                try {
                    value = reportRow.get(field);
                }
                catch (AlgoException e) {
                    logger.error("\u8bbe\u7f6eExcel\u5355\u5143\u683c\u503c\u9519\u8bef, field: " + field + "\u627e\u4e0d\u5230,", (Object)e.getMessage());
                    value = null;
                }
                ExportHeadMapper mapper = entry.getValue();
                int precision = this.getAmountPrecision(mapper, reportRow);
                this.setCellValue(cell, value, mapper, precision);
                String fieldType = mapper.getFieldType();
                this.setCellStyle(cell, fieldType, bodyStyle, precision);
                ++cellNum;
            }
            ++rowNum;
        }
        reportDs.close();
    }

    private int getAmountPrecision(ExportHeadMapper mapper, Row reportRow) {
        int precision = 2;
        if ("amount".equals(mapper.getFieldType())) {
            try {
                String currencyField = mapper.getCurrencyField();
                Object currencyId = reportRow.get(currencyField);
                DynamicObject currency = this.getCurrency(currencyId);
                precision = (Integer)currency.get("amtprecision");
            }
            catch (Exception e) {
                logger.error(" \u83b7\u53d6\u5e01\u522b\u91d1\u989d\u7cbe\u5ea6\u9519\u8bef\uff0c", (Throwable)e);
            }
        }
        return precision;
    }

    private void setCellStyle(XSSFCell cell, String fieldType, CellStyle bodyStyle, int precision) {
        CellStyle cellStyle = bodyStyle;
        if ("amount".equals(fieldType)) {
            cellStyle = this.getAmountStyle(precision);
        } else if ("integer".equals(fieldType)) {
            cellStyle = this.getIntStyle();
        }
        cell.setCellStyle(cellStyle);
    }

    private Map<String, ExportHeadMapper> transListMapperToMap(List<ExportHeadMapper> mappers) {
        ListOrderedMap headMap = new ListOrderedMap();
        for (ExportHeadMapper mapper : mappers) {
            headMap.put(mapper.getKey(), mapper);
            if (!mapper.hasSubItem()) continue;
            headMap.remove(mapper.getKey());
            for (ExportHeadMapper subMapper : mapper.getSubItems()) {
                headMap.put(subMapper.getKey(), subMapper);
            }
        }
        return headMap;
    }

    private void setCellValue(XSSFCell cell, Object value, ExportHeadMapper mapper, int precision) {
        if (EmptyUtil.isEmpty((Object)value)) {
            cell.setCellValue("");
        } else {
            String fieldType = mapper.getFieldType();
            if ("currency".equals(fieldType)) {
                DynamicObject currencyDO = this.getCurrency(value);
                cell.setCellValue(currencyDO.getString("name"));
            } else if ("basedata".equals(fieldType) || "user".equals(fieldType)) {
                String baseDataEntity = mapper.getBaseDataEntity();
                cell.setCellValue(EmptyUtil.isEmpty((DynamicObject)this.getBaseData(baseDataEntity, value)) ? "" : this.getBaseData(baseDataEntity, value).getString("name"));
            } else if (value instanceof Long) {
                cell.setCellValue((double)((Long)value).longValue());
            } else if (value instanceof BigDecimal) {
                if ("amount".equals(fieldType)) {
                    cell.setCellValue(((BigDecimal)value).setScale(precision, 4).toPlainString());
                } else {
                    cell.setCellValue(((BigDecimal)value).doubleValue());
                }
            } else if (value instanceof Date) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                cell.setCellValue(format.format((Date)value));
            } else if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
            } else if (mapper.isComboField()) {
                List<ValueMapItem> comboItems = mapper.getComboItems();
                cell.setCellValue(this.transferComboValue(comboItems, String.valueOf(value)));
            } else if (mapper.isMulComboField()) {
                List<ValueMapItem> comboItems = mapper.getComboItems();
                cell.setCellValue(this.transferMulComboValue(comboItems, (String)value));
            } else {
                cell.setCellValue((String)value);
            }
        }
    }

    private DynamicObject getBaseData(String baseDataEntity, Object key) {
        String cacheKey = "basedata" + key.toString();
        DynamicObject baseData = this.baseDataCache.get(cacheKey);
        if (baseData == null) {
            baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)key, (String)baseDataEntity, (String)"name");
            this.baseDataCache.put(cacheKey, baseData);
        }
        return baseData;
    }

    private DynamicObject getCurrency(Object pkValue) {
        String cacheKey = "currency" + pkValue.toString();
        DynamicObject currency = this.currencyCache.get(cacheKey);
        if (currency == null) {
            currency = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"bd_currency", (String)"name,amtprecision");
            this.currencyCache.put(cacheKey, currency);
        }
        return currency;
    }

    private String transferMulComboValue(List<ValueMapItem> comboItems, String value) {
        List<String> valueList = Arrays.asList(value.split(","));
        StringBuilder sb = new StringBuilder(10);
        for (ValueMapItem comboItem : comboItems) {
            if (!valueList.contains(comboItem.getValue())) continue;
            sb.append(comboItem.getName().getLocaleValue()).append(' ');
        }
        return sb.toString();
    }

    private String transferComboValue(List<ValueMapItem> comboItems, String value) {
        for (ValueMapItem comboItem : comboItems) {
            if (!value.equals(comboItem.getValue())) continue;
            return comboItem.getName().getLocaleValue();
        }
        return null;
    }

    private void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    private CellStyle getHeadStyle(short clr, HorizontalAlignment alignment) {
        XSSFCellStyle cellStyle = this.workbook.createCellStyle();
        this.setCommonStyle((CellStyle)cellStyle);
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setWrapText(true);
        XSSFFont headerFont1 = this.workbook.createFont();
        headerFont1.setColor(clr);
        headerFont1.setBold(true);
        cellStyle.setFont((Font)headerFont1);
        cellStyle.setAlignment(alignment);
        return cellStyle;
    }

    private CellStyle getBodyStyle() {
        String cellKey = "body";
        CellStyle bodyStyle = this.cellStyleMap.get(cellKey);
        if (bodyStyle == null) {
            bodyStyle = this.workbook.createCellStyle();
            this.setCommonStyle(bodyStyle);
            bodyStyle.setFont(this.getFontStyle());
            this.cellStyleMap.put(cellKey, bodyStyle);
        }
        return bodyStyle;
    }

    private CellStyle getAmountStyle(int precision) {
        String cellKey = precision + " " + "amount";
        CellStyle amountStyle = this.cellStyleMap.get(cellKey);
        if (amountStyle == null) {
            amountStyle = this.workbook.createCellStyle();
            this.setCommonStyle(amountStyle);
            String format = "_(#,##0.00_);_(-#,##0.00_)";
            format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
            amountStyle.setDataFormat(this.workbook.createDataFormat().getFormat(format));
            amountStyle.setFont(this.getFontStyle());
            this.cellStyleMap.put(cellKey, amountStyle);
        }
        return amountStyle;
    }

    private CellStyle getIntStyle() {
        String cellKey = "int";
        CellStyle intStyle = this.cellStyleMap.get(cellKey);
        if (intStyle == null) {
            intStyle = this.workbook.createCellStyle();
            this.setCommonStyle(intStyle);
            intStyle.setDataFormat(this.workbook.createDataFormat().getFormat("0"));
            intStyle.setFont(this.getFontStyle());
            this.cellStyleMap.put(cellKey, intStyle);
        }
        return intStyle;
    }

    private Font getFontStyle() {
        XSSFFont font = this.workbook.createFont();
        font.setFontName(ResManager.loadKDString((String)"\u7b49\u7ebf", (String)"SnapExportExecutor_6", (String)"tmc-fcs-common", (Object[])new Object[0]));
        font.setFontHeight(11.0);
        return font;
    }

    private String upload(String exportName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HH'h'mm'm'ss's'");
        String fileName = exportName + "_" + sdf.format(new Date()) + ".xlsx";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)outputStream);
            ByteArrayInputStream inputStream = this.parse(outputStream);
            String path = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inputStream, 5000);
            return path;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u5230\u670d\u52a1\u5668\u5931\u8d25\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5230\u670d\u52a1\u5668\u5931\u8d25\uff1a%s\u3002", (String)"SnapExportExecutor_1", (String)"tmc-fcs-common", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private ByteArrayInputStream parse(OutputStream out) {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }
}

