/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.QueryEvent;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.FilterSchemeHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcFormHelper;

public class SnapGenerateHelper {
    private static final Log logger = LogFactory.getLog(SnapGenerateHelper.class);
    private static final String FILTER_PREFIX = "filter_";

    public static DataSet snapGenerate(String queryPlugin, String formId, String schemeId, QFilter[] filters, String snapNum) throws Throwable {
        logger.info("---------\u751f\u6210\u6570\u636e\u5feb\u7167\u5f00\u59cb\uff0cformId: " + formId + " , schemeId: " + schemeId);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        Class pluginClass = TypesContainer.getOrRegister((String)queryPlugin.trim());
        AbstractReportListDataPlugin reportPlugin = (AbstractReportListDataPlugin)pluginClass.newInstance();
        ReportQueryParam reportQueryParam = SnapGenerateHelper.getBaseReportQueryParam(formId, schemeId, dataEntityType);
        String pageId = TmcFormHelper.createPage((String)formId);
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        ReportViewPluginProxy pluginProxy = SnapGenerateHelper.fillValuesAndFireQuery(reportQueryParam, schemeId, formView, filters);
        SnapGenerateHelper.setQueryParam(reportQueryParam, reportPlugin);
        logger.info("------\u67e5\u8be2\u62a5\u8868\u6570\u636e\u5f00\u59cb\uff0cformId: " + formId + " , schemeId: " + schemeId);
        DataSet ds = reportPlugin.query(reportQueryParam, null);
        logger.info("------\u67e5\u8be2\u62a5\u8868\u6570\u636e\u7ed3\u675f\uff0cformId: " + formId + " , schemeId: " + schemeId);
        List<AbstractReportColumn> columns = SnapGenerateHelper.getAllColumns(formView, reportPlugin);
        ReportList listTable = (ReportList)formView.getControl("reportlistap");
        pluginProxy.fireAfterCreateColumn(listTable.getKey(), columns, reportQueryParam, null);
        SnapDataHelper.saveDataSet((String)formId, (Long)RequestContext.get().getOrgId(), (String)snapNum, (DataSet)ds.copy(), columns);
        logger.info("---------\u751f\u6210\u6570\u636e\u5feb\u7167\u7ed3\u675f\uff0cformId: " + formId + " , schemeId: " + schemeId);
        return ds;
    }

    private static void setQueryParam(ReportQueryParam queryParam, AbstractReportListDataPlugin reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        Field queryParamField = AbstractReportListDataPlugin.class.getDeclaredField("queryParam");
        ReflectionUtils.makeAccessible((Field)queryParamField);
        queryParamField.set(reportPlugin, queryParam);
    }

    private static ReportViewPluginProxy fillValuesAndFireQuery(ReportQueryParam reportQueryParam, String schemeId, IFormView formView, QFilter[] filters) {
        FilterScheme filterScheme = FilterSchemeHelper.getSchemeById((String)schemeId);
        if (null == filterScheme) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u67e5\u8be2\u65b9\u6848\u3002", (String)"SnapGenerateHelper_0", (String)"tmc-fcs-common", (Object[])new Object[0]));
        }
        Map filtersMap = SnapDataHelper.getSchemeFilters((FilterScheme)filterScheme);
        IDataModel model = formView.getModel();
        SnapGenerateHelper.setSchemeFiltersToModel(filtersMap, model);
        SnapGenerateHelper.setCustomFiltersToModel(filters, model);
        ReportViewPluginProxy pluginProxy = (ReportViewPluginProxy)formView.getService(FormViewPluginProxy.class);
        QueryEvent queryEvt = new QueryEvent();
        queryEvt.setQueryParam(reportQueryParam);
        pluginProxy.fireVerifyQuery(queryEvt);
        pluginProxy.fireBeforeQuery(reportQueryParam);
        return pluginProxy;
    }

    private static void setCustomFiltersToModel(QFilter[] filters, IDataModel model) {
        for (int i = 0; i < filters.length; ++i) {
            model.setValue(filters[i].getProperty(), filters[i].getValue());
        }
    }

    private static void setSchemeFiltersToModel(Map<String, Object> filtersMap, IDataModel model) {
        for (Map.Entry<String, Object> entry : filtersMap.entrySet()) {
            String key = entry.getKey();
            if ("_Type_".equals(key)) continue;
            model.setValue(key, SnapDataHelper.transferFilterValue(filtersMap, (String)key));
        }
    }

    private static List<AbstractReportColumn> getAllColumns(IFormView formView, AbstractReportListDataPlugin reportPlugin) {
        ReportList listTable = (ReportList)formView.getControl("reportlistap");
        List columns = null;
        try {
            columns = reportPlugin.getColumns(listTable.getColumns());
        }
        catch (Throwable e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5217\u65f6\u5931\u8d25\uff0cfromId\uff1a" + formView.getEntityId() + " \u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
        return columns;
    }

    public static ReportQueryParam getBaseReportQueryParam(String formId, String schemeId, MainEntityType dataEntityType) {
        ReportQueryParam param = new ReportQueryParam();
        SnapGenerateHelper.setDefaultFilterToParam(param, formId, dataEntityType);
        FilterScheme filterScheme = FilterSchemeHelper.getSchemeById((String)schemeId);
        if (null == filterScheme) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u67e5\u8be2\u65b9\u6848\u3002", (String)"SnapGenerateHelper_0", (String)"tmc-fcs-common", (Object[])new Object[0]));
        }
        try {
            Map filtersMap = SnapDataHelper.getSchemeFilters((FilterScheme)filterScheme);
            SnapDataHelper.setSchemeFilterToParam((ReportQueryParam)param, (Map)filtersMap);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u62a5\u8868\u67e5\u8be2\u53c2\u6570\u9519\u8bef\u3002", (String)"SnapGenerateHelper_1", (String)"tmc-fcs-common", (Object[])new Object[0]));
        }
        return param;
    }

    private static void setDefaultFilterToParam(ReportQueryParam param, String formId, MainEntityType dataEntityType) {
        Map fieldsMap = dataEntityType.getFields();
        FilterInfo filterInfo = new FilterInfo();
        for (Map.Entry entry : fieldsMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            IDataEntityProperty field = (IDataEntityProperty)entry.getValue();
            if (field instanceof BooleanProp) {
                filterInfo.addFilterItem(fieldName, ((BooleanProp)field).getDefValue());
                continue;
            }
            filterInfo.addFilterItem(fieldName, null);
        }
        param.setFilter(filterInfo);
        String appId = dataEntityType.getAppId();
        HashMap<String, String> customParam = new HashMap<String, String>(4);
        customParam.put("formid", formId);
        customParam.put("appid", appId);
        param.setCustomParam(customParam);
    }
}

