/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.MulComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.SnapTypeEnum;
import kd.tmc.fcs.common.helper.SnapGenerateHelper;
import kd.tmc.fcs.common.model.ExportHeadMapper;

public class SnapSchemeHelper {
    private static final Log logger = LogFactory.getLog(SnapSchemeHelper.class);

    public static DataSet getDataBySnapScheme(Long snapSchemeId, String snapType, Date snapDate) {
        DynamicObject snapScheme = TmcDataServiceHelper.loadSingle((Object)snapSchemeId, (String)"fcs_snapscheme", (String)"number,reportform,queryscheme,plugin,param_entry.paramname,param_entry.paramtype,param_entry.paramvalue,param_entry.basedatainfo");
        String formId = snapScheme.getDynamicObject("reportform").getString("number");
        String schemeNumber = snapScheme.getString("number");
        SnapTypeEnum snapTypeEnum = SnapTypeEnum.getEnumByValue(snapType);
        DataSet ds = null;
        switch (snapTypeEnum) {
            case ACTUAL: {
                ds = SnapSchemeHelper.getActualData(snapScheme, formId, schemeNumber);
                break;
            }
            case HISTORY: {
                ds = SnapSchemeHelper.getHistoryData(formId, snapDate, schemeNumber);
                break;
            }
        }
        return ds;
    }

    private static DataSet getHistoryData(String formId, Date snapDate, String schemeNumber) {
        DataSet ds = null;
        long time = System.nanoTime();
        try {
            DynamicObject dataSnap = SnapDataHelper.getDataSnap((String)formId, null, (String)schemeNumber, (Date)snapDate);
            if (EmptyUtil.isNoEmpty((DynamicObject)dataSnap)) {
                String snapTag = GzipUtils.uncompress((String)dataSnap.getString("snap_tag"), (String)"UTF-8");
                String fieldsTag = GzipUtils.uncompress((String)dataSnap.getString("fields_tag"), (String)"UTF-8");
                Field[] fields = (Field[])SerializationUtils.deSerializeFromBase64((String)fieldsTag);
                DataSetBuilder dataSetBuilder = Algo.create((String)SnapSchemeHelper.class.getName()).createDataSetBuilder(new RowMeta(fields));
                List rows = (List)SerializationUtils.deSerializeFromBase64((String)snapTag);
                for (Row row : rows) {
                    if (!EmptyUtil.isNoEmpty((Object)row)) continue;
                    dataSetBuilder.append(row);
                }
                ds = dataSetBuilder.build();
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5386\u53f2\u5feb\u7167\u4fe1\u606f\u5931\u8d25: ", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5386\u53f2\u5feb\u7167\u4fe1\u606f\u5931\u8d25\uff1a%s\u3002", (String)"SnapSchemeHelper_0", (String)"tmc-fcs-common", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            long costMs = (System.nanoTime() - time) / 1000L / 1000L;
            logger.info("\u5386\u53f2\u5feb\u7167\u53d6\u6570\u8017\u65f6\uff1a" + costMs + "s");
        }
        return ds;
    }

    private static DataSet getActualData(DynamicObject snapScheme, String formId, String schemeNumber) {
        DataSet ds;
        long time = System.nanoTime();
        String plugin = snapScheme.getString("plugin");
        DynamicObjectCollection paramEntry = snapScheme.getDynamicObjectCollection("param_entry");
        QFilter[] filters = SnapSchemeHelper.parseFilter(paramEntry);
        String schemeId = (String)snapScheme.getDynamicObject("queryscheme").getPkValue();
        try {
            ds = SnapGenerateHelper.snapGenerate(plugin, formId, schemeId, filters, snapScheme.getString("number"));
        }
        catch (Throwable e) {
            logger.error("\u83b7\u53d6\u5b9e\u65f6\u5feb\u7167\u4fe1\u606f\u5931\u8d25: ", e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5b9e\u65f6\u5feb\u7167\u4fe1\u606f\u5931\u8d25\uff1a%s\u3002", (String)"SnapSchemeHelper_1", (String)"tmc-fcs-common", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            long costMs = (System.nanoTime() - time) / 1000L / 1000L;
            logger.info("\u5b9e\u65f6\u5feb\u7167\u53d6\u6570\u8017\u65f6\uff1a" + costMs + "s");
        }
        return ds;
    }

    public static List<ExportHeadMapper> getHeaders(String formId, DynamicObject dataSnap) {
        List<ExportHeadMapper> headers = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)dataSnap)) {
                String columnTag = GzipUtils.uncompress((String)dataSnap.getString("columns_tag"), (String)"UTF-8");
                List columns = (List)SerializationUtils.deSerializeFromBase64((String)columnTag);
                headers = SnapSchemeHelper.addReportColumnToHead(columns, formId);
            }
        }
        catch (Exception e) {
            logger.error(formId + " --\u83b7\u53d6\u62a5\u8868\u8868\u5934\u4fe1\u606f\u5931\u8d25: ", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u8868\u5934\u4fe1\u606f\u5931\u8d25\uff1a%s\u3002", (String)"SnapSchemeHelper_2", (String)"tmc-fcs-common", (Object[])new Object[]{e.getMessage()}));
        }
        return headers;
    }

    private static List<ExportHeadMapper> addReportColumnToHead(List<AbstractReportColumn> columns, String formId) {
        ArrayList<ExportHeadMapper> mappers = new ArrayList<ExportHeadMapper>(columns.size());
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                boolean isHide = ((ReportColumn)column).isHide();
                if (isHide) continue;
                ExportHeadMapper mapper = new ExportHeadMapper();
                String name = column.getCaption().getLocaleValue();
                String key = ((ReportColumn)column).getFieldKey();
                String fieldType = ((ReportColumn)column).getFieldType();
                mapper.setKey(key);
                mapper.setName(name);
                mapper.setFieldType(fieldType);
                if ("amount".equals(fieldType)) {
                    mapper.setCurrencyField(((ReportColumn)column).getCurrencyField());
                } else if ("basedata".equals(fieldType) || "user".equals(fieldType)) {
                    mapper.setBaseDataEntity(SnapSchemeHelper.getBaseDataEntity(formId, key));
                }
                if (column instanceof MulComboReportColumn) {
                    mapper.setMulComboField(true);
                    mapper.setComboItems(((MulComboReportColumn)column).getComboItems());
                } else if (column instanceof ComboReportColumn) {
                    mapper.setComboField(true);
                    mapper.setComboItems(((ComboReportColumn)column).getComboItems());
                }
                mappers.add(mapper);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ExportHeadMapper mapper = new ExportHeadMapper();
            String name = column.getCaption().getLocaleValue();
            String key = ((ReportColumnGroup)column).getFieldKey();
            mapper.setKey(key);
            mapper.setName(name);
            List subColumns = ((ReportColumnGroup)column).getChildren();
            mapper.setSubItems(SnapSchemeHelper.addReportColumnToHead(subColumns, formId));
            mappers.add(mapper);
        }
        return mappers;
    }

    private static String getBaseDataEntity(String formId, String field) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        Map fieldsMap = dataEntityType.getFields();
        BasedataProp prop = (BasedataProp)fieldsMap.get(field);
        return prop.getBaseEntityId();
    }

    public static QFilter[] parseFilter(DynamicObjectCollection paramEntry) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (DynamicObject entry : paramEntry) {
            String paramName = entry.getString("paramname");
            String paramType = entry.getString("paramtype");
            Object paramValue = "8".equals(paramType) ? SnapSchemeHelper.getBaseData(entry) : ("7".equals(paramType) ? Boolean.valueOf((String)entry.get("paramvalue")) : entry.get("paramvalue"));
            QFilter filter = new QFilter(paramName, "=", paramValue);
            filters.add(filter);
        }
        return filters.toArray(new QFilter[0]);
    }

    private static DynamicObject getBaseData(DynamicObject entry) {
        String baseDataInfo = entry.getString("basedatainfo");
        JSONObject baseDataJson = JSON.parseObject((String)baseDataInfo);
        JSONObject baseDataValue = baseDataJson.getJSONObject("basedatavalue");
        String entityName = baseDataValue.getString("number");
        String id = baseDataValue.getString("id");
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(id), (String)entityName);
        return baseData;
    }
}

