/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.bean.BankLog;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;

public class BankLogConsumer
implements IMessageConsumer {
    private static Log logger = LogFactory.getLog(BankLogConsumer.class);

    @Override
    public boolean canApply(String type) {
        return "banklog".equals(type);
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try (TXHandle tx = TX.requiresNew();){
            Map msgParam = (Map)message;
            List logStrList = (List)msgParam.get("data");
            List bankLogList = logStrList.stream().map(o -> (BankLog)JSON.parseObject((String)o, BankLog.class)).collect(Collectors.toList());
            Object[] bankLogIdArr = bankLogList.stream().map(BankLog::getId).toArray();
            DynamicObject[] bankLogArr = TmcDataServiceHelper.load((Object[])bankLogIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_banklog"));
            Map<Object, DynamicObject> dbBankLogMap = Arrays.stream(bankLogArr).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            boolean isAllSave = bankLogList.stream().filter(o -> !o.isInitSave()).map(BankLog::getId).allMatch(dbBankLogMap::containsKey);
            if (!isAllSave) {
                acker.deny(messageId);
                return;
            }
            try {
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(logStrList.size());
                for (BankLog bankLog : bankLogList) {
                    DynamicObject bankLogObj;
                    if (bankLog.isInitSave()) {
                        bankLogObj = BusinessDataServiceHelper.newDynamicObject((String)"bei_banklog");
                        bankLogObj.set("id", (Object)bankLog.getId());
                    } else {
                        bankLogObj = dbBankLogMap.get(bankLog.getId());
                    }
                    bankLogObj.set("banklogtype", (Object)bankLog.getBankLogType());
                    bankLogObj.set("time", (Object)new Date(bankLog.getTime()));
                    bankLogObj.set("accountbank", (Object)bankLog.getAccountBankNo());
                    bankLogObj.set("sourcebilltype", (Object)bankLog.getSourceBillType());
                    bankLogObj.set("sourcebillno", (Object)bankLog.getSourceBillNo());
                    bankLogObj.set("executor", (Object)bankLog.getExecutor());
                    bankLogObj.set("isexception", (Object)bankLog.getIsException());
                    bankLogObj.set("exceptionmsg", (Object)bankLog.getExceptionMsg());
                    bankLogObj.set("sourceid", (Object)bankLog.getSourceId());
                    bankLogObj.set("srcbizid", (Object)bankLog.getSrcBizId());
                    bankLogObj.set("company", (Object)bankLog.getCompanyId());
                    bankLogObj.set("bankpaystate", (Object)bankLog.getBankPayState());
                    bankLogObj.set("sendinfo", (Object)bankLog.getSendInfo());
                    bankLogObj.set("receiveinfo", (Object)bankLog.getReceiveInfo());
                    bankLogObj.set("sendexceptioninfo", (Object)bankLog.getSendExceptionInfo());
                    bankLogObj.set("receiveexceptioninfo", (Object)bankLog.getReceiveExceptionInfo());
                    bankLogObj.set("transtype", (Object)bankLog.getTransType());
                    bankLogObj.set("bizexceptioninfo", (Object)bankLog.getBizexceptioninfo());
                    bankLogObj.set("paytotalamt", (Object)bankLog.getPayTotalAmt());
                    bankLogObj.set("paycurrency", (Object)bankLog.getPayCurrencyId());
                    bankLogObj.set("requestid", (Object)bankLog.getRequestId());
                    DynamicObjectCollection entryList = bankLogObj.getDynamicObjectCollection("entryentity");
                    entryList.clear();
                    List detailList = bankLog.getDetailList();
                    if (detailList == null || detailList.size() == 0) {
                        DynamicObject entry = entryList.addNew();
                        entry.set("e_billorg", (Object)bankLog.getCompanyId());
                        entry.set("e_billtype", (Object)bankLog.getSourceBillType());
                        entry.set("e_billid", (Object)bankLog.getSourceId());
                        entry.set("e_billnumber", (Object)bankLog.getSourceBillNo());
                        QFilter acctNumFilter = new QFilter("number", "=", (Object)bankLog.getAccountBankNo());
                        DynamicObject idObj = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{acctNumFilter});
                        if (idObj != null) {
                            entry.set("e_acctbank", idObj.getPkValue());
                        }
                        entry.set("e_paybilltype", (Object)bankLog.getSourceBillType());
                        entry.set("e_paybillid", (Object)bankLog.getSrcBizId());
                        entry.set("e_banklogtype", (Object)bankLog.getBankLogType());
                        entry.set("e_payamt", (Object)bankLog.getPayTotalAmt());
                    } else {
                        for (BankLogDetail logDetail : detailList) {
                            DynamicObject entry = entryList.addNew();
                            entry.set("e_billorg", (Object)logDetail.getBillOrgId());
                            entry.set("e_billtype", (Object)logDetail.getBillType());
                            entry.set("e_billid", (Object)logDetail.getBillId());
                            entry.set("e_billnumber", (Object)logDetail.getBillNumber());
                            entry.set("e_acctbank", (Object)logDetail.getAcctBankId());
                            entry.set("e_paybilltype", (Object)logDetail.getPayBillType());
                            entry.set("e_paybillid", (Object)logDetail.getPayBillId());
                            if (logDetail.getLogType() != null) {
                                entry.set("e_banklogtype", (Object)logDetail.getLogType());
                            } else {
                                entry.set("e_banklogtype", (Object)bankLog.getBankLogType());
                            }
                            entry.set("e_payamt", (Object)logDetail.getPayAmt());
                            entry.set("e_bankpaystate", (Object)logDetail.getPayState());
                        }
                    }
                    logList.add(bankLogObj);
                }
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                acker.deny(messageId);
                return;
            }
        }
        acker.ack(messageId);
    }
}

