/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.mservice.inspect.TransDetailInspectService;

public class InspectConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(InspectConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String inspectType;
        Map param = (Map)message;
        switch (inspectType = (String)param.get("InspectType")) {
            case "bizDeal": {
                this.bizDeal(param, acker, messageId);
                break;
            }
            case "bankQuery": {
                this.bankQuery(param, acker, messageId);
            }
        }
        acker.discard(messageId);
    }

    private void bizDeal(Map<String, Object> param, MessageAcker acker, String messageId) {
        String targetEntity = (String)param.get("targetEntity");
        String operationKey = (String)param.get("operationKey");
        List idList = (List)param.get("idList");
        try {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"suspectRepeatService", (String)"suspectRepeatGen", (Object[])new Object[]{targetEntity, idList, operationKey, null});
            acker.ack(messageId);
        }
        catch (Exception e) {
            acker.deny(messageId);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bankQuery(Map<String, Object> param, MessageAcker acker, String messageId) {
        try {
            Long bankAcctId = (Long)param.get("bankAcct");
            Long currencyId = (Long)param.get("currency");
            Date bizDate = (Date)param.get("bizDate");
            String key = bankAcctId + "LimitDetailQuery" + currencyId;
            DLock dl = DLock.create((String)key);
            boolean locked = dl.tryLock(60000L);
            if (!locked) {
                logger.info("InspectConsumer--lockFail:" + key);
                return;
            }
            try {
                DeleteServiceHelper.delete((String)"fcs_bankquerydetail", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"1"), new QFilter("account", "=", (Object)bankAcctId), new QFilter("currency", "=", (Object)currencyId), new QFilter("lastruntime", "<", (Object)DateUtils.getCurrentDate())});
                DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"fcs_bankquerydetail", (String)"account,currency,lastruntime,runtimes", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"1"), new QFilter("account", "=", (Object)bankAcctId), new QFilter("currency", "=", (Object)currencyId)});
                Date curTime = new Date();
                Date lastTime = new Date(curTime.getTime() - 600000L);
                if (EmptyUtil.isNoEmpty((DynamicObject)record)) {
                    if (record.getDate("lastruntime").after(lastTime)) {
                        logger.info("InspectConsumer--10mDo:" + key);
                        return;
                    }
                    if (record.getInt("runtimes") >= 3) {
                        logger.info("InspectConsumer--3count:" + key);
                        return;
                    }
                    logger.info("InspectConsumer--addCount:" + key);
                    record.set("lastruntime", (Object)curTime);
                    record.set("runtimes", (Object)(record.getInt("runtimes") + 1));
                    SaveServiceHelper.update((DynamicObject)record);
                } else {
                    logger.info("InspectConsumer--noRecord:" + key);
                    record = TmcDataServiceHelper.newDynamicObject((String)"fcs_bankquerydetail");
                    record.set("account", (Object)bankAcctId);
                    record.set("currency", (Object)currencyId);
                    record.set("lastruntime", (Object)curTime);
                    record.set("runtimes", (Object)1);
                    record.set("type", (Object)"1");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                }
            }
            finally {
                dl.unlock();
            }
            TransDetailInspectService service = new TransDetailInspectService();
            service.queryTransDetail(bankAcctId, currencyId, bizDate);
            List billIds = (List)param.get("billIds");
            String targetEntity = (String)param.get("targetEntity");
            service.executeInspectBillMatch(billIds, targetEntity);
            acker.ack(messageId);
        }
        catch (Exception e) {
            acker.deny(messageId);
            throw e;
        }
    }
}

