/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.log.bean.PayTraceLog;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;

public class PayTraceLogConsumer
implements IMessageConsumer {
    private static Log logger = LogFactory.getLog(PayTraceLogConsumer.class);

    @Override
    public boolean canApply(String type) {
        return "paytracelog".equals(type);
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map msgParam = (Map)message;
                List logStrList = (List)msgParam.get("data");
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(logStrList.size());
                for (String logStr : logStrList) {
                    PayTraceLog traceLogInfo = (PayTraceLog)JSON.parseObject((String)logStr, PayTraceLog.class);
                    DynamicObject traceLogObj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_paytracelog");
                    traceLogObj.set("billtype", (Object)traceLogInfo.getEntityType());
                    traceLogObj.set("billid", (Object)traceLogInfo.getBillId());
                    traceLogObj.set("billnumber", (Object)traceLogInfo.getBillNumber());
                    traceLogObj.set("level", (Object)traceLogInfo.getLevel());
                    traceLogObj.set("source", (Object)traceLogInfo.getSource());
                    traceLogObj.set("paystep", (Object)traceLogInfo.getStep());
                    traceLogObj.set("classname", (Object)traceLogInfo.getClassName());
                    traceLogObj.set("methodname", (Object)traceLogInfo.getMethod());
                    traceLogObj.set("linenum", (Object)traceLogInfo.getLine());
                    traceLogObj.set("taginfo", (Object)traceLogInfo.getTag());
                    traceLogObj.set("createtime", (Object)new Date(traceLogInfo.getTime()));
                    traceLogObj.set("traceid", (Object)traceLogInfo.getTraceId());
                    traceLogObj.set("detailinfo", traceLogInfo.getInfo() != null ? traceLogInfo.getInfo().substring(0, Math.min(traceLogInfo.getInfo().length(), 255)) : null);
                    traceLogObj.set("detailinfo_TAG", (Object)traceLogInfo.getInfo());
                    traceLogObj.set("exception", traceLogInfo.getException() != null ? traceLogInfo.getException().substring(0, Math.min(traceLogInfo.getException().length(), 255)) : null);
                    traceLogObj.set("exception_TAG", (Object)traceLogInfo.getException());
                    logList.add(traceLogObj);
                }
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                acker.deny(messageId);
                if (tx != null) {
                    if (var6_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        acker.ack(messageId);
    }
}

