/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.log.bean.RepeatCtrlLog;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;

public class RepeatLogConsumer
implements IMessageConsumer {
    private static Log logger = LogFactory.getLog(RepeatLogConsumer.class);

    @Override
    public boolean canApply(String type) {
        List<String> accessLogs = Arrays.asList("payaccess", "repeatctrl", "accessrecord", "bizcheck");
        return accessLogs.contains(type);
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map msgParam = (Map)message;
                List logStrList = (List)msgParam.get("data");
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(logStrList.size());
                for (String logStr : logStrList) {
                    RepeatCtrlLog repeatCtrlLog = (RepeatCtrlLog)JSON.parseObject((String)logStr, RepeatCtrlLog.class);
                    DynamicObject repeatLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_repeatctrllog");
                    repeatLog.set("repeatset", (Object)repeatCtrlLog.getRepeatset());
                    repeatLog.set("sourcebilltype", (Object)repeatCtrlLog.getSourceBillType());
                    repeatLog.set("sourcebillid", (Object)repeatCtrlLog.getSourceBillId());
                    repeatLog.set("costtime", (Object)repeatCtrlLog.getCostTime());
                    repeatLog.set("createtime", (Object)new Date(repeatCtrlLog.getTime()));
                    repeatLog.set("traceid", (Object)repeatCtrlLog.getTraceId());
                    repeatLog.set("exception", repeatCtrlLog.getException() != null ? repeatCtrlLog.getException().substring(0, Math.min(255, repeatCtrlLog.getException().length())) : null);
                    repeatLog.set("exception_TAG", (Object)repeatCtrlLog.getException());
                    repeatLog.set("logtype", (Object)repeatCtrlLog.getLogType());
                    repeatLog.set("destbilltype", (Object)repeatCtrlLog.getDestBillType());
                    repeatLog.set("destbillid", (Object)repeatCtrlLog.getDestBillId());
                    repeatLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                    repeatLog.set("checkresult", (Object)repeatCtrlLog.getCheckresult());
                    logList.add(repeatLog);
                }
                TmcOperateServiceHelper.execOperate((String)"save", (String)"fcs_repeatctrllog", (DynamicObject[])logList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                acker.deny(messageId);
                if (tx != null) {
                    if (var6_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        acker.ack(messageId);
    }
}

