/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.log.bean.SuspectRepeatDetail;
import kd.tmc.fbp.common.log.bean.SuspectRepeatLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.FcsParameterHelper;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;

public class SuspectRepeatLogConsumer
implements IMessageConsumer {
    private static final Log logger = LogFactory.getLog(SuspectRepeatLogConsumer.class);

    @Override
    public boolean canApply(String type) {
        return "suspect".equals(type);
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        boolean isPayLogEnable = FcsParameterHelper.getAppBoolParameter((long)RequestContext.get().getOrgId(), (String)"issuspectlogenable");
        if (!isPayLogEnable) {
            acker.ack(messageId);
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map msgParam = (Map)message;
                List logStrList = (List)msgParam.get("data");
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(logStrList.size());
                for (String logStr : logStrList) {
                    SuspectRepeatLog log = (SuspectRepeatLog)JSON.parseObject((String)logStr, SuspectRepeatLog.class);
                    DynamicObject repeatLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_suspectlog");
                    repeatLog.set("repeatset", (Object)log.getRepeatSet());
                    repeatLog.set("logtype", (Object)log.getLogType());
                    repeatLog.set("traceid", (Object)log.getTraceId());
                    repeatLog.set("costtime", (Object)log.getCostTime());
                    repeatLog.set("exception", log.getException() != null ? log.getException().substring(0, Math.min(255, log.getException().length())) : null);
                    repeatLog.set("exception_TAG", (Object)log.getException());
                    repeatLog.set("createtime", (Object)new Date(log.getTime()));
                    repeatLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                    List detailList = log.getDetailList();
                    DynamicObjectCollection entryList = repeatLog.getDynamicObjectCollection("entry");
                    entryList.clear();
                    if (EmptyUtil.isNoEmpty((Object)detailList)) {
                        for (SuspectRepeatDetail detail : detailList) {
                            DynamicObject entry = entryList.addNew();
                            entry.set("destbilltype", (Object)detail.getDestBillType());
                            entry.set("destbillid", (Object)detail.getDestBillId());
                            entry.set("destnumber", (Object)detail.getDestNumber());
                        }
                    }
                    logList.add(repeatLog);
                }
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                acker.deny(messageId);
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        acker.ack(messageId);
    }
}

