/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tmc.fbp.common.log.bean.TaskExecLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.TaskExecuteStatusEnum;
import kd.tmc.fcs.common.helper.FcsParameterHelper;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;

public class TaskExecLogConsumer
implements IMessageConsumer {
    private static Log logger = LogFactory.getLog(TaskExecLogConsumer.class);

    @Override
    public boolean canApply(String type) {
        List<String> accessLogs = Collections.singletonList("taskexecute");
        return accessLogs.contains(type);
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        boolean isPayLogEnable = FcsParameterHelper.getAppBoolParameter((long)RequestContext.get().getOrgId(), (String)"istaskflowlogenable");
        if (!isPayLogEnable) {
            acker.ack(messageId);
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map msgParam = (Map)message;
                List logStrList = (List)msgParam.get("data");
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(logStrList.size());
                ArrayList<TaskExecLog> needMessageLog = new ArrayList<TaskExecLog>(logStrList.size());
                for (String logStr : logStrList) {
                    TaskExecLog taskExecLog = (TaskExecLog)JSON.parseObject((String)logStr, TaskExecLog.class);
                    if (!taskExecLog.isSumLog()) {
                        DynamicObject taskDetailLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_taskexedetail_log");
                        taskDetailLog.set("result", (Object)taskExecLog.getResult());
                        taskDetailLog.set("costtime", (Object)Float.valueOf(taskExecLog.getCostTime()));
                        taskDetailLog.set("createtime", (Object)new Date(taskExecLog.getTime()));
                        taskDetailLog.set("traceid", (Object)taskExecLog.getTraceId());
                        taskDetailLog.set("exception", taskExecLog.getException() != null ? taskExecLog.getException().substring(0, Math.min(255, taskExecLog.getException().length())) : null);
                        taskDetailLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                        taskDetailLog.set("operatename", (Object)taskExecLog.getOperateName());
                        taskDetailLog.set("operatekey", (Object)taskExecLog.getOperatekey());
                        taskDetailLog.set("bizbillno", (Object)taskExecLog.getBizBillno());
                        taskDetailLog.set("bizbillid", (Object)taskExecLog.getBizBillId());
                        taskDetailLog.set("mainentity", (Object)taskExecLog.getMainEntity());
                        taskDetailLog.set("sumlogid", (Object)taskExecLog.getSumLogId());
                        logger.info("\u660e\u7ec6\u65e5\u5fd7\uff1a" + taskExecLog.getBizBillno() + "-" + taskExecLog.getOperatekey() + "-" + taskExecLog.getResult());
                        logList.add(taskDetailLog);
                        if (!EmptyUtil.isNoEmpty((Long)taskExecLog.getExceptionReceiver()) || !TaskExecuteStatusEnum.FAIL.getValue().equals(taskExecLog.getResult())) continue;
                        needMessageLog.add(taskExecLog);
                        continue;
                    }
                    DynamicObject taskSumLog = BusinessDataServiceHelper.newDynamicObject((String)"fcs_taskexesum_log");
                    if (TaskExecuteStatusEnum.SUCCESS.getValue().equals(taskExecLog.getExestatus())) {
                        DynamicObjectCollection detailLogs = QueryServiceHelper.query((String)"fcs_taskexedetail_log", (String)"id,result,sumlogid", (QFilter[])new QFilter[]{new QFilter("sumlogid", "=", (Object)taskExecLog.getSumLogId())});
                        long count = detailLogs.stream().filter(l -> TaskExecuteStatusEnum.FAIL.getValue().equals(l.getString("result"))).count();
                        logger.info("\u4fdd\u5b58\u6c47\u603b\u65e5\u5fd7\uff0c\u67e5\u5230\u660e\u7ec6\u65e5\u5fd7\u6267\u884c\u5931\u8d25\u7684\u4e2a\u6570\uff1a" + count);
                        taskSumLog.set("exestatus", (Object)(count > 0L ? TaskExecuteStatusEnum.FAIL.getValue() : TaskExecuteStatusEnum.SUCCESS.getValue()));
                    } else {
                        taskSumLog.set("exestatus", (Object)taskExecLog.getExestatus());
                    }
                    taskSumLog.set("taskflownumber", (Object)taskExecLog.getTaskNumber());
                    taskSumLog.set("taskflowname", (Object)taskExecLog.getTaskName());
                    taskSumLog.set("executor", (Object)taskExecLog.getExecutor());
                    taskSumLog.set("exception", taskExecLog.getException() != null ? taskExecLog.getException().substring(0, Math.min(255, taskExecLog.getException().length())) : null);
                    taskSumLog.set("createtime", (Object)new Date(taskExecLog.getTime()));
                    taskSumLog.set("endtime", (Object)new Date(taskExecLog.getEndTime()));
                    taskSumLog.set("sumlogid", (Object)taskExecLog.getSumLogId());
                    logList.add(taskSumLog);
                }
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
                this.sendErrorMessage(needMessageLog);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                acker.deny(messageId);
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        acker.ack(messageId);
    }

    private void sendErrorMessage(List<TaskExecLog> needMessageLog) {
        for (TaskExecLog log : needMessageLog) {
            MessageInfo message = new MessageInfo();
            message.setTag(ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u6392\u65b9\u6848", (String)"TaskExecLogConsumer_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
            message.setTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u6392\u65b9\u6848%s\u6267\u884c\u5f02\u5e38\u901a\u77e5", (String)"TaskExecLogConsumer_1", (String)"tmc-fcs-mservice", (Object[])new Object[]{log.getTaskNumber()}));
            message.setContent(String.format(ResManager.loadKDString((String)"%1$s+%2$s+%3$s+%4$s", (String)"TaskExecLogConsumer_2", (String)"tmc-fcs-mservice", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)log.getMainEntity()).getDisplayName(), log.getBizBillno(), log.getOperateName(), log.getException()));
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=fcs_taskexedetail_log&type=list&list_formId=bos_list&sumlogid=" + log.getSumLogId());
            message.setUserIds(Collections.singletonList(log.getExceptionReceiver()));
            message.setType("warning");
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
    }
}

