/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.bean.TdaLog;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;

public class TdaLogConsumer
implements IMessageConsumer {
    private static Log logger = LogFactory.getLog(TdaLogConsumer.class);

    @Override
    public boolean canApply(String type) {
        List<String> accessLogs = Collections.singletonList("tdalog");
        return accessLogs.contains(type);
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        boolean isLogEnable = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"tadSysParamService", (String)"getSysParamValue", (Object[])new Object[]{"istdalogenable"});
        if (!isLogEnable) {
            acker.ack(messageId);
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map msgParam = (Map)message;
                List logStrList = (List)msgParam.get("data");
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(logStrList.size());
                for (TdaLog tdaLog : logStrList) {
                    DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fcs_tdalog");
                    log.set("org", (Object)tdaLog.getOrg());
                    log.set("orgview", (Object)tdaLog.getOrgView());
                    log.set("report", (Object)tdaLog.getReport());
                    log.set("schedule", (Object)tdaLog.getSchedule());
                    log.set("snapitem", (Object)tdaLog.getSnapitem());
                    log.set("type", (Object)tdaLog.getType());
                    log.set("costtime", (Object)tdaLog.getCosttime());
                    log.set("createtime", (Object)DateUtils.getCurrentTime());
                    log.set("traceid", (Object)tdaLog.getTraceid());
                    log.set("exception", tdaLog.getException() != null ? tdaLog.getException().substring(0, Math.min(255, tdaLog.getException().length())) : null);
                    log.set("exception_TAG", (Object)tdaLog.getException());
                    log.set("desc", (Object)tdaLog.getDesc());
                    log.set("creator", (Object)RequestContext.get().getCurrUserId());
                    log.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                    logList.add(log);
                }
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                acker.ack(messageId);
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        acker.ack(messageId);
    }
}

