/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.MQ;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tmc.fcs.mservice.MQ.BankLogConsumer;
import kd.tmc.fcs.mservice.MQ.IMessageConsumer;
import kd.tmc.fcs.mservice.MQ.PayTraceLogConsumer;
import kd.tmc.fcs.mservice.MQ.RepeatLogConsumer;
import kd.tmc.fcs.mservice.MQ.SuspectRepeatLogConsumer;
import kd.tmc.fcs.mservice.MQ.TaskExecLogConsumer;
import kd.tmc.fcs.mservice.MQ.TdaLogConsumer;

public class TmcLogConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(TmcLogConsumer.class);
    private List<IMessageConsumer> consumerList = new ArrayList<IMessageConsumer>();

    public TmcLogConsumer() {
        this.consumerList.add(new PayTraceLogConsumer());
        this.consumerList.add(new BankLogConsumer());
        this.consumerList.add(new RepeatLogConsumer());
        this.consumerList.add(new TaskExecLogConsumer());
        this.consumerList.add(new SuspectRepeatLogConsumer());
        this.consumerList.add(new TdaLogConsumer());
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        Map msgParam = (Map)message;
        String msgType = (String)msgParam.get("type");
        for (IMessageConsumer consumer : this.consumerList) {
            if (!consumer.canApply(msgType)) continue;
            consumer.onMessage(message, messageId, resend, acker);
            return;
        }
        logger.error("MessageType Error. messageId: " + messageId + ", message: " + message);
        acker.discard(messageId);
    }
}

