/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.archive.impl;

import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fcs.common.enums.ArchiveStatusEnum;

public class ArchiveProgressHandler {
    private static final int STATE_INIT = 0;
    private static final int STATE_START = 1;
    private static final int STATE_FINISH = 2;
    private static final String UPDATE_PROGRESS_SQL = "update t_fcs_archiverecord set ffinishcnt = ?, fheartbeattime = ? where fid = ?";
    private static final String FAIL_SQL = "update t_fcs_archiverecord set fheartbeattime = ?, ffinishtime = ?, farchivestatus = ?, fexceptionmsg = ?, fexceptionmsg_tag = ? where fid = ?";
    private static final String FINISH_SQL = "update t_fcs_archiverecord set fheartbeattime = ?, ffinishtime = ?, farchivestatus = ?, ftotalcnt = ? , ffinishcnt = ?, fpercent = ? where fid = ?";
    private final DynamicObject setting;
    private Long currRecordId;
    private int finishCnt;
    private int state = 0;

    public ArchiveProgressHandler(DynamicObject setting, String version) {
        this.setting = setting;
    }

    public void start() {
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.finishCnt = 0;
        DynamicObject archiveRecord = TmcDataServiceHelper.newDynamicObject((String)"fcs_archiverecord");
        archiveRecord.set("itemclass", (Object)"fcs_archivesetting");
        archiveRecord.set("item", this.setting.get("id"));
        archiveRecord.set("heartbeattime", (Object)new Date());
        archiveRecord.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        archiveRecord.set("archivestatus", (Object)ArchiveStatusEnum.PROCESSING.getValue());
        OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"fcs_archiverecord", (DynamicObject[])new DynamicObject[]{archiveRecord}, (OperateOption)OperateOption.create());
        this.currRecordId = (Long)saveResult.getSuccessPkIds().get(0);
    }

    public void updateProgress(int dataCnt) {
        if (this.state != 1) {
            return;
        }
        this.finishCnt += dataCnt;
        DB.execute((DBRoute)DBRouteConst.TMC, (String)UPDATE_PROGRESS_SQL, (Object[])new Object[]{this.finishCnt, new Date(), this.currRecordId});
    }

    public void fail(Exception e) {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        DB.execute((DBRoute)DBRouteConst.TMC, (String)FAIL_SQL, (Object[])new Object[]{new Date(), new Date(), ArchiveStatusEnum.FAIL.getValue(), e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e), this.currRecordId});
    }

    public void finish() {
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        DB.execute((DBRoute)DBRouteConst.TMC, (String)FINISH_SQL, (Object[])new Object[]{new Date(), new Date(), ArchiveStatusEnum.SUCCESS.getValue(), this.finishCnt, this.finishCnt, Constants.ONE_HUNDRED, this.currRecordId});
    }
}

