/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.archive.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fcs.common.enums.ArchiveStatusEnum;
import kd.tmc.fcs.mservice.archive.ArchiveResult;
import kd.tmc.fcs.mservice.archive.IArchiveService;
import kd.tmc.fcs.mservice.archive.impl.ArchiveTask;
import kd.tmc.fcs.mservice.archive.impl.DeleteArchiveTask;

public class ArchiveService
implements IArchiveService {
    private static final String LOCK_PREFIX_SERVICE = "__FCS_ArchiveService";

    @Override
    public List<ArchiveResult> archiveAll() {
        List<DynamicObject> settingList = this.loadArchiveSetting();
        return this.doArchive(settingList);
    }

    @Override
    public List<ArchiveResult> archive(List<DynamicObject> settingList) {
        return this.doArchive(settingList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ArchiveResult> doArchive(List<DynamicObject> settingList) {
        ArrayList<ArchiveResult> resultList = new ArrayList<ArchiveResult>(10);
        DLock serviceLock = DLock.create((String)LOCK_PREFIX_SERVICE);
        boolean hasLock = serviceLock.tryLock();
        if (hasLock) {
            try {
                for (DynamicObject setting : settingList) {
                    if (setting.getBoolean("onlydelete")) {
                        ThreadService.execute((Runnable)new DeleteArchiveTask(setting), (TaskType)TaskType.FCS_ARCHIVE_SERVICE);
                        continue;
                    }
                    int liveTimeHour = setting.getInt("livetime");
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(10, -1 * liveTimeHour);
                    List<DynamicObject> recordList = this.loadProcessingRecord(setting.getLong("id"));
                    if (recordList.size() > 1) {
                        for (DynamicObject record : recordList) {
                            record.set("archivestatus", (Object)ArchiveStatusEnum.FAIL.getValue());
                        }
                    } else if (recordList.size() == 1) {
                        ArchiveResult result;
                        DynamicObject record = recordList.get(0);
                        Date heartbeatTime = record.getDate("heartbeattime");
                        if (calendar.getTime().compareTo(heartbeatTime) > 0) {
                            record.set("archivestatus", (Object)ArchiveStatusEnum.FAIL.getValue());
                            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                            ThreadService.execute((Runnable)new ArchiveTask(setting), (TaskType)TaskType.FCS_ARCHIVE_SERVICE);
                            result = new ArchiveResult();
                            result.setStatusCode(RpcResultStatusCode.SUCCESS);
                            result.setArchiveSettingId(setting.getLong("id"));
                            resultList.add(result);
                        } else {
                            result = new ArchiveResult();
                            result.setStatusCode(RpcResultStatusCode.ERROR);
                            String errMsg = ResManager.loadKDString((String)"\u5f52\u6863\u6267\u884c\u5931\u8d25, \u6709\u6b63\u5728\u8fd0\u884c\u7684\u5f52\u6863\u4efb\u52a1\u3002", (String)"ArchiveService_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]);
                            result.setMessage(errMsg);
                            result.setArchiveSettingId(setting.getLong("id"));
                            resultList.add(result);
                        }
                    } else {
                        ThreadService.execute((Runnable)new ArchiveTask(setting), (TaskType)TaskType.FCS_ARCHIVE_SERVICE);
                        ArchiveResult result = new ArchiveResult();
                        result.setStatusCode(RpcResultStatusCode.SUCCESS);
                        resultList.add(result);
                    }
                    if (!setting.getBoolean("archivedel")) continue;
                    ThreadService.execute((Runnable)new DeleteArchiveTask(setting), (TaskType)TaskType.FCS_ARCHIVE_SERVICE);
                }
            }
            finally {
                serviceLock.unlock();
            }
        }
        return resultList;
    }

    private List<DynamicObject> loadProcessingRecord(Long settingId) {
        QFilter statusFilter = new QFilter("archivestatus", "=", (Object)ArchiveStatusEnum.PROCESSING.getValue());
        QFilter settingFilter = new QFilter("item.id", "=", (Object)settingId);
        String selectProps = String.join((CharSequence)",", "archivestatus", "heartbeattime");
        DynamicObject[] processingRecArr = TmcDataServiceHelper.load((String)"fcs_archiverecord", (String)selectProps, (QFilter[])new QFilter[]{statusFilter, settingFilter});
        return processingRecArr.length > 0 ? Arrays.asList(processingRecArr) : Collections.emptyList();
    }

    private List<DynamicObject> loadArchiveSetting() {
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("enable", "=", (Object)"1")};
        String selectProp = String.join((CharSequence)",", "srctype", "srctype.number", "archivetype", "id", "srctype.id", "archivetype.id", "archivetype.number", "timeprop", "day", "livetime", "archivefilter", "archivefilter_TAG", "archiveliveday", "archivemincnt", "archivedel", "onlydelete");
        DynamicObjectCollection settingArr = QueryServiceHelper.query((String)"fcs_archivesetting", (String)selectProp, (QFilter[])filters);
        return settingArr;
    }
}

