/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.archive.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fcs.mservice.archive.impl.ArchiveDataTransfer;
import kd.tmc.fcs.mservice.archive.impl.ArchiveProgressHandler;

public class ArchiveTask
implements Runnable {
    private static final int ARCHIVE_DATA_LIMIT = 1000;
    private final DynamicObject setting;
    private final ArchiveDataTransfer dataTransfer;
    private final ArchiveProgressHandler progressHandler;

    public ArchiveTask(DynamicObject setting) {
        this.setting = setting;
        this.dataTransfer = new ArchiveDataTransfer(setting);
        this.progressHandler = new ArchiveProgressHandler(setting, null);
    }

    @Override
    public void run() {
        block16: {
            Exception exception;
            this.progressHandler.start();
            while (true) {
                List<DynamicObject> dataList;
                if (CollectionUtils.isEmpty(dataList = this.getData())) {
                    this.progressHandler.finish();
                    break block16;
                }
                exception = null;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        List<DynamicObject> archiveData = this.dataTransfer.transfer(dataList);
                        SaveServiceHelper.save((DynamicObject[])archiveData.toArray(new DynamicObject[archiveData.size()]));
                        Object[] idArr = dataList.stream().map(DataEntityBase::getPkValue).toArray();
                        DeleteServiceHelper.delete((IDataEntityType)dataList.get(0).getDataEntityType(), (Object[])idArr);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        exception = e;
                    }
                }
                if (exception != null) break;
                this.progressHandler.updateProgress(dataList.size());
            }
            this.progressHandler.fail(exception);
        }
    }

    private List<DynamicObject> getData() {
        String srcType = this.setting.getString("srctype.id");
        DynamicObjectCollection dataIdArr = QueryServiceHelper.query((String)srcType, (String)"id", (QFilter[])this.getFilter(), null, (int)1000);
        if (dataIdArr.size() > 0) {
            Object[] idArr = dataIdArr.stream().map(s -> s.get("id")).toArray();
            DynamicObject[] dataArr = TmcDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)srcType));
            return Arrays.asList(dataArr);
        }
        return Collections.emptyList();
    }

    private QFilter[] getFilter() {
        String archiveFilterTag;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        String timeProp = this.setting.getString("timeprop");
        Date archiveEndDate = this.getArchiveEndTime();
        if (archiveEndDate != null) {
            QFilter timeFilter = new QFilter(timeProp, "<", (Object)archiveEndDate);
            filterList.add(timeFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(archiveFilterTag = this.setting.getString("archivefilter_TAG")))) {
            String srcType = this.setting.getString("srctype.id");
            FilterCondition filter = (FilterCondition)SerializationUtils.fromJsonString((String)archiveFilterTag, FilterCondition.class);
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)srcType);
            FilterBuilder fb = new FilterBuilder(dataType, filter, true);
            fb.buildFilter(true);
            QFilter archiveFilter = fb.getQFilter();
            filterList.add(archiveFilter);
        }
        return filterList.toArray(new QFilter[0]);
    }

    private Date getArchiveEndTime() {
        Date archiveEndDate = null;
        int archiveDay = this.setting.getInt("day");
        if (archiveDay != -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1 * archiveDay);
            archiveEndDate = calendar.getTime();
        }
        return archiveEndDate;
    }
}

