/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.archive.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class DeleteArchiveTask
implements Runnable {
    private final DynamicObject setting;
    private static final int ARCHIVE_DATA_LIMIT = 1000;

    public DeleteArchiveTask(DynamicObject setting) {
        this.setting = setting;
    }

    @Override
    public void run() {
        int liveDay = this.setting.getInt("archiveliveday");
        if (liveDay > 0) {
            List<DynamicObject> data;
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -liveDay);
            while (!CollectionUtils.isEmpty(data = this.getData(calendar))) {
                String delEntityKey = this.setting.getBoolean("onlydelete") ? "srctype.number" : "archivetype.number";
                String delEntity = this.setting.getString(delEntityKey);
                Object[] ids = data.stream().map(s -> s.getLong("id")).toArray();
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)delEntity), (Object[])ids);
            }
        }
    }

    private List<DynamicObject> getData(Calendar calendar) {
        String delEntityKey;
        QFilter qFilter;
        boolean onlyDel = this.setting.getBoolean("onlydelete");
        if (onlyDel) {
            qFilter = new QFilter(this.setting.getString("timeprop"), "<", (Object)calendar.getTime());
            delEntityKey = "srctype.number";
        } else {
            qFilter = new QFilter("createtime", "<", (Object)calendar.getTime());
            delEntityKey = "archivetype.number";
        }
        String delEntity = this.setting.getString(delEntityKey);
        DynamicObjectCollection idCollection = QueryServiceHelper.query((String)delEntity, (String)"id", (QFilter[])qFilter.toArray(), null, (int)1000);
        if (idCollection.size() > 0) {
            return idCollection;
        }
        return Collections.emptyList();
    }
}

