/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.gpt;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateFormatUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcGptReportAnlsAction
extends AbstractReportFormPlugin
implements IGPTFormAction {
    private static Log logger = LogFactory.getLog(TmcGptReportAnlsAction.class);
    public static final String TEXT = "text";
    public static final String AMOUNT = "amount";

    public Map<String, String> invokeAction(String pageId, String action, Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        String entityId = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        if ("GET_DATA".equalsIgnoreCase(action) && EmptyUtil.isEmpty((String)entityId)) {
            ReportList billList = (ReportList)formView.getControl("reportlistap");
            int rowCount = billList.getReportModel().getRowCount();
            ArrayList dataList = new ArrayList(rowCount);
            for (int index = 1; index < rowCount; ++index) {
                List columnList = billList.getColumns();
                HashMap<String, String> rowData = new HashMap<String, String>();
                for (AbstractReportColumn column : columnList) {
                    if (!(column instanceof ReportColumn)) continue;
                    String field = column.getCaption().getLocaleValue();
                    String fieldType = ((ReportColumn)column).getFieldType();
                    Object cell = billList.getReportModel().getValue(index, ((ReportColumn)column).getFieldKey());
                    if (!EmptyUtil.isNoEmpty((Object)cell)) continue;
                    rowData.put(field, this.getFieldValue(fieldType, cell, 2));
                }
                dataList.add(rowData);
            }
            String data = SerializationUtils.toJsonString(dataList);
            Map<String, String> filterMap = this.getFilterMap(formView);
            result.put("title", EntityMetadataCache.getDataEntityType((String)formView.getFormShowParameter().getFormId()).getDisplayName().getLocaleValue());
            result.put("data", data);
            logger.info("title = " + (String)result.get("title"));
            logger.info("data = " + (String)result.get("data"));
        }
        return result;
    }

    private Map<String, String> getFilterMap(IFormView formView) {
        HashMap<String, String> filterMap = new HashMap<String, String>(16);
        ReportQueryParam param = ((IReportView)formView).getQueryParam();
        FilterInfo filterInfo = param.getFilter();
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (filterInfo == null) {
            return filterMap;
        }
        List items = filterInfo.getFilterItems();
        for (FilterItemInfo item : items) {
            String propName = item.getPropName();
            DynamicProperty prop = entityType.getProperty(propName);
            if (prop == null) continue;
            this.setMapInfo(item, prop, filterMap);
        }
        return filterMap;
    }

    private void setMapInfo(FilterItemInfo item, DynamicProperty prop, Map<String, String> filterMap) {
        Object val = item.getValue();
        if (val == null) {
            return;
        }
        StringBuilder var = new StringBuilder();
        if (prop instanceof MulBasedataProp && val instanceof Collection) {
            Collection coll = (Collection)val;
            for (Object v : coll) {
                if (!(v instanceof DynamicObject)) continue;
                var.append(((DynamicObject)v).getString("name")).append(";");
            }
        } else if (prop instanceof DateTimeProp && val instanceof Date) {
            var = new StringBuilder(KDDateFormatUtils.getDateFormat().format((Date)val));
        } else if (prop instanceof BasedataProp) {
            DynamicObject obj = (DynamicObject)val;
            var = new StringBuilder(obj.getString("name"));
        } else {
            var = prop instanceof ComboProp ? new StringBuilder(((ComboProp)prop).getItemByName(val.toString())) : (prop instanceof BooleanProp ? new StringBuilder("1".equals(val.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"TmcGptReportAnlsAction_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TmcGptReportAnlsAction_1", (String)"tmc-fcs-mservice", (Object[])new Object[0])) : new StringBuilder(val.toString()));
        }
        filterMap.put(prop.getDisplayName().getLocaleValue(), var.toString());
    }

    private String getFieldValue(String fieldType, Object value, int precision) {
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getString("name");
        }
        if (TEXT.equals(fieldType)) {
            return (String)value;
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof BigDecimal) {
            if (AMOUNT.equals(fieldType)) {
                return ((BigDecimal)value).setScale(precision, 4).toPlainString();
            }
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.format((Date)value);
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        return SerializationUtils.toJsonString((Object)value);
    }
}

