/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.inspect;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fcs.mservice.repeat.PayAccessRepeatCtrlServiceImpl;

public class TransDetailInspectService {
    private static Log logger = LogFactory.getLog(PayAccessRepeatCtrlServiceImpl.class);

    public void queryTransDetail(Long bankAcctId, Long currencyId, Date bizDate) {
        Long startTime = System.currentTimeMillis();
        logger.info("------queryTransDetail Begin------");
        DetailQueryInfo queryInfo = new DetailQueryInfo();
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)bankAcctId, (String)"bd_accountbanks");
        queryInfo.setBankAcct(bankAcct);
        queryInfo.setIdList(Collections.singletonList(bankAcct.getLong("id")));
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        queryInfo.setCurr(currency);
        queryInfo.setOrgId(Long.valueOf(TmcAccountHelper.getCreateOrgByBankAcct((DynamicObject)bankAcct)));
        queryInfo.setBeginDate(bizDate);
        queryInfo.setEndDate(bizDate);
        queryInfo.setAsyncTask(false);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"ebService", (String)"downTransDetails", (Object[])new Object[]{queryInfo});
        Long endTime = System.currentTimeMillis();
        logger.info("------queryTransDetail End; time = " + (endTime - startTime) / 1000L + "s------");
    }

    public void executeInspectBillMatch(List billIds, String targetEntity) {
        Long startTime = System.currentTimeMillis();
        logger.info("------executeInspectBillMatch Begin------");
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"suspectRepeatService", (String)"suspectRepeatGen", (Object[])new Object[]{targetEntity, billIds, null, "bei_transdetail"});
        Long endTime = System.currentTimeMillis();
        logger.info("------executeInspectBillMatch End; time = " + (endTime - startTime) / 1000L + "s------");
    }
}

