/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.payaccess;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.PayLog;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.bean.RepeatCtrlLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.PayAccessCheckEnum;
import kd.tmc.fcs.common.helper.PayAccessHelper;
import kd.tmc.fcs.mservice.payaccess.PayAccessCheckResult;
import kd.tmc.fcs.mservice.repeat.PayAccessRepeatCtrlServiceImpl;

public class PayAccessCheckServiceImpl {
    private static final Log logger = LogFactory.getLog(PayAccessCheckServiceImpl.class);
    private RepeatCtrlLog accessLog;

    public Map<Object, String> checkPayAccess(DynamicObject[] bills, Map<String, String> variables, boolean isFullNodeCtrl, boolean isBlackList) {
        HashMap<Object, String> result = new HashMap<Object, String>();
        Map botpMaps = PayAccessHelper.getBotpInfos((DynamicObject[])bills);
        HashMap<String, String> srcEntitySet = new HashMap<String, String>();
        for (DynamicObject bill : bills) {
            String srcEntity;
            Object id = bill.getPkValue();
            Map botpMap = (Map)botpMaps.get(id);
            Map lKInfo = (Map)botpMap.get("lkinfo");
            if (lKInfo != null && srcEntitySet.containsKey(srcEntity = (String)lKInfo.get("srcEntityNumber"))) {
                PayAccessCheckResult checkPayAccess = new PayAccessCheckResult(srcEntity, (String)srcEntitySet.get(srcEntity));
                result.put(bill.getPkValue(), JSON.toJSONString((Object)checkPayAccess));
                continue;
            }
            PayAccessCheckResult checkPayAccess = this.checkPayAccess(bill, botpMap, variables, isFullNodeCtrl, isBlackList);
            result.put(bill.getPkValue(), JSON.toJSONString((Object)checkPayAccess));
            srcEntitySet.put(checkPayAccess.getSrcEntity(), checkPayAccess.getCheckResult());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayAccessCheckResult checkPayAccess(DynamicObject bill, Map<String, Object> botpMap, Map<String, String> variables, boolean isFullNodeCtrl, boolean isBlackList) {
        long time = System.nanoTime();
        this.accessLog = this.createRepeatLog(bill, "payaccess");
        PayAccessCheckResult result = new PayAccessCheckResult();
        try {
            result.setDestEntity(bill.getDynamicObjectType().getName());
            boolean isBotp = (Boolean)botpMap.get("isBotp");
            logger.info("variables:{" + variables.keySet() + "->" + variables.values() + "}");
            if (!isBotp) {
                if (variables.containsKey("importtag_of_datasource") || variables.containsKey("importtype") || variables.containsKey("openApiNew")) {
                    result.setCheckResult(PayAccessCheckEnum.NO_REPEAT.getValue());
                    PayAccessCheckResult payAccessCheckResult = result;
                    return payAccessCheckResult;
                }
                String newParam = PayAccessHelper.getPayaccessNewParam();
                String[] split = newParam.split(";");
                for (String setKey : variables.keySet()) {
                    for (String s : split) {
                        if (!setKey.contains(s)) continue;
                        result.setCheckResult(PayAccessCheckEnum.NO_REPEAT.getValue());
                        PayAccessCheckResult payAccessCheckResult = result;
                        return payAccessCheckResult;
                    }
                }
            }
            if (isBotp) {
                result.setSrcEntity((String)((Map)botpMap.get("lkinfo")).get("srcEntityNumber"));
                result.setCheckResult(this.checkCanPush(botpMap, bill, isFullNodeCtrl, isBlackList));
            } else {
                result.setCheckResult(this.noBotpCreateBill(result, bill, variables, isFullNodeCtrl, isBlackList));
            }
        }
        catch (Exception e) {
            String exceptionStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            this.accessLog.setException(exceptionStr);
            if (e instanceof KDBizException) {
                throw e;
            }
            result.setCheckResult(PayAccessCheckEnum.PASS.getValue());
        }
        finally {
            if (EmptyUtil.isNoEmpty((String)this.accessLog.getException())) {
                this.saveLog(this.accessLog, time);
            }
        }
        return result;
    }

    private String checkCanPush(Map<String, Object> botpMap, DynamicObject bill, boolean isFullNodeCtrl, boolean isBlackList) {
        Map linkMaps = (Map)botpMap.get("lkinfo");
        if (linkMaps != null && !linkMaps.isEmpty()) {
            String srcEntity = (String)linkMaps.get("srcEntityNumber");
            return this.queryPayAccessData(bill, srcEntity, "1", isFullNodeCtrl, isBlackList);
        }
        return PayAccessCheckEnum.NO_REPEAT.getValue();
    }

    private String noBotpCreateBill(PayAccessCheckResult result, DynamicObject bill, Map<String, String> variables, boolean isFullNodeCtrl, boolean isBlackList) {
        if (variables.containsKey("customsign")) {
            return this.customSignCreateBill(result, bill, variables, isFullNodeCtrl, isBlackList);
        }
        return this.codeCreateBill(result, bill, variables, isFullNodeCtrl, isBlackList);
    }

    private String codeCreateBill(PayAccessCheckResult result, DynamicObject bill, Map<String, String> variables, boolean isFullNodeCtrl, boolean isBlackList) {
        if (!variables.containsKey("srcEntityNumber")) {
            Object destField;
            String destLkPkField;
            boolean isInBlackList = PayAccessHelper.isInBlackList((String)bill.getDynamicObjectType().getName());
            Map<Object, DynamicObject> payAccessData = this.getPayAccessData(bill);
            if (isInBlackList && !payAccessData.isEmpty() && (destLkPkField = payAccessData.values().iterator().next().getString("destlkpkfield")) != null && bill.getDynamicObjectType().getProperties().containsKey((Object)destLkPkField) && EmptyUtil.isNoEmpty((Object)(destField = bill.get(destLkPkField)))) {
                DynamicObject record = PayAccessHelper.getPayAccessRecord((Long)bill.getLong("id"));
                if (EmptyUtil.isNoEmpty((DynamicObject)record)) {
                    return PayAccessCheckEnum.NO_REPEAT.getValue();
                }
                String message = ResManager.loadKDString((String)"\u672a\u4f20\u5165\u6e90\u5355\u5b9e\u4f53\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PayaccessCheckService_2", (String)"tmc-fcs-mservice", (Object[])new Object[0]);
                this.accessLog.setException(message);
                logger.info("message====" + message);
                return message;
            }
            boolean existsBase = TmcDataServiceHelper.exists((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
            if (!existsBase && isInBlackList) {
                boolean isApiPass = PayAccessHelper.isApiPass();
                if (isApiPass) {
                    return PayAccessCheckEnum.NO_REPEAT.getValue();
                }
                DynamicObject destEntity = PayAccessHelper.getMainEntityInfo((String)bill.getDynamicObjectType().getName());
                String message = ResManager.loadKDString((String)"\u751f\u6210\u3010%s\u3011\u9700\u8981\u8fdb\u884c\u652f\u4ed8\u51c6\u5165\u6ce8\u518c\uff0c\u672a\u8fdb\u884c\u652f\u4ed8\u51c6\u5165\u6ce8\u518c\u65f6\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8d44\u91d1\u4e1a\u52a1\u5355\u636e\u3002", (String)"PayaccessCheckService_5", (String)"tmc-fcs-mservice", (Object[])new Object[]{destEntity.getString("name")});
                this.accessLog.setException(message);
                logger.info("message====" + message);
                return message;
            }
        } else {
            String srcEntityNumber = variables.get("srcEntityNumber");
            result.setSrcEntity(srcEntityNumber);
            return this.queryPayAccessData(bill, srcEntityNumber, "0", isFullNodeCtrl, isBlackList);
        }
        return PayAccessCheckEnum.NO_REPEAT.getValue();
    }

    private String queryPayAccessData(DynamicObject bill, String entityNumber, String isBotpAdd, boolean isFullNodeCtrl, boolean isBlackList) {
        this.saveBillTypeLog(this.accessLog, entityNumber);
        QFilter filter = new QFilter("srcentity.number", "=", (Object)entityNumber);
        String destNumber = bill.getDynamicObjectType().getName();
        filter.and("destentity.number", "=", (Object)destNumber);
        filter.and("isbotpadd", "=", (Object)isBotpAdd);
        filter.and("enable", "=", (Object)"1");
        logger.info("filter====" + filter);
        DynamicObject payAccess = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess", (String)"id,name", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)payAccess)) {
            if (!isFullNodeCtrl && !isBlackList) {
                logger.info("\u652f\u4ed8\u8282\u70b9\uff0c\u76ee\u6807\u5355\u4e0d\u5728\u9ed1\u540d\u5355\u5185,\u4e0d\u8d70\u4fdd\u5b58\u94fe\u8def\u903b\u8f91\u3002");
                return PayAccessCheckEnum.NO_REPEAT.getValue();
            }
            String message = !isFullNodeCtrl ? ResManager.loadKDString((String)"\u3010%1$s -> %2$s\u3011\u652f\u4ed8\u8282\u70b9\u9700\u8981\u8fdb\u884c\u652f\u4ed8\u51c6\u5165\u6ce8\u518c\uff0c\u672a\u8fdb\u884c\u652f\u4ed8\u51c6\u5165\u6ce8\u518c\u65f6\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8d44\u91d1\u4e1a\u52a1\u5355\u636e\u3002", (String)"PayaccessCheckService_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u3010%1$s -> %2$s\u3011\u5168\u94fe\u8def\u9700\u8981\u8fdb\u884c\u652f\u4ed8\u51c6\u5165\u6ce8\u518c\uff0c\u672a\u8fdb\u884c\u652f\u4ed8\u51c6\u5165\u6ce8\u518c\u65f6\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8d44\u91d1\u4e1a\u52a1\u5355\u636e\u3002", (String)"PayaccessCheckService_3", (String)"tmc-fcs-mservice", (Object[])new Object[0]);
            DynamicObject srcEntity = PayAccessHelper.getMainEntityInfo((String)entityNumber);
            DynamicObject destEntity = PayAccessHelper.getMainEntityInfo((String)destNumber);
            message = String.format(message, EmptyUtil.isEmpty((DynamicObject)srcEntity) ? entityNumber : srcEntity.getString("name"), EmptyUtil.isEmpty((DynamicObject)destEntity) ? destNumber : destEntity.getString("name"));
            logger.info("message====" + message);
            this.accessLog.setException(message);
            return message;
        }
        return this.queryCheckCtrl(payAccess.getPkValue(), payAccess.getString("name"));
    }

    private Map<Object, DynamicObject> getPayAccessData(DynamicObject bill) {
        QFilter filter = new QFilter("destentity.number", "=", (Object)bill.getDynamicObjectType().getName());
        filter.and("isbotpadd", "=", (Object)"0");
        filter.and("iscustomentity", "=", (Object)"0");
        filter.and("enable", "=", (Object)"1");
        return TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess", (QFilter[])filter.toArray());
    }

    private String queryCheckCtrl(Object pkValue, String name) {
        boolean isWhiteList = PayAccessHelper.isInWhiteList((Object)pkValue);
        if (isWhiteList) {
            return PayAccessCheckEnum.PASS.getValue();
        }
        QFilter qFilter = new QFilter("payaccess", "=", pkValue);
        qFilter.and("enable", "=", (Object)"1");
        if (!TmcDataServiceHelper.exists((String)"fcs_checkctrl", (QFilter[])qFilter.toArray())) {
            String message = ResManager.loadKDString((String)"\u3010%s\u3011\u652f\u4ed8\u51c6\u5165\u5fc5\u987b\u7ed1\u5b9a\u9632\u91cd\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayaccessCheckService_4", (String)"tmc-fcs-mservice", (Object[])new Object[]{name});
            this.accessLog.setException(message);
            logger.info("message====" + message);
            return message;
        }
        return PayAccessCheckEnum.PASS.getValue();
    }

    private String customSignCreateBill(PayAccessCheckResult result, DynamicObject bill, Map<String, String> variables, boolean isFullNodeCtrl, boolean isBlackList) {
        String customSign = variables.get("customsign");
        result.setSrcEntity(customSign);
        QFilter filter = new QFilter("customsign", "=", (Object)customSign);
        filter.and("destentity.number", "=", (Object)bill.getDynamicObjectType().getName());
        filter.and("enable", "=", (Object)"1");
        DynamicObject payAccess = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess", (String)"id,number", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)payAccess)) {
            if (!isFullNodeCtrl && !isBlackList) {
                logger.info("\u652f\u4ed8\u8282\u70b9\uff0c\u76ee\u6807\u5355\u4e0d\u5728\u9ed1\u540d\u5355\u5185,\u4e0d\u8d70\u4fdd\u5b58\u94fe\u8def\u903b\u8f91\u3002");
                return PayAccessCheckEnum.NO_REPEAT.getValue();
            }
            String message = ResManager.loadKDString((String)"\u652f\u4ed8\u51c6\u5165\u4e2d\u81ea\u5b9a\u4e49\u5b9e\u4f53\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u64cd\u4f5c\u3002", (String)"PayaccessCheckService_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]);
            this.accessLog.setException(message);
            logger.info("message====" + message);
            return message;
        }
        return this.queryCheckCtrl(payAccess.getPkValue(), payAccess.getString("number"));
    }

    private RepeatCtrlLog createRepeatLog(DynamicObject destBill, String logType) {
        RepeatCtrlLog ctrlLog = new RepeatCtrlLog();
        ctrlLog.setDestBillId(Long.valueOf(destBill.getLong("id")));
        ctrlLog.setDestBillType(destBill.getDynamicObjectType().getName());
        ctrlLog.setLogType(logType);
        ctrlLog.setTime(System.currentTimeMillis());
        ctrlLog.setTraceId(String.valueOf(RequestContext.get().getTraceId()));
        return ctrlLog;
    }

    private void saveLog(RepeatCtrlLog ctrlLog, Long time) {
        PayLogger Logger2 = PayLogger.create(PayAccessRepeatCtrlServiceImpl.class);
        long costMs = (System.nanoTime() - time) / 1000L / 1000L;
        ctrlLog.setCostTime(Long.valueOf(costMs));
        Logger2.log((PayLog)ctrlLog);
    }

    private void saveBillTypeLog(RepeatCtrlLog ctrlLog, String srcEntityNumber) {
        ctrlLog.setSourceBillType(srcEntityNumber);
    }
}

