/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.payaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.PayLog;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.bean.RepeatCtrlLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.NewWayEnum;
import kd.tmc.fcs.common.helper.PayAccessHelper;
import kd.tmc.fcs.mservice.repeat.PayAccessRepeatCtrlServiceImpl;

public class PayAccessModifyServiceImpl {
    private static final Log logger = LogFactory.getLog(PayAccessModifyServiceImpl.class);
    private RepeatCtrlLog accessLog;
    private final List<DynamicObject> recordList = new ArrayList<DynamicObject>(16);

    public void deletePayAccess(Set<Object> idSet) {
        QFilter qFilter = new QFilter("destbillpkid", "in", idSet);
        DeleteServiceHelper.delete((String)"fcs_payaccess_record", (QFilter[])qFilter.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePayAccess(DynamicObject[] bills, Map<String, String> variables) {
        Map payRecordIdList = (Map)PayAccessHelper.getPayAccessRecordByDestBills((DynamicObject[])bills).getLeft();
        boolean isFullNodeCtrl = PayAccessHelper.isFullNodeCtrl();
        for (DynamicObject bill : bills) {
            if (payRecordIdList.containsKey(bill.getLong("id"))) continue;
            long time = System.nanoTime();
            this.accessLog = this.createRepeatLog(bill, "accessrecord");
            try {
                this.saveOrSubmitDeal(bill, variables, isFullNodeCtrl);
            }
            catch (Exception e) {
                String exceptionStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                this.accessLog.setException(exceptionStr);
                if (!(e instanceof KDBizException)) continue;
                throw (KDBizException)e;
            }
            finally {
                this.saveLog(this.accessLog, time);
            }
        }
        if (EmptyUtil.isNoEmpty(this.recordList)) {
            SaveServiceHelper.save((DynamicObject[])this.recordList.toArray(new DynamicObject[0]));
        }
    }

    private void saveOrSubmitDeal(DynamicObject bill, Map<String, String> variables, boolean isFullNodeCtrl) throws Exception {
        Map botpMap = PayAccessHelper.getBotpInfo((DynamicObject)bill);
        boolean isBotp = (Boolean)botpMap.get("isBotp");
        if (!isBotp && (variables.containsKey("importtag_of_datasource") || variables.containsKey("importtype"))) {
            return;
        }
        if (isBotp) {
            this.recordLingInfoByBotp(botpMap, bill);
        } else {
            this.noBotpCreateBill(bill, variables, isFullNodeCtrl);
        }
    }

    private void recordLingInfoByBotp(Map<String, Object> botpMap, DynamicObject bill) throws Exception {
        Map linkMaps = (Map)botpMap.get("lkinfo");
        for (Map.Entry linkMap : linkMaps.entrySet()) {
            String linkProp = (String)linkMap.getKey();
            if ("entryName".equals(linkProp) || "srcEntityNumber".equals(linkProp)) continue;
            String entryName = (String)linkMaps.get("entryName");
            List linkLists = (List)linkMap.getValue();
            Map<Object, Object> loopOneMap = new HashMap(16);
            Map<Object, Object> fullLinkMap = new HashMap(16);
            for (DynamicObject link : linkLists) {
                if (!link.getDynamicObjectType().getProperties().containsKey((Object)(linkProp + "_sbillid"))) continue;
                Long srcBillId = link.getLong(linkProp + "_sbillid");
                Long sid = link.getLong(linkProp + "_sid");
                String srcEntityNumber = (String)linkMaps.get("srcEntityNumber");
                String destEntityNumber = bill.getDynamicObjectType().getName();
                if (loopOneMap.isEmpty()) {
                    loopOneMap = this.getEntryKeyMap(srcEntityNumber, destEntityNumber, entryName, linkProp, srcBillId, sid);
                }
                String sourceEntryKey = (String)loopOneMap.get("sourceEntryKey");
                String targetEntryKey = (String)loopOneMap.get("targetEntryKey");
                Object destId = ((DynamicObject)link.getParent()).getPkValue();
                this.saveBillTypeLog(this.accessLog, srcEntityNumber, destEntityNumber, srcBillId);
                String srcBillIdStr = String.valueOf(srcBillId);
                DynamicObject record = TmcDataServiceHelper.newDynamicObject((String)"fcs_payaccess_record");
                record.set("srcentity", (Object)srcEntityNumber);
                record.set("destentity", (Object)destEntityNumber);
                record.set("srcidprop", (Object)(srcEntityNumber.equals(sourceEntryKey) ? "head" : "entry"));
                record.set("srcentryprop", (Object)sourceEntryKey);
                record.set("destentryprop", (Object)targetEntryKey);
                record.set("srcbillid", (Object)String.valueOf(sid));
                record.set("srcbillpkid", (Object)srcBillIdStr);
                record.set("destbillid", destId);
                record.set("destbillpkid", bill.getPkValue());
                record.set("destidprop", (Object)(destEntityNumber.equals(targetEntryKey) ? "head" : "entry"));
                record.set("newway", (Object)NewWayEnum.BOTP.getValue());
                if (fullLinkMap.isEmpty() || !fullLinkMap.containsKey(srcBillIdStr)) {
                    fullLinkMap = this.getFullLinkInfo(srcBillIdStr, bill.getPkValue());
                }
                record.set("batchno", (Object)fullLinkMap.getOrDefault("batchno", DBServiceHelper.genStringId()));
                record.set("fulllinkid", fullLinkMap.get(srcBillIdStr));
                this.recordList.add(record);
            }
        }
    }

    private Map<String, String> getEntryKeyMap(String srcEntityNumber, String destEntityNumber, String entryName, String linkProp, Long srcBillId, Long sid) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        String sourceEntryKey = null;
        String targetEntryKey = null;
        List rules = ConvertRuleCache.loadRules((String)srcEntityNumber, (String)destEntityNumber);
        HashSet<String> srcEntrySet = new HashSet<String>(16);
        if (EmptyUtil.isNoEmpty((Object)rules)) {
            rules = rules.stream().filter(ConvertRuleElement::isEnabled).collect(Collectors.toList());
            for (ConvertRuleElement rule : rules) {
                sourceEntryKey = rule.getLinkEntityPolicy().getSourceEntryKey();
                targetEntryKey = rule.getLinkEntityPolicy().getTargetEntryKey();
                if (sourceEntryKey.equals(srcEntityNumber)) continue;
                srcEntrySet.add(sourceEntryKey);
            }
            if (rules.size() > 1) {
                logger.info("{ srcBillId: " + srcBillId + ";sid: " + sid + " }");
                if (srcBillId.equals(sid)) {
                    sourceEntryKey = srcEntityNumber;
                } else {
                    boolean isExist = false;
                    for (String srcEntry : srcEntrySet) {
                        QFilter qFilter = new QFilter(srcEntry + ".id", "=", (Object)sid);
                        logger.info("srcEntry:" + srcEntry);
                        boolean exists = TmcDataServiceHelper.exists((String)srcEntityNumber, (QFilter[])qFilter.toArray());
                        if (!exists) continue;
                        isExist = true;
                        sourceEntryKey = srcEntry;
                        break;
                    }
                    if (!isExist) {
                        throw new Exception(ResManager.loadKDString((String)"\u6e90\u5355\u6570\u636e\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u5206\u5f55\uff0c\u4e8b\u52a1\u672a\u63d0\u4ea4\u3002", (String)"PayAccessModifyServiceImpl_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    }
                }
                logger.info("\u5173\u8054\u5c5e\u6027:" + linkProp);
                targetEntryKey = "billhead_lk".equals(linkProp) ? destEntityNumber : entryName;
            }
        }
        returnMap.put("sourceEntryKey", sourceEntryKey);
        returnMap.put("targetEntryKey", targetEntryKey);
        return returnMap;
    }

    private Map<String, String> getFullLinkInfo(String srcBillId, Object pkValue) {
        HashMap<String, String> fullLinkMap = new HashMap<String, String>(16);
        QFilter filter = new QFilter("destbillpkid", "=", (Object)Long.parseLong(srcBillId));
        Map recordMap = TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (QFilter[])filter.toArray());
        if (!recordMap.isEmpty()) {
            Iterator iterator = recordMap.values().iterator();
            DynamicObject next = (DynamicObject)iterator.next();
            String fullLinkId = next.getString("fulllinkid");
            if (EmptyUtil.isNoEmpty((String)fullLinkId)) {
                String batchNo = next.getString("batchno");
                fullLinkMap.put("batchno", batchNo);
                fullLinkMap.put(srcBillId, fullLinkId + "," + pkValue);
            } else {
                fullLinkMap.put(srcBillId, srcBillId + "," + pkValue);
            }
        } else {
            fullLinkMap.put(srcBillId, srcBillId + "," + pkValue);
        }
        return fullLinkMap;
    }

    private void noBotpCreateBill(DynamicObject bill, Map<String, String> variables, boolean isFullNodeCtrl) {
        if (variables.containsKey("customsign")) {
            this.recordLingInfo(bill, variables, true, false);
        } else {
            this.recordLingInfo(bill, variables, false, isFullNodeCtrl);
        }
    }

    private void recordLingInfo(DynamicObject bill, Map<String, String> variables, boolean isCustom, boolean isFullNodeCtrl) {
        String srcEntityNumber;
        String destEntityNumber = bill.getDynamicObjectType().getName();
        String string = srcEntityNumber = isCustom ? variables.get("customsign") : variables.get("srcEntityNumber");
        if (EmptyUtil.isNoEmpty((String)srcEntityNumber)) {
            String newWay;
            QFilter filter = new QFilter("destentity.number", "=", (Object)destEntityNumber);
            filter.and("enable", "=", (Object)"1");
            QFilter repeatFilter = new QFilter("ctrlentity", "=", (Object)destEntityNumber);
            if (isCustom) {
                filter.and("customsign", "=", (Object)srcEntityNumber);
                filter.and("iscustomentity", "=", (Object)"1");
                newWay = NewWayEnum.CUSTOM.getValue();
                repeatFilter.and("customsign", "=", (Object)srcEntityNumber);
            } else {
                filter.and("srcentity.number", "=", (Object)srcEntityNumber);
                filter.and("isbotpadd", "=", (Object)"0");
                newWay = NewWayEnum.CODE.getValue();
                repeatFilter.and("srcentity", "=", (Object)srcEntityNumber);
            }
            repeatFilter.and("enable", "=", (Object)"1");
            DynamicObject repeatSet = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_checkctrl", (QFilter[])new QFilter[]{repeatFilter});
            if (EmptyUtil.isEmpty((DynamicObject)repeatSet)) {
                logger.info("\u9632\u91cd\u8bbe\u7f6e\u4e0d\u5b58\u5728");
                return;
            }
            DynamicObject payAccess = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess", (QFilter[])filter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)payAccess)) {
                String srcBillId;
                String destLkPkField = payAccess.getString("destlkpkfield");
                if (!bill.getDataEntityType().getProperties().containsKey((Object)destLkPkField)) {
                    DynamicObject queryBill = TmcDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)destEntityNumber, (String)destLkPkField);
                    bill.set(destLkPkField, queryBill.get(destLkPkField));
                }
                try {
                    srcBillId = String.valueOf(bill.get(destLkPkField));
                }
                catch (Exception e) {
                    srcBillId = "0";
                }
                String destIdProp = "head";
                String targetEntryKey = bill.getDynamicObjectType().getName();
                HashSet<Long> idSet = new HashSet<Long>(16);
                Long destId = (Long)bill.getPkValue();
                String destLkField = payAccess.getString("destlkfield");
                if (destLkField.contains(".")) {
                    destIdProp = "entry";
                    targetEntryKey = destLkField.substring(0, destLkField.lastIndexOf("."));
                    DynamicObjectCollection collection = bill.getDynamicObjectCollection(targetEntryKey);
                    idSet.addAll(collection.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toSet()));
                } else {
                    idSet.add(destId);
                }
                this.saveBillTypeLog(this.accessLog, srcEntityNumber, destEntityNumber, srcBillId);
                Map<Object, Object> fullLinkMap = new HashMap(16);
                for (Long id : idSet) {
                    QFilter qFilter = new QFilter("destbillid", "=", (Object)id);
                    if (TmcDataServiceHelper.exists((String)"fcs_payaccess_record", (QFilter[])qFilter.toArray())) continue;
                    DynamicObject record = TmcDataServiceHelper.newDynamicObject((String)"fcs_payaccess_record");
                    record.set("srcentity", (Object)srcEntityNumber);
                    record.set("destentity", (Object)destEntityNumber);
                    record.set("srcidprop", (Object)("1".equals(payAccess.getString("srclkprop")) ? "head" : "entry"));
                    record.set("srcentryprop", (Object)srcEntityNumber);
                    record.set("destentryprop", (Object)targetEntryKey);
                    record.set("srcbillid", (Object)srcBillId);
                    record.set("srcbillpkid", (Object)srcBillId);
                    record.set("destbillid", (Object)id);
                    record.set("destbillpkid", bill.getPkValue());
                    record.set("destidprop", (Object)destIdProp);
                    record.set("newway", (Object)newWay);
                    if (PayAccessModifyServiceImpl.isLong(srcBillId) && (fullLinkMap.isEmpty() || !fullLinkMap.containsKey(srcBillId))) {
                        fullLinkMap = this.getFullLinkInfo(srcBillId, bill.getPkValue());
                        record.set("batchno", (Object)fullLinkMap.getOrDefault("batchno", DBServiceHelper.genStringId()));
                        record.set("fulllinkid", fullLinkMap.get(srcBillId));
                    }
                    this.recordList.add(record);
                }
            }
        }
    }

    private static boolean isLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private RepeatCtrlLog createRepeatLog(DynamicObject destBill, String logType) {
        RepeatCtrlLog ctrlLog = new RepeatCtrlLog();
        ctrlLog.setDestBillId(Long.valueOf(destBill.getLong("id")));
        ctrlLog.setDestBillType(destBill.getDynamicObjectType().getName());
        ctrlLog.setLogType(logType);
        ctrlLog.setTime(System.currentTimeMillis());
        ctrlLog.setTraceId(String.valueOf(RequestContext.get().getTraceId()));
        return ctrlLog;
    }

    private void saveBillTypeLog(RepeatCtrlLog ctrlLog, String srcEntityNumber, String destEntityNumber, Object srcBillId) {
        ctrlLog.setSourceBillType(srcEntityNumber);
        if (EmptyUtil.isNoEmpty((Object)srcBillId)) {
            ctrlLog.setSourceBillId(srcBillId.toString());
        }
    }

    private void saveLog(RepeatCtrlLog ctrlLog, Long time) {
        PayLogger Logger2 = PayLogger.create(PayAccessRepeatCtrlServiceImpl.class);
        long costMs = (System.nanoTime() - time) / 1000L / 1000L;
        ctrlLog.setCostTime(Long.valueOf(costMs));
        Logger2.log((PayLog)ctrlLog);
    }
}

