/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.payaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fcs.common.helper.PayAccessHelper;
import kd.tmc.fcs.mservice.payaccess.PayAccessCheckServiceImpl;
import kd.tmc.fcs.mservice.payaccess.PayAccessModifyServiceImpl;
import kd.tmc.fcs.mservice.repeat.PayAccessRepeatCtrlServiceImpl;

public class PayAccessService {
    private static final Log logger = LogFactory.getLog(PayAccessService.class);

    public Map<Object, String> checkPayAccess(DynamicObject[] bills, Map<String, String> variables, boolean isFullNodeCtrl, boolean isBlackList) {
        logger.info("\u8c03\u7528\u652f\u4ed8\u51c6\u5165\u68c0\u67e5\u65b9\u6cd5");
        Map<Object, String> result = new PayAccessCheckServiceImpl().checkPayAccess(bills, variables, isFullNodeCtrl, isBlackList);
        logger.info("\u8c03\u7528\u652f\u4ed8\u51c6\u5165\u68c0\u67e5\u7ed3\u675f");
        return result;
    }

    public void deletePayAccess(Set<Object> idSet) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                logger.info("\u8c03\u7528\u652f\u4ed8\u51c6\u5165\u5220\u9664\u94fe\u8def\u6570\u636e\u65b9\u6cd5");
                new PayAccessModifyServiceImpl().deletePayAccess(idSet);
                logger.info("\u8c03\u7528\u652f\u4ed8\u51c6\u5165\u5220\u9664\u94fe\u8def\u6570\u636e\u7ed3\u675f");
            }
            catch (Exception ee) {
                tx.markRollback();
                throw ee;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> savePayAccessAndCheckRepeat(DynamicObject[] bills, String opKey, Map<String, String> variables) throws InterruptedException {
        List<String> requestIds;
        block18: {
            requestIds = new ArrayList<String>(10);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    logger.info("\u68c0\u67e5\u7ed3\u679c\uff1a" + variables.get("checkResult"));
                    logger.info("\u8c03\u7528\u652f\u4ed8\u51c6\u5165\u4fdd\u5b58\u94fe\u8def\u6570\u636e\u65b9\u6cd5");
                    new PayAccessModifyServiceImpl().savePayAccess(bills, variables);
                    logger.info("\u8c03\u7528\u652f\u4ed8\u51c6\u5165\u4fdd\u5b58\u94fe\u8def\u6570\u636e\u7ed3\u675f");
                    DynamicObjectType destType = bills[0].getDynamicObjectType();
                    DynamicObject ctrlNode = PayAccessHelper.getPayAccessNode();
                    if (ctrlNode == null) break block18;
                    boolean isWorkFlow = variables.containsKey("WF") || variables.containsKey("wf");
                    boolean isFullNodeCtrl = PayAccessHelper.isFullNodeCtrl();
                    boolean isAsync = PayAccessHelper.isAsync();
                    boolean isBlackList = PayAccessHelper.isInBlackList((String)destType.getName());
                    if (isFullNodeCtrl && !isAsync && !isBlackList) {
                        logger.info("\u5f02\u6b65\u8c03\u7528\u9632\u91cd\u670d\u52a1");
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("opKey", opKey);
                        paramMap.put("billEntity", destType);
                        paramMap.put("isWorkFlow", isWorkFlow);
                        paramMap.put("data", DynamicObjectSerializeUtil.serialize((Object[])bills, (DynamicObjectType)destType));
                        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "fcs.checkrepeat");){
                            pub.publish(paramMap);
                            break block18;
                        }
                    }
                    logger.info("\u540c\u6b65\u6b65\u8c03\u7528\u9632\u91cd\u670d\u52a1");
                    PayAccessRepeatCtrlServiceImpl service = new PayAccessRepeatCtrlServiceImpl();
                    requestIds = service.checkRepeat(bills, opKey, isWorkFlow);
                }
                catch (Exception ee) {
                    logger.error((Throwable)ee);
                    tx.markRollback();
                    throw ee;
                }
            }
        }
        return requestIds;
    }
}

