/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.paymonitor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.GaussianConfig;
import kd.tmc.fcs.common.dao.GaussianInfo;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.RiskServiceHelper;
import org.apache.commons.math3.distribution.NormalDistribution;

public class GaussianService {
    private static final Log logger = LogFactory.getLog(GaussianService.class);

    public List<RiskItemResult> diagnosis(List<Long> billIdList, DynamicObject itemConfig) {
        ArrayList<RiskItemResult> result = new ArrayList<RiskItemResult>(10);
        String billNumber = itemConfig.getDynamicObject("appbill").getString("number");
        DynamicObjectCollection filterEntry = itemConfig.getDynamicObjectCollection("filterentry");
        ConditionFactory factory = new ConditionFactory();
        Double limit = 0.05;
        if (EmptyUtil.isNoEmpty((BigDecimal)itemConfig.getBigDecimal("limitvalue"))) {
            try {
                limit = itemConfig.getBigDecimal("limitvalue").doubleValue();
            }
            catch (Exception e) {
                logger.info("GaussianService-paramError-limitvalue");
            }
        }
        for (DynamicObject one : filterEntry) {
            Set<Long> matchIds = new HashSet<Long>(billIdList);
            String filterCondition = one.getString("flcondition_tag");
            if (EmptyUtil.isNoEmpty((String)filterCondition)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)filterCondition, CRCondition.class);
                factory.init(conditionObj, billNumber);
                matchIds = factory.runCondition(matchIds);
                if (EmptyUtil.isEmpty(matchIds)) continue;
            }
            logger.info("GaussianService-step-start:" + System.currentTimeMillis());
            DynamicObjectCollection paramList = one.getDynamicObjectCollection("paramentry");
            GaussianConfig paramConfig = GaussianConfig.buildParam((DynamicObjectCollection)paramList);
            String scope = one.getString("flobjscope_tag");
            CRCondition filterCondition_object = (CRCondition)SerializationUtils.fromJsonString((String)scope, CRCondition.class);
            String objBillNumber = one.getDynamicObject("flobject").getString("number");
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)objBillNumber), filterCondition_object.getFilterCondition(), true);
            fb.buildFilter(true);
            QFilter filte_object = fb.getQFilter();
            DataSet srcDs = QueryServiceHelper.queryDataSet((String)"queryGaussianSrcData", (String)billNumber, (String)paramConfig.getSelectSrc(), (QFilter[])new QFilter[]{new QFilter("id", "in", matchIds)}, (String)"");
            HashMap<Object, ArrayList<GaussianInfo>> rej = new HashMap<Object, ArrayList<GaussianInfo>>(16);
            ArrayList<GaussianInfo> real = new ArrayList<GaussianInfo>(10);
            boolean needRej = EmptyUtil.isNoEmpty((String)paramConfig.getRejectAcctBank());
            while (srcDs.hasNext()) {
                Row row = srcDs.next();
                GaussianInfo gaussianInfo = new GaussianInfo();
                gaussianInfo.setId(row.getLong("id"));
                gaussianInfo.setBillNo(row.getString("billno"));
                gaussianInfo.setSrcAmount(row.getBigDecimal(paramConfig.getSrcAmount()));
                if (EmptyUtil.isNoEmpty((String)paramConfig.getSrcOrg())) {
                    gaussianInfo.setSrcOrgId(row.getLong(paramConfig.getSrcOrg() + ".id"));
                }
                if (EmptyUtil.isNoEmpty((String)paramConfig.getSrcAcctBank())) {
                    gaussianInfo.setSrcAcctBankId(row.getLong(paramConfig.getSrcAcctBank() + ".id"));
                }
                if (needRej) {
                    String acctBankLeftReject = row.getString(paramConfig.getRejectAcctBank());
                    gaussianInfo.setRejAcctBank(acctBankLeftReject);
                    ArrayList<GaussianInfo> rejList = (ArrayList<GaussianInfo>)rej.get(acctBankLeftReject);
                    if (EmptyUtil.isEmpty((Collection)rejList)) {
                        rejList = new ArrayList<GaussianInfo>(10);
                        rej.put(acctBankLeftReject, rejList);
                    }
                    rejList.add(gaussianInfo);
                    continue;
                }
                real.add(gaussianInfo);
            }
            logger.info("GaussianService-step-querySrc:" + System.currentTimeMillis());
            if (needRej) {
                QFilter accountRejectFilter = new QFilter("bankaccountnumber", "in", rej.keySet());
                Set existABs = RiskServiceHelper.getAccountNumberByFilter((QFilter[])accountRejectFilter.toArray());
                for (Map.Entry o : rej.entrySet()) {
                    if (existABs.contains(o.getKey())) continue;
                    real.addAll((Collection)o.getValue());
                }
            }
            logger.info("GaussianService-step-real:" + System.currentTimeMillis() + "-size:" + real.size());
            for (GaussianInfo info : real) {
                logger.info("id:" + info.getId() + ">>GaussianService-step-risk:" + System.currentTimeMillis());
                QFilter copy = filte_object.copy();
                if (EmptyUtil.isNoEmpty((String)paramConfig.getFilterOrg())) {
                    copy.and(new QFilter(paramConfig.getFilterOrg() + ".id", "=", (Object)info.getSrcOrgId()));
                }
                if (EmptyUtil.isNoEmpty((String)paramConfig.getFilterAcctBank())) {
                    copy.and(new QFilter(paramConfig.getFilterAcctBank() + ".id", "=", (Object)info.getSrcAcctBankId()));
                }
                DataSet objectDs = QueryServiceHelper.queryDataSet((String)"queryGaussianUsedData", (String)objBillNumber, (String)paramConfig.getSelectCol(), (QFilter[])new QFilter[]{copy}, (String)"");
                Double levelValue = this.getLevelValue(info.getId(), objectDs, paramConfig.getColAmount(), info.getSrcAmount());
                if (levelValue == null || levelValue.compareTo(1.0 - limit) <= 0) continue;
                RiskItemResult riskItemResult = new RiskItemResult();
                riskItemResult.setDataType(billNumber);
                riskItemResult.setBillId(info.getId());
                riskItemResult.setBillNo(info.getBillNo());
                String rate = String.format("%.4f", 1.0 - levelValue);
                riskItemResult.setErrorDescDetail(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u8be5\u7ec4\u7ec7\u5386\u53f2\u6240\u6709\u4ea4\u6613\u7684\u4ea4\u6613\u91d1\u989d\u5747\u8f83\u5c0f\uff0c\u4f46\u672c\u5355\u4e1a\u52a1\u7684\u4ea4\u6613\u91d1\u989d\u8f83\u5927\uff08%1$s\uff1a\u6982\u7387%2$s\uff09\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"GaussianService_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]), info.getSrcAmount(), rate));
                result.add(riskItemResult);
            }
            logger.info("GaussianService-step-end:" + System.currentTimeMillis());
        }
        return result;
    }

    private Double getLevelValue(Long id, DataSet ds, String amtFiled, BigDecimal calValue) {
        BigDecimal sum = BigDecimal.ZERO;
        ArrayList<BigDecimal> simples = new ArrayList<BigDecimal>(10);
        while (ds.hasNext()) {
            Row row = ds.next();
            BigDecimal one = row.getBigDecimal(amtFiled);
            if (id.equals(row.getLong("id"))) continue;
            sum = sum.add(one);
            simples.add(one);
        }
        logger.info("id:" + id + ">>GaussianService-step-isRisk:" + System.currentTimeMillis() + "-simpleSize:" + simples.size());
        if (simples.size() == 0) {
            return null;
        }
        BigDecimal average = sum.divide(BigDecimal.valueOf(simples.size()), 2, RoundingMode.HALF_UP);
        BigDecimal standardDeviation = BigDecimal.ZERO;
        for (BigDecimal one : simples) {
            standardDeviation = standardDeviation.add(one.subtract(average).pow(2));
        }
        standardDeviation = standardDeviation.divide(BigDecimal.valueOf(simples.size()), 2, RoundingMode.HALF_UP);
        double standDev = Math.sqrt(standardDeviation.doubleValue());
        standardDeviation = BigDecimal.valueOf(standDev);
        NormalDistribution nds = new NormalDistribution(average.doubleValue(), standDev);
        double temp = nds.cumulativeProbability(calValue.doubleValue());
        return temp;
    }
}

