/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.paymonitor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.http.HttpHelper;
import kd.tmc.fcs.common.dao.ProPhetConfig;
import kd.tmc.fcs.common.dao.ProPhetInfo;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.RiskServiceHelper;

public class ProPhetService {
    private static final Log logger = LogFactory.getLog(ProPhetService.class);

    public List<RiskItemResult> diagnosisDate(List<Long> billIdList, DynamicObject itemConfig) {
        return this.diagnosis(billIdList, itemConfig, "date");
    }

    private List<Map<String, Object>> buildRequest_Date(String dateField, String objBillNumber, String select, QFilter qFilter) {
        String dateFormatStr = "to_char(" + dateField + ", 'yyyy-MM-dd 00:00:000')";
        DataSet objectDs = QueryServiceHelper.queryDataSet((String)"queryProPhetUsedData", (String)objBillNumber, (String)select, (QFilter[])new QFilter[]{qFilter}, (String)dateField);
        objectDs = objectDs.addField(dateFormatStr, "formatdateS").groupBy(new String[]{"formatdateS"}).count().finish();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        while (objectDs.hasNext()) {
            Row temp = objectDs.next();
            HashMap<String, Object> tempP = new HashMap<String, Object>();
            tempP.put("ds", temp.getString("formatdateS").replace(" ", "T"));
            tempP.put("y", temp.getInteger("count"));
            list.add(tempP);
        }
        return list;
    }

    private void dealRiskItemResult_Date(String billNumber, ProPhetInfo info, List<Map<String, Object>> pyResult, List<RiskItemResult> result) {
        if (!pyResult.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:000");
            String checkDateS = dateFormat.format(info.getSrcDate()).replace(" ", "T");
            for (Map<String, Object> temp : pyResult) {
                if (!temp.get("ds").equals(checkDateS)) continue;
                RiskItemResult riskItemResult = new RiskItemResult();
                riskItemResult.setDataType(billNumber);
                riskItemResult.setBillId(info.getId());
                riskItemResult.setBillNo(info.getBillNo());
                riskItemResult.setErrorDescDetail(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u8be5\u7ec4\u7ec7\u672c\u5355\u4e1a\u52a1\u4ea4\u6613\u5c5e\u4e8e\u4e00\u5b9a\u65f6\u95f4\u8303\u56f4\u5185\u5bb9\u7684\u9ad8\u9891\u4ea4\u6613\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"ProPhetService_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                result.add(riskItemResult);
                break;
            }
        }
    }

    public List<RiskItemResult> diagnosisTime(List<Long> billIdList, DynamicObject itemConfig) {
        return this.diagnosis(billIdList, itemConfig, "time");
    }

    private List<RiskItemResult> diagnosis(List<Long> billIdList, DynamicObject itemConfig, String type) {
        ArrayList<RiskItemResult> result = new ArrayList<RiskItemResult>(10);
        String billNumber = itemConfig.getDynamicObject("appbill").getString("number");
        DynamicObjectCollection filterEntry = itemConfig.getDynamicObjectCollection("filterentry");
        ConditionFactory factory = new ConditionFactory();
        Double limit = 0.05;
        if (EmptyUtil.isNoEmpty((BigDecimal)itemConfig.getBigDecimal("limitvalue"))) {
            try {
                limit = itemConfig.getBigDecimal("limitvalue").doubleValue();
            }
            catch (Exception e) {
                logger.info("ProPhetService-paramError-limitvalue");
            }
        }
        for (DynamicObject one : filterEntry) {
            Set<Long> matchIds = new HashSet<Long>(billIdList);
            logger.info("ProPhetService-step-start:" + System.currentTimeMillis());
            String filterCondition = one.getString("flcondition_tag");
            if (EmptyUtil.isNoEmpty((String)filterCondition)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)filterCondition, CRCondition.class);
                factory.init(conditionObj, billNumber);
                matchIds = factory.runCondition(matchIds);
                if (EmptyUtil.isEmpty(matchIds)) continue;
            }
            logger.info("ProPhetService-step-filter:" + System.currentTimeMillis());
            DynamicObjectCollection paramList = one.getDynamicObjectCollection("paramentry");
            ProPhetConfig paramConfig = ProPhetConfig.buildParam((DynamicObjectCollection)paramList);
            String sel_src = paramConfig.getSelectSrc();
            String scope = one.getString("flobjscope_tag");
            CRCondition filterCondition_object = (CRCondition)SerializationUtils.fromJsonString((String)scope, CRCondition.class);
            String objBillNumber = one.getDynamicObject("flobject").getString("number");
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)objBillNumber), filterCondition_object.getFilterCondition(), true);
            fb.buildFilter(true);
            QFilter filte_object = fb.getQFilter();
            DataSet srcDs = QueryServiceHelper.queryDataSet((String)"queryProPhetSrcData", (String)billNumber, (String)sel_src, (QFilter[])new QFilter[]{new QFilter("id", "in", matchIds)}, (String)"");
            HashMap<Object, ArrayList<ProPhetInfo>> rej = new HashMap<Object, ArrayList<ProPhetInfo>>(16);
            ArrayList<ProPhetInfo> real = new ArrayList<ProPhetInfo>(10);
            boolean needRej = EmptyUtil.isNoEmpty((String)paramConfig.getRejectAcctBank());
            while (srcDs.hasNext()) {
                Row srcBill = srcDs.next();
                ProPhetInfo info = new ProPhetInfo();
                info.setId(srcBill.getLong("id"));
                info.setBillNo(srcBill.getString("billno"));
                info.setSrcDate(srcBill.getDate(paramConfig.getSrcDate()));
                if (EmptyUtil.isNoEmpty((String)paramConfig.getSrcOrg())) {
                    info.setSrcOrgId(srcBill.getLong(paramConfig.getSrcOrg() + ".id"));
                }
                if (EmptyUtil.isNoEmpty((String)paramConfig.getSrcAcctBank())) {
                    info.setSrcAcctBankId(srcBill.getLong(paramConfig.getSrcAcctBank() + ".id"));
                }
                if (needRej) {
                    String acctbankReject = srcBill.getString(paramConfig.getRejectAcctBank());
                    ArrayList<ProPhetInfo> rejList = (ArrayList<ProPhetInfo>)rej.get(acctbankReject);
                    if (EmptyUtil.isEmpty((Collection)rejList)) {
                        rejList = new ArrayList<ProPhetInfo>(10);
                        rej.put(acctbankReject, rejList);
                    }
                    rejList.add(info);
                    continue;
                }
                real.add(info);
            }
            logger.info("ProPhetService-step-querySrc:" + System.currentTimeMillis());
            if (needRej) {
                QFilter accountRejectFilter = new QFilter("bankaccountnumber", "in", rej.keySet());
                Set existABs = RiskServiceHelper.getAccountNumberByFilter((QFilter[])accountRejectFilter.toArray());
                for (Map.Entry o : rej.entrySet()) {
                    if (existABs.contains(o.getKey())) continue;
                    real.addAll((Collection)o.getValue());
                }
            }
            logger.info("ProPhetService-step-exist:" + System.currentTimeMillis());
            for (ProPhetInfo info : real) {
                List<Map<String, Object>> pyResult;
                List<Map<String, Object>> list;
                QFilter copy = filte_object.copy();
                if (EmptyUtil.isNoEmpty((String)paramConfig.getFilterOrg())) {
                    copy.and(new QFilter(paramConfig.getFilterOrg(), "=", (Object)info.getSrcOrgId()));
                }
                if (EmptyUtil.isNoEmpty((String)paramConfig.getFilterAcctBank())) {
                    copy.and(new QFilter(paramConfig.getFilterAcctBank(), "=", (Object)info.getSrcAcctBankId()));
                }
                if ("time".equals(type) && (list = this.buildRequest_Time(paramConfig.getColDate(), objBillNumber, paramConfig.getColDate(), copy)).size() > 2) {
                    pyResult = this.getPyResponse(list, "/getwarntime");
                    this.dealRiskItemResult_Time(billNumber, info, pyResult, result);
                }
                if ("date".equals(type) && (list = this.buildRequest_Date(paramConfig.getColDate(), objBillNumber, paramConfig.getColDate(), copy)).size() > 2) {
                    pyResult = this.getPyResponse(list, "/getwarndate");
                    this.dealRiskItemResult_Date(billNumber, info, pyResult, result);
                }
                if (!"timezone".equals(type)) continue;
                String dateFormatStr = "to_char(" + paramConfig.getColDate() + ", 'HH:00:000')";
                DataSet objectDs = QueryServiceHelper.queryDataSet((String)"queryProPhetUsedData", (String)objBillNumber, (String)paramConfig.getColDate(), (QFilter[])new QFilter[]{copy}, (String)paramConfig.getColDate());
                objectDs = objectDs.addField(dateFormatStr, "formatdateS").groupBy(new String[]{"formatdateS"}).count().finish();
                HashMap<String, Integer> pieData = new HashMap<String, Integer>(16);
                int sum = 0;
                while (objectDs.hasNext()) {
                    Row temp = objectDs.next();
                    pieData.put(temp.getString("formatdateS"), temp.getInteger("count"));
                    sum += temp.getInteger("count").intValue();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:00:000");
                String checkDateS = dateFormat.format(info.getSrcDate());
                Integer pieInt = (Integer)pieData.get(checkDateS);
                logger.info("id:" + info.getId() + ">>ProPhetService-step-result:" + System.currentTimeMillis() + "-sum:" + sum + "-pie:" + pieInt);
                if (pieInt == null) {
                    pieInt = 0;
                }
                if (sum == 0) {
                    RiskItemResult riskItemResult = new RiskItemResult();
                    riskItemResult.setDataType(billNumber);
                    riskItemResult.setBillId(info.getId());
                    riskItemResult.setBillNo(info.getBillNo());
                    riskItemResult.setErrorDescDetail(ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u65f6\u95f4\u8303\u56f4\u5185\u65e0\u9700\u8981\u5206\u6790\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5224\u65ad\u4ea4\u6613\u65f6\u95f4\u662f\u5426\u5f02\u5e38\u3002", (String)"ProPhetService_3", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    result.add(riskItemResult);
                    continue;
                }
                BigDecimal ratio = BigDecimal.valueOf(pieInt.intValue()).divide(BigDecimal.valueOf(sum), 6, RoundingMode.HALF_UP);
                if (!(ratio.doubleValue() < limit)) continue;
                RiskItemResult riskItemResult = new RiskItemResult();
                riskItemResult.setDataType(billNumber);
                riskItemResult.setBillId(info.getId());
                riskItemResult.setBillNo(info.getBillNo());
                String ratioDouble = String.format("%.4f", ratio.doubleValue());
                riskItemResult.setErrorDescDetail(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u8be5\u7ec4\u7ec7\u672c\u5355\u4e1a\u52a1\u4ea4\u6613\u65f6\u95f4\u5c5e\u4e8e\u5f02\u5e38\u65f6\u95f4\u8303\u56f4\u5185\uff08\u6982\u7387\uff1a%s\uff09\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"ProPhetService_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]), ratioDouble));
                result.add(riskItemResult);
            }
            logger.info("ProPhetService-step-end:" + System.currentTimeMillis());
        }
        return result;
    }

    private List<Map<String, Object>> buildRequest_Time(String dateField, String objBillNumber, String select, QFilter qFilter) {
        String dateFormatStr = "to_char(" + dateField + ", 'yyyy-MM-dd HH:00:000')";
        DataSet objectDs = QueryServiceHelper.queryDataSet((String)"queryProPhetUsedData", (String)objBillNumber, (String)select, (QFilter[])new QFilter[]{qFilter}, (String)dateField);
        objectDs = objectDs.addField(dateFormatStr, "formatdateS").groupBy(new String[]{"formatdateS"}).count().finish();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        while (objectDs.hasNext()) {
            Row temp = objectDs.next();
            HashMap<String, Object> tempP = new HashMap<String, Object>();
            tempP.put("ds", temp.getString("formatdateS").replace(" ", "T"));
            tempP.put("y", temp.getInteger("count"));
            list.add(tempP);
        }
        return list;
    }

    private void dealRiskItemResult_Time(String billNumber, ProPhetInfo info, List<Map<String, Object>> pyResult, List<RiskItemResult> result) {
        if (!pyResult.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:00:000");
            String checkDateS = dateFormat.format(info.getSrcDate()).replace(" ", "T");
            for (Map<String, Object> temp : pyResult) {
                if (!temp.get("ds").equals(checkDateS)) continue;
                RiskItemResult riskItemResult = new RiskItemResult();
                riskItemResult.setDataType(billNumber);
                riskItemResult.setBillId(info.getId());
                riskItemResult.setBillNo(info.getBillNo());
                riskItemResult.setErrorDescDetail(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u8be5\u7ec4\u7ec7\u672c\u5355\u4e1a\u52a1\u4ea4\u6613\u65f6\u95f4\u5c5e\u4e8e\u5f02\u5e38\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"ProPhetService_2", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                result.add(riskItemResult);
                break;
            }
        }
    }

    public List<Map<String, Object>> getPyResponse(List<Map<String, Object>> paramList, String method) {
        List<Map<String, Object>> resMap = new ArrayList<Map<String, Object>>(10);
        String url = RiskServiceHelper.getRiskServerPath() + method;
        try {
            String req = SerializationUtils.toJsonString(paramList);
            String response = HttpHelper.doPost((String)url, (String)req, (int)5000);
            resMap = (List)SerializationUtils.fromJsonString((String)response, resMap.getClass());
        }
        catch (Exception e) {
            logger.error("ProPhetService:", (Throwable)e);
        }
        return resMap;
    }

    public List<RiskItemResult> diagnosisTimeZone(List<Long> billIdList, DynamicObject itemConfig) {
        return this.diagnosis(billIdList, itemConfig, "timezone");
    }
}

