/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.paymonitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.fcs.extpoint.paymonitor.IRelationShipJob;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.RelationShipConfig;
import kd.tmc.fcs.common.dao.RelationShipInfo;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.RiskServiceHelper;

public class RelationShipService {
    private static final Log logger = LogFactory.getLog(RelationShipService.class);

    public List<RiskItemResult> diagnosisSelf(List<Long> billIdList, DynamicObject itemConfig) {
        ArrayList<RiskItemResult> result = new ArrayList<RiskItemResult>();
        String billNumber = itemConfig.getDynamicObject("appbill").getString("number");
        DynamicObjectCollection filterEntry = itemConfig.getDynamicObjectCollection("filterentry");
        for (DynamicObject one : filterEntry) {
            DynamicObjectCollection paramList = one.getDynamicObjectCollection("paramentry");
            RelationShipConfig paramConfig = RelationShipConfig.buildSelfParam((DynamicObjectCollection)paramList);
            logger.info("diagnosisSelf-step-start:" + System.currentTimeMillis());
            DataSet srcDs = QueryServiceHelper.queryDataSet((String)"queryRelationSrcData", (String)billNumber, (String)paramConfig.getSelectForSelf(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIdList)}, (String)"");
            while (srcDs.hasNext()) {
                String filterAcct;
                QFilter accountFilter;
                Row row = srcDs.next();
                String id = row.getString("id");
                String searchA = row.getString(paramConfig.getOrgCheckLeft());
                String searchB = row.getString(paramConfig.getOrgCheckRight());
                logger.info("id:" + id + ">>diagnosisSelf-step2-querySrc:" + System.currentTimeMillis());
                if (EmptyUtil.isNoEmpty((String)paramConfig.getAcctBankSelfReject()) && QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])(accountFilter = new QFilter("bankaccountnumber", "=", (Object)(filterAcct = row.getString(paramConfig.getAcctBankSelfReject())))).toArray())) continue;
                logger.info("id:" + id + ">>diagnosisSelf-step3-exist:" + System.currentTimeMillis());
                DataSet ds = QueryServiceHelper.queryDataSet((String)"queryRelation", (String)paramConfig.getRelationShip(), (String)paramConfig.getRelationShipField(), (QFilter[])new QFilter[]{new QFilter(paramConfig.getRelationShipField(), "like", (Object)("%" + searchA + "%"))}, (String)"");
                HashSet relationSet = new HashSet();
                while (ds.hasNext()) {
                    Row oneShip = ds.next();
                    Set temp = Arrays.stream(oneShip.getString(paramConfig.getRelationShipField()).split("\u3001")).collect(Collectors.toSet());
                    if (!temp.contains(searchA)) continue;
                    relationSet.addAll(temp);
                }
                relationSet.remove(searchA);
                logger.info("id:" + id + ">>diagnosisSelf-step4-queryRelation:" + System.currentTimeMillis());
                if (relationSet.contains(searchB)) {
                    RiskItemResult riskItemResult = new RiskItemResult();
                    riskItemResult.setDataType(billNumber);
                    riskItemResult.setBillId(row.getLong("id"));
                    riskItemResult.setBillNo(row.getString("billno"));
                    riskItemResult.setErrorDescDetail(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u5f53\u524d\u4ea4\u6613\u7684\u6536\u4ed8\u6b3e\u65b9\u5b58\u5728\u5173\u8054\u5173\u7cfb:%1$s->%2$s\u3002", (String)"RelationShipService_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]), searchA, searchB));
                    result.add(riskItemResult);
                    continue;
                }
                this.doExtJob(searchA, searchB, relationSet);
            }
            logger.info("diagnosisSelf-step-end:" + System.currentTimeMillis());
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     */
    public List<RiskItemResult> diagnosisRelation(List<Long> billIdList, DynamicObject itemConfig) {
        ArrayList<RiskItemResult> result = new ArrayList<RiskItemResult>();
        String billNumber = itemConfig.getDynamicObject("appbill").getString("number");
        DynamicObjectCollection filterEntry = itemConfig.getDynamicObjectCollection("filterentry");
        ConditionFactory factory = new ConditionFactory();
        for (DynamicObject one : filterEntry) {
            Set<Long> matchIds = new HashSet<Long>(billIdList);
            logger.info("diagnosisRelation-step-start:" + System.currentTimeMillis());
            String filterCondition = one.getString("flcondition_tag");
            if (EmptyUtil.isNoEmpty((String)filterCondition)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)filterCondition, CRCondition.class);
                factory.init(conditionObj, billNumber);
                matchIds = factory.runCondition(matchIds);
                if (EmptyUtil.isEmpty(matchIds)) continue;
            }
            logger.info("diagnosisRelation-step-filter:" + System.currentTimeMillis());
            DynamicObjectCollection paramList = one.getDynamicObjectCollection("paramentry");
            RelationShipConfig paramConfig = RelationShipConfig.buildBothParam((DynamicObjectCollection)paramList);
            DataSet srcDs = QueryServiceHelper.queryDataSet((String)"queryRelationSrcData", (String)billNumber, (String)paramConfig.getSelectForBothSelf(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIdList)}, (String)"");
            boolean needRejSelf = EmptyUtil.isNoEmpty((String)paramConfig.getAcctBankSelfReject());
            ArrayList<RelationShipInfo> real = new ArrayList<RelationShipInfo>(10);
            HashMap<Object, ArrayList<RelationShipInfo>> rej = new HashMap<Object, ArrayList<RelationShipInfo>>(16);
            while (srcDs.hasNext()) {
                Row row = srcDs.next();
                RelationShipInfo info = new RelationShipInfo();
                info.setId(row.getLong("id"));
                info.setBillNo(row.getString("billno"));
                info.setSrcOrgId(row.getLong(paramConfig.getSrcOrg()));
                info.setSrcRelation(row.getString(paramConfig.getOrgCheckLeft()));
                if (needRejSelf) {
                    String acctBankLeftReject = row.getString(paramConfig.getAcctBankSelfReject());
                    ArrayList<RelationShipInfo> rejList = (ArrayList<RelationShipInfo>)rej.get(acctBankLeftReject);
                    if (EmptyUtil.isEmpty((Collection)rejList)) {
                        rejList = new ArrayList<RelationShipInfo>(10);
                        rej.put(acctBankLeftReject, rejList);
                    }
                    rejList.add(info);
                    continue;
                }
                real.add(info);
            }
            logger.info("diagnosisRelation-step-querySrc:" + System.currentTimeMillis());
            if (needRejSelf) {
                QFilter accountRejectFilter = new QFilter("bankaccountnumber", "in", rej.keySet());
                Set existABs = RiskServiceHelper.getAccountNumberByFilter((QFilter[])accountRejectFilter.toArray());
                for (Map.Entry o : rej.entrySet()) {
                    if (existABs.contains(o.getKey())) continue;
                    real.addAll((Collection)o.getValue());
                }
            }
            logger.info("diagnosisRelation-step-existSrc:" + System.currentTimeMillis() + "-size:" + real.size());
            String objBillNumber = one.getDynamicObject("flobject").getString("number");
            QFilter filte_object = null;
            if (real.size() > 0) {
                String scope = one.getString("flobjscope_tag");
                CRCondition filterCondition_object = (CRCondition)SerializationUtils.fromJsonString((String)scope, CRCondition.class);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)objBillNumber), filterCondition_object.getFilterCondition(), true);
                fb.buildFilter(true);
                filte_object = fb.getQFilter();
            }
            for (RelationShipInfo info : real) {
                Long id = info.getId();
                String searchA = info.getSrcRelation();
                logger.info("id:" + id + ">>diagnosisRelation-step1-start:" + System.currentTimeMillis());
                DataSet objectDs = QueryServiceHelper.queryDataSet((String)"queryRelationObjData", (String)objBillNumber, (String)paramConfig.getSelectForBothObj(), (QFilter[])new QFilter[]{new QFilter(paramConfig.getFilterOrg(), "=", (Object)info.getSrcOrgId()), filte_object}, (String)"");
                HashMap<String, HashSet<String>> acctBank_Relation = new HashMap<String, HashSet<String>>(16);
                HashSet<String> objSet = new HashSet<String>(16);
                Boolean isRejObj = EmptyUtil.isNoEmpty((String)paramConfig.getAcctBankObjReject());
                while (objectDs.hasNext()) {
                    Row objRow = objectDs.next();
                    if (isRejObj.booleanValue()) {
                        String acctBankRightReject = objRow.getString(paramConfig.getAcctBankObjReject());
                        HashSet<String> col = (HashSet<String>)acctBank_Relation.get(acctBankRightReject);
                        if (EmptyUtil.isEmpty((Collection)col)) {
                            col = new HashSet<String>();
                            acctBank_Relation.put(acctBankRightReject, col);
                        }
                        col.add(objRow.getString(paramConfig.getOrgCheckRight()));
                        continue;
                    }
                    objSet.add(objRow.getString(paramConfig.getOrgCheckRight()));
                }
                logger.info("id:" + id + ">>diagnosisRelation-step2-queryObj:" + System.currentTimeMillis() + "-acctBankRelationSize:" + acctBank_Relation.size());
                if (isRejObj.booleanValue()) {
                    if (acctBank_Relation.size() == 0) continue;
                    QFilter accountRejectFilter = new QFilter("bankaccountnumber", "in", acctBank_Relation.keySet());
                    Set existABs = RiskServiceHelper.getAccountNumberByFilter((QFilter[])accountRejectFilter.toArray());
                    for (Map.Entry o : acctBank_Relation.entrySet()) {
                        if (existABs.contains(o.getKey())) continue;
                        objSet.addAll((Collection)o.getValue());
                    }
                }
                objSet.remove(searchA);
                logger.info("id:" + id + ">>diagnosisRelation-step3-exist:" + System.currentTimeMillis() + "-objSetSize:" + objSet.size());
                if (objSet.size() == 0) continue;
                DataSet ds = QueryServiceHelper.queryDataSet((String)"queryRelation", (String)paramConfig.getRelationShip(), (String)paramConfig.getRelationShipField(), (QFilter[])new QFilter[]{new QFilter(paramConfig.getRelationShipField(), "like", (Object)("%" + searchA + "%"))}, (String)"");
                HashSet relationSet = new HashSet();
                while (ds.hasNext()) {
                    Row oneShip = ds.next();
                    Set temp = Arrays.stream(oneShip.getString(paramConfig.getRelationShipField()).split("\u3001")).collect(Collectors.toSet());
                    if (!temp.contains(searchA)) continue;
                    relationSet.addAll(temp);
                }
                relationSet.remove(searchA);
                logger.info("id:" + id + ">>diagnosisRelation-step4-queryRelation:" + System.currentTimeMillis() + "-relationSetSize:" + relationSet.size());
                StringBuilder relationLink = new StringBuilder();
                for (String obj : objSet) {
                    if (!relationSet.contains(obj)) continue;
                    relationLink.append(obj).append('\u3001');
                }
                int index = relationLink.toString().lastIndexOf(12289);
                if (index > 0) {
                    RiskItemResult riskItemResult = new RiskItemResult();
                    riskItemResult.setDataType(billNumber);
                    riskItemResult.setBillId(info.getId());
                    riskItemResult.setBillNo(info.getBillNo());
                    riskItemResult.setErrorDescDetail(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u5f53\u524d\u4ea4\u6613\u7684\u5bf9\u65b9\u5355\u4f4d\u4e0e\u5386\u53f2\u5df2\u53d1\u751f\u4ea4\u6613\u7684\u5bf9\u65b9\u5355\u4f4d\u5b58\u5728\u5173\u8054\u5173\u7cfb:%1$s->%2$s\u3002", (String)"RelationShipService_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]), searchA, relationLink.substring(0, index)));
                    result.add(riskItemResult);
                    continue;
                }
                this.doExtJob(searchA, null, relationSet);
            }
            logger.info("diagnosisRelation-step-end:" + System.currentTimeMillis());
        }
        return result;
    }

    private void doExtJob(String srcObj, String destObj, Set relationSet) {
        String flag = relationSet.size() == 0 ? "NotLink" : "HasLinkButNotFound";
        PluginProxy pluginProxy = PluginProxy.create(IRelationShipJob.class, (String)"kd.sdk.tmc.fcs.extpoint.paymonitor.IRelationShipJob");
        pluginProxy.callReplace(p -> {
            p.doExt(srcObj, destObj, flag);
            return new Object();
        });
    }
}

